#!/bin/sh
# *********************************************************************
# *  Licensed Materials - Property of IBM
# *  © Copyright IBM Corporation 2014, 2016. All Rights Reserved.
# *
# *  Note to U.S. Government Users Restricted Rights:
# *  Use, duplication or disclosure restricted by GSA ADP Schedule
# *  Contract with IBM Corp.
# *********************************************************************
# *
# *  This shell script is used to invoke the ISPF Gateway.
# *
# *********************************************************************
export PATH="${ENVPATH}"/isp/"${rtc.eid}":$PATH:/usr/lpp/ispf/bin
#
LOG_ISPF="${WRKPATH}"/isp/"${rtc.eid}"/LOGISPF.$$
#

echo "<?xml version=\"1.0\"?>
<ISPF-INPUT>
<SERVICE-REQUEST>
<service>ISPF</service>
<session>NONE</session>
<command>SELECT CMD($1 \"$2\" \"$3\" \"$4\" \"$5\" \"$6\" \"$7\" \"$8\" \"$9\" \"${10}\" \"${11}\") LANG(CREX) </command>
</SERVICE-REQUEST>
</ISPF-INPUT>" | ISPZXML >$LOG_ISPF
rc=0
grep "The initially invoked CLIST ended with a return code =" $LOG_ISPF
if [ $? -eq 0 ]
then
	rc=1
else
	grep "<RETURN-CODE>" $LOG_ISPF
	if [ $? -eq 0 ]
	then
		# Check RETURN CODE
		a=`sed -n -e 's/<RETURN-CODE>\(.*\)<.*/\1/p' $LOG_ISPF | sed -e '1 q'`
		if test $a != 0
		then
			rc=1
		fi
	else
		echo "The ISPF gateway is not configured correctly."
		rc=2
	fi	
fi
cat $LOG_ISPF
rm $LOG_ISPF
exit $rc
