#!/bin/sh
# *********************************************************************
# *  Licensed Materials - Property of IBM
# *  © Copyright IBM Corporation 2014, 2016. All Rights Reserved.
# *
# *  Note to U.S. Government Users Restricted Rights:
# *  Use, duplication or disclosure restricted by GSA ADP Schedule
# *  Contract with IBM Corp.
# *********************************************************************
# *
# *  This shell script is be used to start a z/OS Rational Build Forge
# *  Agent configured for internal tooling use.
# *
# *********************************************************************
export RTCPATH="${RTCHOME}"
export JBEPATH="${RTCPATH}"/buildsystem/buildengine/eclipse
export JDKPATH="${RTCPATH}"/jdk/bin/java
export SCRPATH="${RTCPATH}"/buildsystem/buildtoolkit/scripts/smpe
export BATPATH="${BATHOME}"/"${RTCPID}"/"${RTCNID}"
export PWDFILE="${BATPATH}"/.password
export AREA=$(cat "${BATPATH}"/engine.area)
export HOST=$(cat "${BATPATH}"/engine.host)
export USER=$(cat "${BATPATH}"/engine.user)
export JCLFILE="${BATPATH}"/.jclSubmitPassword
export JCLUSER=$(cat "${BATPATH}"/.jclSubmitUserId)
export ETCPATH="${ETCHOME}"/"${RTCPID}"/"${RTCNID}"/"${RTCSID}"
export SCMPATH="${ETCPATH}"/.jazz-scm
export WSPPATH="${ETCPATH}"/.workspace
export WRKPATH="${WRKHOME}"/"${RTCPID}"/"${RTCNID}"/"${RTCSID}"
export ETCCMMN="${ETCHOME}"/"${RTCPID}"/"${RTCNID}"/common
export WRKCMMN="${WRKHOME}"/"${RTCPID}"/"${RTCNID}"/common
export NAME="${RTCPID}"."${SERVER}"."${RTCSID}"
export OSXTFS=/
export OSXTQT=
#
#export HOME=@yourHomeDirectory@
#export ZLANG=@zLang@
#
export _CMDSERV_BASE_HOME="${ISPFHOME}"
export _INCLUDE_ENVIRONMENT=TRUE
export _PROPERTY_FILE="${IBMHOME}"/engine.properties
export _SUPPRESS_ENV_OUTPUT=ON
export _TEMPORARY_UNIT=SYSALLDA
export _TIMEOUT=7200
#
export BLD_TOOLKIT="${RTCHOME}"/buildsystem/buildtoolkit
export JBE_COMMAND="${JBEPATH}"/jbe
export JBE_WORKING_DIR="${SCRPATH}"
export SCM_WORK="${WRKPATH}"/scm
export SCM_CONFIG_DIRECTORY="${SCMPATH}"
export TMP=/tmp
#
export JAZZ_AUTH_METHOD=USERNAME_PASSWORD_POLICY
export JAZZ_USER=$(cat "${BATPATH}"/engine.user)
export JAZZ_PASSWORD_FILE="${BATPATH}"/.password
#
"${RTCHOME}"/buildagent/bfagent -s -f "${ETCPATH}"/ccm/bfagent.conf