#!/bin/sh
# *********************************************************************
# *  Licensed Materials - Property of IBM
# *  © Copyright IBM Corporation 2014, 2016. All Rights Reserved.
# *
# *  Note to U.S. Government Users Restricted Rights:
# *  Use, duplication or disclosure restricted by GSA ADP Schedule
# *  Contract with IBM Corp.
# *********************************************************************
# *
# *  This shell script is be used to start a Ant environment.
# *  
# *    /path/StartAnt ${jvm.com.arguments} /path/AntScript.xml target
# *
# *********************************************************************
#set
if [ -z "LIBPATH" ]
then
   export LIBPATH=/lib:/usr/lib:.
fi
LIBPATH="${BLD_TOOLKIT}":"${LIBPATH}"

# build properties
echo 'buildDefinitionId='${buildDefinitionId} > build.properties
echo 'buildEngineHostName='${buildEngineHostName} >> build.properties
echo 'buildEngineId='${buildEngineId} >> build.properties
echo 'buildLabel='${buildLabel} >> build.properties
echo 'buildRequesterUserId='${buildRequesterUserId} >> build.properties
echo 'buildResultUUID='${buildResultUUID} >> build.properties
echo 'engineUUID='${engineUUID} >> build.properties
echo 'jclSubmitPasswordFile='${jclSubmitPasswordFile} >> build.properties
echo 'jclSubmitUserId='${jclSubmitUserId} >> build.properties
echo 'passwordFile='${passwordFile} >> build.properties
echo 'projectArea='${projectArea} >> build.properties
echo 'repositoryAddress='${repositoryAddress} >> build.properties
echo 'requestUUID='${requestUUID} >> build.properties
echo 'userId='${userId} >> build.properties

# option properties
echo 'com.ibm.team.build.ant.reuseLoginOption=true' >> build.properties

# product path properties
echo 'dir.kit='${BLD_TOOLKIT} >> build.properties
echo 'dir.scm='${RTCPATH}'/scmtools/eclipse' >> build.properties
echo 'dir.smp='${BLD_TOOLKIT}'/scripts/smpe' >> build.properties

# install path properties
echo 'com.etc='${ETCCMMN} >> build.properties
echo 'com.wrk='${WRKCMMN}'/bld' >> build.properties
echo 'dir.etc='${ETCPATH} >> build.properties
echo 'dir.wrk='${WRKPATH}'/bld' >> build.properties

"${JAVA_HOME}"/bin/java -classpath "${ANT_HOME}"/lib/ant-launcher.jar -Xquickstart org.apache.tools.ant.launch.Launcher -f $1 $2 -lib "${BLD_TOOLKIT}" -lib "${BLD_TOOLKIT}"/extensions -propertyfile "${IBMHOME}"/common.properties -propertyfile ./build.properties
