/* REXX **************************************************************
 *                                                                   *
 *  Licensed Materials - Property of IBM                             *
 *  Copyright IBM Corporation 2014, 2017. All Rights Reserved.       *
 *                                                                   *
 *  Note to U.S. Government Users Restricted Rights:                 *
 *  Use, duplication or disclosure restricted by GSA ADP Schedule    *
 *  Contract with IBM Corp.                                          *
 *                                                                   *
 *********************************************************************
 *                                                                   *
 *  ------------                                                     *
 *  DtlDsnDelete                                                     *
 *  ------------                                                     *
 *                                                                   *
 *  Delete the SYSTSIN dataset used by DTL translators.              *
 *                                                                   *
 *  Function:                                                        *
 *                                                                   *
 *    Allocate the dataset that is used for ISPDTLC commands by      *
 *    the DTL compiler process with disposition DELETE.              *
 *                                                                   *
 *  Format:                                                          *
 *                                                                   *
 *    DtlDsnDelete __DSN(hlq,lbl,type,last)_(_options______________  *
 *                                                                   *
 *  Parameters:                                                      *
 *                                                                   *
 *    DSN(hlq,lbl,type,last)                                         *
 *      (Required) - Dataset name high level qualifier, the build    *
 *      label property ${buildLabel}, dataset type token (maximum    *
 *      8 characters), and last token (maximum 8 characters).        *
 *                                                                   *
 *  Options:                                                         *
 *                                                                   *
 *    None                                                           *
 *                                                                   *
 *  Return Codes:                                                    *
 *                                                                   *
 *    RC =  0  Command successful                                    *
 *          4  Parameter error                                       *
 *          8  Functional error                                      *
 *                                                                   *
 *  External References:                                             *
 *                                                                   *
 *    None                                                           *
 *                                                                   *
 *  Notes:                                                           *
 *                                                                   *
 *    None                                                           *
 *                                                                   *
 *-------------------------------------------------------------------*
 *                                                                   *
 *  Changes:                                                         *
 *                                                                   *
 *    Date       Rel   PTM/APAR Init Description                     *
 *    ---------- ----- -------- ---- ------------------------------- *
 *    2014-11-05 4.0.6          djr  Creation                        *
 *--------------------------------------------------------EWM 4.0.7--*
 *--------------------------------------------------------EWM 5.0.0--*
 *--------------------------------------------------------EWM 5.0.1--*
 *--------------------------------------------------------EWM 5.0.2--*
 *--------------------------------------------------------EWM 6.0.0--*
 *--------------------------------------------------------EWM 6.0.1--*
 *--------------------------------------------------------EWM 6.0.2--*
 *--------------------------------------------------------EWM 6.0.3--*
 *--------------------------------------------------------EWM 6.0.4--*
 *    2017-05-16 6.0.4          djr  EE integration                  *
 *--------------------------------------------------------EWM n.n.n--*
 *--------------------------------------------------------EWM n.n.n--*
 *********************************************************************/
parse source . typecall execfn execdd execds . execadr execenv exectkn .
parse upper arg args
parse upper value args with 'DSN(' hlq ',' lbl ',' type ',' last ')' .
parse upper value args with ' ( ' options
parse upper value args 'TRACE(O)' with 'TRACE(' trc ')' .
exectrace = trace(trc)
signal on failure
signal on error
signal on syntax
signal on novalue
signal on halt
address sh

if hlq = '' then do
  say execfn||': HLQ parameter required'
  call exit 4
end

if lbl = '' then do
  say execfn||': LBL parameter required'
  call exit 4
end

if type = '' then do
  say execfn||': TYPE parameter required'
  call exit 4
end

if last = '' then do
  say execfn||': LAST parameter required'
  call exit 4
end

/*--  Initialization  --------------------------------------*
 *  Set initial value for internal processing variables.    *
 *----------------------------------------------------------*/
parse value lbl with date '-' time

dsnUser = hlq||'.'
dsnDate = 'D'||right(date,6,0)||'.'
dsnTime = 'T'||left(time,7,0)||'.'
dsnType = type||'.'
dsnLast = last
dsn     = dsnUser||dsnDate||dsnTime||dsnType||dsnLast

/*--  Process Options  -------------------------------------*
 *  Set processing overrides for user-specified options.    *
 *----------------------------------------------------------*/
do while options \= ''
  parse var options option options
  parse var option optequ '=' optval
  parse var option optpar '(' optval . ')'

  select
    when left(option,2) = '${' then nop
    when optpar = 'TRACE'      then nop

    otherwise do
      say execfn||': Invalid option' option
      call exit 4
    end
  end
end

/*--  Main Process  ----------------------------------------*
 *  Allocate the dataset used for ISPDTLC commands.         *
 *----------------------------------------------------------*/
call bpxwdyn "alloc dsn('"dsn"') old delete"

call exit 0

/*--  Exit  ------------------------------------------------*
 *  Universal exit.  Retrieve RC and return to caller.      *
 *----------------------------------------------------------*/
exit:
arg rc
exit rc

/*--  Error trapping  --------------------------------------*
 *  Encountered an unrecoverable error.  Terminate exec.    *
 *----------------------------------------------------------*/
halt:
novalue:
syntax:
error:
failure:
call exit 8
