/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.smpe.internal.common;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.common.model.IBuildEngine;
import com.ibm.team.build.common.model.IBuildEngineHandle;
import com.ibm.team.build.extensions.common.IFetchItem;
import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.Debugger;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogString;
import com.ibm.team.build.extensions.common.debug.MethodName;
import com.ibm.team.build.extensions.common.util.Verification;
import com.ibm.team.enterprise.smpe.common.IOrchestratorBuild;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class OrchestratorBuild
implements IOrchestratorBuild {
    private static final String keyBuildDefinition = "buildDefinition";
    private static final String keyBuildEngines = "buildEngines";
    private static final String keyDependent = "dependent";
    private static final String keyDependsOn = "dependsOn";
    private static final String keyEnabled = "enabled";
    private static final String keyHousekeeping = "housekeeping";
    private static final String keyPrimary = "primary";
    private static final String keySecondary = "secondary";
    private final IDebugger dbg;
    private final String simpleName;
    private IBuildDefinition buildDefinition;
    private boolean dependent;
    private boolean enabled;
    private boolean housekeeping;
    private boolean primary;
    private boolean secondary;
    private final List<IBuildEngine> buildEngines = new ArrayList<IBuildEngine>();
    private final List<IBuildDefinition> dependsOn = new ArrayList<IBuildDefinition>();

    public OrchestratorBuild() {
        this((IDebugger)new Debugger(OrchestratorBuild.class));
    }

    public OrchestratorBuild(IDebugger dbg) {
        this.dbg = dbg;
        this.simpleName = this.getClass().getSimpleName();
        if (dbg.isDebug()) {
            Debug.setup((IDebugger)dbg, (String[])new String[]{this.simpleName});
        }
    }

    public OrchestratorBuild(IOrchestratorBuild orchestratorBuild) {
        this(orchestratorBuild, (IDebugger)new Debugger(OrchestratorBuild.class));
    }

    public OrchestratorBuild(IOrchestratorBuild orchestratorBuild, IDebugger dbg) {
        this.dbg = dbg;
        this.simpleName = this.getClass().getSimpleName();
        this.copy(orchestratorBuild);
        if (dbg.isDebug()) {
            Debug.setup((IDebugger)dbg, (String[])new String[]{this.simpleName});
        }
    }

    public OrchestratorBuild(JSONObject jsonObject, IFetchItem fetchItem) {
        this(jsonObject, fetchItem, (IDebugger)new Debugger(OrchestratorBuild.class));
    }

    public OrchestratorBuild(JSONObject jsonObject, IFetchItem fetchItem, IDebugger dbg) {
        this.dbg = dbg;
        this.simpleName = this.getClass().getSimpleName();
        this.parseJson(jsonObject, fetchItem);
        if (dbg.isDebug()) {
            Debug.setup((IDebugger)dbg, (String[])new String[]{this.simpleName});
        }
    }

    @Override
    public final IOrchestratorBuild copy(IOrchestratorBuild original) {
        this.setBuildDefinition(original.getBuildDefinition());
        this.setDependent(original.isDependent());
        this.setEnabled(original.isEnabled());
        this.setHousekeeping(original.isHousekeeping());
        this.setPrimary(original.isPrimary());
        this.setSecondary(original.isSecondary());
        this.buildEngines.clear();
        this.buildEngines.addAll(original.getBuildEngines());
        this.dependsOn.clear();
        this.dependsOn.addAll(original.getDependsOn());
        return this;
    }

    @Override
    public final IOrchestratorBuild newCopy() {
        return new OrchestratorBuild(this);
    }

    @Override
    public final IOrchestratorBuild newInstance() {
        return new OrchestratorBuild();
    }

    @Override
    public final IOrchestratorBuild update(IOrchestratorBuild updated) {
        this.setBuildDefinition(updated.getBuildDefinition());
        this.setDependent(updated.isDependent());
        this.setEnabled(updated.isEnabled());
        this.setHousekeeping(updated.isHousekeeping());
        this.setPrimary(updated.isPrimary());
        this.setSecondary(updated.isSecondary());
        this.buildEngines.clear();
        this.buildEngines.addAll(updated.getBuildEngines());
        this.dependsOn.clear();
        this.dependsOn.addAll(updated.getDependsOn());
        return this;
    }

    @Override
    public final IOrchestratorBuild parseJson(JSONObject jsonObject, IFetchItem fetchItem) {
        IBuildDefinitionHandle buildDefinitionHandle = (IBuildDefinitionHandle)IBuildDefinition.ITEM_TYPE.createItemHandle(UUID.valueOf((String)((String)jsonObject.get((Object)keyBuildDefinition))), null);
        this.setBuildDefinition((IBuildDefinition)fetchItem.execute((IItemHandle)buildDefinitionHandle));
        this.buildEngines.clear();
        Object[] objectArray = ((ArrayList)jsonObject.get((Object)keyBuildEngines)).toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object engineUuid = objectArray[n2];
            IBuildEngineHandle buildEngineHandle = (IBuildEngineHandle)IBuildEngine.ITEM_TYPE.createItemHandle(UUID.valueOf((String)((String)engineUuid)), null);
            this.buildEngines.add((IBuildEngine)fetchItem.execute((IItemHandle)buildEngineHandle));
            ++n2;
        }
        this.buildEngines.removeAll(Collections.singleton(null));
        this.setDependent(Boolean.parseBoolean((String)jsonObject.get((Object)keyDependent)));
        this.dependsOn.clear();
        objectArray = ((ArrayList)jsonObject.get((Object)keyDependsOn)).toArray();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Object buildUuid = objectArray[n2];
            IBuildDefinitionHandle dependsOnHandle = (IBuildDefinitionHandle)IBuildDefinition.ITEM_TYPE.createItemHandle(UUID.valueOf((String)((String)buildUuid)), null);
            this.dependsOn.add((IBuildDefinition)fetchItem.execute((IItemHandle)dependsOnHandle));
            ++n2;
        }
        this.dependsOn.removeAll(Collections.singleton(null));
        this.setEnabled(Boolean.parseBoolean((String)jsonObject.get((Object)keyEnabled)));
        this.setHousekeeping(Boolean.parseBoolean((String)jsonObject.get((Object)keyHousekeeping)));
        this.setPrimary(Boolean.parseBoolean((String)jsonObject.get((Object)keyPrimary)));
        this.setSecondary(Boolean.parseBoolean((String)jsonObject.get((Object)keySecondary)));
        return this;
    }

    @Override
    public final JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)keyBuildDefinition, (Object)this.buildDefinition.getItemId().getUuidValue());
        JSONArray engineArray = new JSONArray();
        for (IBuildEngine engine : this.buildEngines) {
            engineArray.add((Object)engine.getItemId().getUuidValue());
        }
        jsonObject.put((Object)keyBuildEngines, (Object)engineArray);
        jsonObject.put((Object)keyDependent, (Object)Boolean.toString(this.dependent));
        JSONArray dependsOnArray = new JSONArray();
        for (IBuildDefinition build : this.dependsOn) {
            dependsOnArray.add((Object)build.getItemId().getUuidValue());
        }
        jsonObject.put((Object)keyDependsOn, (Object)dependsOnArray);
        jsonObject.put((Object)keyEnabled, (Object)Boolean.toString(this.enabled));
        jsonObject.put((Object)keyHousekeeping, (Object)Boolean.toString(this.housekeeping));
        jsonObject.put((Object)keyPrimary, (Object)Boolean.toString(this.primary));
        jsonObject.put((Object)keySecondary, (Object)Boolean.toString(this.secondary));
        return jsonObject;
    }

    @Override
    public final IBuildDefinition getBuildDefinition() {
        return this.buildDefinition;
    }

    @Override
    public final boolean hasBuildDefinition() {
        return Verification.isNonNull((Object)this.buildDefinition);
    }

    @Override
    public final void setBuildDefinition(IBuildDefinition buildDefinition) {
        this.buildDefinition = buildDefinition;
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((IItem)buildDefinition)});
        }
    }

    @Override
    public final String getBuildDefinitionId() {
        return Verification.isNonNull((Object)this.buildDefinition) ? this.buildDefinition.getId() : "";
    }

    @Override
    public final List<IBuildEngine> getBuildEngines() {
        return this.buildEngines;
    }

    @Override
    public final void setBuildEngines(List<IBuildEngine> buildEngines) {
        this.buildEngines.clear();
        this.buildEngines.addAll(buildEngines);
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf(buildEngines)});
        }
    }

    @Override
    public final boolean isDependent() {
        return this.dependent;
    }

    @Override
    public final void setDependent(boolean dependent) {
        this.dependent = dependent;
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((boolean)dependent)});
        }
    }

    @Override
    public final List<IBuildDefinition> getDependsOn() {
        return this.dependsOn;
    }

    @Override
    public final void setDependsOn(List<IBuildDefinition> dependsOn) {
        this.dependsOn.clear();
        this.dependsOn.addAll(dependsOn);
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf(dependsOn)});
        }
    }

    @Override
    public final boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public final void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((boolean)enabled)});
        }
    }

    @Override
    public final boolean isHousekeeping() {
        return this.housekeeping;
    }

    @Override
    public final void setHousekeeping(boolean housekeeping) {
        this.housekeeping = housekeeping;
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((boolean)housekeeping)});
        }
    }

    @Override
    public final boolean isPrimary() {
        return this.primary;
    }

    @Override
    public final void setPrimary(boolean primary) {
        this.primary = primary;
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((boolean)primary)});
        }
    }

    @Override
    public final boolean isSecondary() {
        return this.secondary;
    }

    @Override
    public final void setSecondary(boolean secondary) {
        this.secondary = secondary;
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((boolean)secondary)});
        }
    }
}

