/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.smpe.internal.common;

import com.ibm.team.build.extensions.common.IFetchItem;
import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.Debugger;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogString;
import com.ibm.team.build.extensions.common.debug.MethodName;
import com.ibm.team.build.extensions.common.util.Verification;
import com.ibm.team.enterprise.smpe.common.IOrchestratorAction;
import com.ibm.team.enterprise.smpe.common.nls.Messages;
import com.ibm.team.enterprise.systemdefinition.common.model.IResourceDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IResourceDefinitionHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONObject;
import java.util.ArrayList;
import java.util.List;

public class OrchestratorAction
implements IOrchestratorAction {
    private static final String keyAction = "action";
    private static final String keyArgument1 = "argument1";
    private static final String keyArgument2 = "argument2";
    private static final String keyFetch = "fetch";
    private static final String keyPostBuild = "postBuild";
    private static final String keyPreBuild = "preBuild";
    private final IDebugger dbg;
    private final String simpleName;
    private Action action;
    private boolean fetch;
    private boolean preBuild;
    private boolean postBuild;
    private Object argument1;
    private Object argument2;

    public OrchestratorAction() {
        this((IDebugger)new Debugger(OrchestratorAction.class));
    }

    public OrchestratorAction(IDebugger dbg) {
        this.dbg = dbg;
        this.simpleName = this.getClass().getSimpleName();
        if (dbg.isDebug()) {
            Debug.setup((IDebugger)dbg, (String[])new String[]{this.simpleName});
        }
    }

    public OrchestratorAction(IOrchestratorAction orchestratorAction) {
        this(orchestratorAction, (IDebugger)new Debugger(OrchestratorAction.class));
    }

    public OrchestratorAction(IOrchestratorAction orchestratorAction, IDebugger dbg) {
        this.dbg = dbg;
        this.simpleName = this.getClass().getSimpleName();
        this.copy(orchestratorAction);
        if (dbg.isDebug()) {
            Debug.setup((IDebugger)dbg, (String[])new String[]{this.simpleName});
        }
    }

    public OrchestratorAction(JSONObject jsonObject, IFetchItem fetchItem) {
        this(jsonObject, fetchItem, (IDebugger)new Debugger(OrchestratorAction.class));
    }

    public OrchestratorAction(JSONObject jsonObject, IFetchItem fetchItem, IDebugger dbg) {
        this.dbg = dbg;
        this.simpleName = this.getClass().getSimpleName();
        this.parseJson(jsonObject, fetchItem);
        if (dbg.isDebug()) {
            Debug.setup((IDebugger)dbg, (String[])new String[]{this.simpleName});
        }
    }

    @Override
    public final IOrchestratorAction copy(IOrchestratorAction original) {
        this.setAction(original.getAction());
        this.setArgument1(original.getArgument1());
        this.setArgument2(original.getArgument2());
        this.setFetch(original.isFetch());
        this.setPostBuild(original.isPostBuild());
        this.setPreBuild(original.isPreBuild());
        return this;
    }

    @Override
    public final IOrchestratorAction newCopy() {
        return new OrchestratorAction(this);
    }

    @Override
    public final IOrchestratorAction newInstance() {
        return new OrchestratorAction();
    }

    @Override
    public final IOrchestratorAction update(IOrchestratorAction updated) {
        this.setAction(updated.getAction());
        this.setArgument1(updated.getArgument1());
        this.setArgument2(updated.getArgument2());
        this.setFetch(updated.isFetch());
        this.setPostBuild(updated.isPostBuild());
        this.setPreBuild(updated.isPreBuild());
        return this;
    }

    @Override
    public final IOrchestratorAction parseJson(JSONObject jsonObject, IFetchItem fetchItem) {
        IResourceDefinitionHandle handle;
        this.setAction(Action.get((String)jsonObject.get((Object)keyAction)));
        if (this.action != null) {
            switch (this.action) {
                case COPY: {
                    handle = (IResourceDefinitionHandle)IResourceDefinition.ITEM_TYPE.createItemHandle(UUID.valueOf((String)((String)jsonObject.get((Object)keyArgument1))), null);
                    this.setArgument1(fetchItem.execute((IItemHandle)handle));
                }
            }
        }
        if (this.action != null) {
            switch (this.action) {
                case COPY: {
                    handle = (IResourceDefinitionHandle)IResourceDefinition.ITEM_TYPE.createItemHandle(UUID.valueOf((String)((String)jsonObject.get((Object)keyArgument2))), null);
                    this.setArgument2(fetchItem.execute((IItemHandle)handle));
                }
            }
        }
        this.setFetch(Boolean.parseBoolean((String)jsonObject.get((Object)keyFetch)));
        this.setPostBuild(Boolean.parseBoolean((String)jsonObject.get((Object)keyPostBuild)));
        this.setPreBuild(Boolean.parseBoolean((String)jsonObject.get((Object)keyPreBuild)));
        return this;
    }

    @Override
    public final JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        if (this.action != null) {
            jsonObject.put((Object)keyAction, (Object)this.action.toString());
            if (this.action != null) {
                switch (this.action) {
                    case COPY: {
                        if (this.argument1 == null) break;
                        jsonObject.put((Object)keyArgument1, (Object)((IResourceDefinitionHandle)this.argument1).getUuid());
                    }
                }
            }
            if (this.action != null) {
                switch (this.action) {
                    case COPY: {
                        if (this.argument2 == null) break;
                        jsonObject.put((Object)keyArgument2, (Object)((IResourceDefinitionHandle)this.argument2).getUuid());
                    }
                }
            }
            jsonObject.put((Object)keyFetch, (Object)Boolean.toString(this.fetch));
            jsonObject.put((Object)keyPostBuild, (Object)Boolean.toString(this.postBuild));
            jsonObject.put((Object)keyPreBuild, (Object)Boolean.toString(this.preBuild));
        }
        return jsonObject;
    }

    @Override
    public final Action getAction() {
        return this.action;
    }

    @Override
    public final boolean hasAction() {
        return Verification.isNonNull((Object)((Object)this.action));
    }

    @Override
    public final void setAction(Action action) {
        this.action = action;
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((Enum)action)});
        }
    }

    @Override
    public final Object getArgument1() {
        return this.argument1;
    }

    @Override
    public final boolean hasArgument1() {
        return Verification.isNonNull((Object)this.argument1);
    }

    @Override
    public final void setArgument1(Object argument1) {
        this.argument1 = argument1;
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((Object)argument1)});
        }
    }

    @Override
    public final Object getArgument2() {
        return this.argument2;
    }

    @Override
    public final boolean hasArgument2() {
        return Verification.isNonNull((Object)this.argument2);
    }

    @Override
    public final void setArgument2(Object argument2) {
        this.argument2 = argument2;
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((Object)argument2)});
        }
    }

    @Override
    public final boolean isFetch() {
        return this.fetch;
    }

    @Override
    public final void setFetch(boolean fetch) {
        this.fetch = fetch;
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((boolean)fetch)});
        }
    }

    @Override
    public final boolean isPostBuild() {
        return this.postBuild;
    }

    @Override
    public final void setPostBuild(boolean postBuild) {
        this.postBuild = postBuild;
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((boolean)postBuild)});
        }
    }

    @Override
    public final boolean isPreBuild() {
        return this.preBuild;
    }

    @Override
    public final void setPreBuild(boolean preBuild) {
        this.preBuild = preBuild;
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((boolean)preBuild)});
        }
    }

    public static enum Action {
        COPY(Messages.BO_ACTION_COPY);

        private final String label;
        private static List<Action> ValueList;
        private static List<String> LabelList;

        static {
            ValueList = new ArrayList<Action>(){
                private static final long serialVersionUID = 1L;
                {
                    this.add(null);
                    Action[] actionArray = Action.values();
                    int n = actionArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Action action = actionArray[n2];
                        this.add(action);
                        ++n2;
                    }
                }
            };
            LabelList = new ArrayList<String>(){
                private static final long serialVersionUID = 1L;
                {
                    this.add("");
                    Action[] actionArray = Action.values();
                    int n = actionArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Action action = actionArray[n2];
                        this.add(action.getLabel());
                        ++n2;
                    }
                }
            };
        }

        private Action(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }

        public static final Action get(String s) {
            Action[] actionArray = Action.values();
            int n = actionArray.length;
            int n2 = 0;
            while (n2 < n) {
                Action action = actionArray[n2];
                if (action.toString().equals(s)) {
                    return action;
                }
                ++n2;
            }
            return null;
        }

        public static final Action get(int i) {
            return ValueList.get(i);
        }

        public static final Action[] getArray() {
            return ValueList.toArray(new Action[ValueList.size()]);
        }

        public static final int getIndex(Action item) {
            return ValueList.indexOf((Object)item);
        }

        public static final int getLabelIndex(String item) {
            return LabelList.indexOf(item);
        }

        public static final String[] getLabels() {
            return LabelList.toArray(new String[LabelList.size()]);
        }

        public static final List<Action> getList() {
            return ValueList;
        }

        public static final boolean isValid(String s) {
            Action[] actionArray = Action.values();
            int n = actionArray.length;
            int n2 = 0;
            while (n2 < n) {
                Action action = actionArray[n2];
                if (action.toString().equals(s)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public static final String toString(Action item) {
            return Action.toString(item, "null");
        }

        public static final String toString(Action item, String s) {
            return item == null ? s : item.toString();
        }
    }
}

