/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.smpe.common.util;

import com.ibm.team.enterprise.systemdefinition.common.ISystemDefinitionHistoryProcessor;
import com.ibm.team.enterprise.systemdefinition.common.dto.ChangeLogDTO;
import com.ibm.team.enterprise.systemdefinition.common.model.IFunctionDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IVersionDefinition;
import java.util.Collection;

public class SystemDefinitionHistoryProcessor
implements ISystemDefinitionHistoryProcessor {
    public void process(ISystemDefinition oldSystemDefinition, ISystemDefinition newSystemDefinition, ChangeLogDTO changeLog) {
        if (newSystemDefinition instanceof IFunctionDefinition) {
            this.addFunctionDeltas(oldSystemDefinition, (IFunctionDefinition)newSystemDefinition, changeLog);
        } else if (newSystemDefinition instanceof IVersionDefinition) {
            this.addVersionDeltas(oldSystemDefinition, (IVersionDefinition)newSystemDefinition, changeLog);
        }
    }

    private void addFunctionDeltas(ISystemDefinition oldSystemDefinition, IFunctionDefinition newFunctionDefinition, ChangeLogDTO changeLog) {
        if (changeLog == null) {
            return;
        }
        ChangeLogDTO result = newFunctionDefinition.generateChangeLogDTO(oldSystemDefinition, newFunctionDefinition.getModifiedBy(), newFunctionDefinition.modified());
        changeLog.getChanges().addAll((Collection)result.getChanges());
    }

    private void addVersionDeltas(ISystemDefinition oldSystemDefinition, IVersionDefinition newVersionDefinition, ChangeLogDTO changeLog) {
        if (changeLog == null) {
            return;
        }
        ChangeLogDTO result = newVersionDefinition.generateChangeLogDTO(oldSystemDefinition, newVersionDefinition.getModifiedBy(), newVersionDefinition.modified());
        changeLog.getChanges().addAll((Collection)result.getChanges());
    }
}

