/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.smpe.internal.client;

import com.ibm.team.enterprise.smpe.client.query.QueryFactory;
import com.ibm.team.enterprise.systemdefinition.client.IPackagingQueryClient;
import com.ibm.team.enterprise.systemdefinition.common.ISystemDefinitionModelService;
import com.ibm.team.enterprise.systemdefinition.common.internal.impl.GetStringLanguageName;
import com.ibm.team.enterprise.systemdefinition.common.model.IFmidItemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IZosLanguageDefinition;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.EventSource;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.query.IItemQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class PackagingQueryClient
extends EventSource
implements IPackagingQueryClient {
    private final IClientLibraryContext context;

    public PackagingQueryClient(IClientLibraryContext context) {
        this.context = context;
    }

    private Object callCancelableService(IProgressMonitor monitor, IClientLibraryContext.IServiceRunnable runnable) throws TeamRepositoryException {
        return this.getContext().callCancelableService(runnable, monitor);
    }

    private IClientLibraryContext getContext() {
        return this.context;
    }

    protected ITeamRepository getRepository() {
        return this.context.teamRepository();
    }

    private <T> T getService(Class<T> clazz) {
        return (T)this.getContext().getServiceInterface(clazz);
    }

    public List<IFmidItemDefinition> fetchFmidItemItems(IProjectAreaHandle projectAreaHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        final IItemQuery query = QueryFactory.createFmidItemItemQuery();
        final Object[] parameters = new Object[]{projectAreaHandle};
        ISystemDefinition[] result = (ISystemDefinition[])this.callCancelableService(monitor, (IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<ISystemDefinition[]>(){

            public ISystemDefinition[] run(IProgressMonitor monitor) throws TeamRepositoryException {
                try {
                    return ((ISystemDefinitionModelService)PackagingQueryClient.this.getService(ISystemDefinitionModelService.class)).queryItems(query, parameters);
                }
                catch (ItemNotFoundException e) {
                    return null;
                }
            }
        });
        return new ArrayList<ISystemDefinition>(Arrays.asList(result));
    }

    public final List<IZosLanguageDefinition> fetchLanguageFolders(IProjectAreaHandle projectAreaHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        final IItemQuery query = QueryFactory.createZosLanguageFolderQuery();
        final Object[] parameters = new Object[]{projectAreaHandle};
        ISystemDefinition[] result = (ISystemDefinition[])this.callCancelableService(monitor, (IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<ISystemDefinition[]>(){

            public ISystemDefinition[] run(IProgressMonitor monitor) throws TeamRepositoryException {
                try {
                    return ((ISystemDefinitionModelService)PackagingQueryClient.this.getService(ISystemDefinitionModelService.class)).queryItems(query, parameters);
                }
                catch (ItemNotFoundException e) {
                    return null;
                }
            }
        });
        return new ArrayList<ISystemDefinition>(Arrays.asList(result));
    }

    public final List<IZosLanguageDefinition> fetchLanguageItems(IProjectAreaHandle projectAreaHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        final IItemQuery query = QueryFactory.createZosLanguageItemQuery();
        final Object[] parameters = new Object[]{projectAreaHandle};
        ISystemDefinition[] result = (ISystemDefinition[])this.callCancelableService(monitor, (IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<ISystemDefinition[]>(){

            public ISystemDefinition[] run(IProgressMonitor monitor) throws TeamRepositoryException {
                try {
                    return ((ISystemDefinitionModelService)PackagingQueryClient.this.getService(ISystemDefinitionModelService.class)).queryItems(query, parameters);
                }
                catch (ItemNotFoundException e) {
                    return null;
                }
            }
        });
        return new ArrayList<ISystemDefinition>(Arrays.asList(result));
    }

    public final List<String> fetchLanguageItemsNames(IProjectAreaHandle projectAreaHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        final IItemQuery query = QueryFactory.createZosLanguageItemQuery();
        final Object[] parameters = new Object[]{projectAreaHandle};
        String[] result = (String[])this.callCancelableService(monitor, (IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<String[]>(){

            public String[] run(IProgressMonitor monitor) throws TeamRepositoryException {
                try {
                    return ((ISystemDefinitionModelService)PackagingQueryClient.this.getService(ISystemDefinitionModelService.class)).queryItemsForStrings(query, parameters, new GetStringLanguageName().getClass().getName());
                }
                catch (ItemNotFoundException e) {
                    return null;
                }
            }
        });
        return Arrays.asList(result);
    }

    public final List<IZosLanguageDefinition> fetchLanguageJclincs(IProjectAreaHandle projectAreaHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        final IItemQuery query = QueryFactory.createZosLanguageJclincsQuery();
        final Object[] parameters = new Object[]{projectAreaHandle};
        ISystemDefinition[] result = (ISystemDefinition[])this.callCancelableService(monitor, (IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<ISystemDefinition[]>(){

            public ISystemDefinition[] run(IProgressMonitor monitor) throws TeamRepositoryException {
                try {
                    return ((ISystemDefinitionModelService)PackagingQueryClient.this.getService(ISystemDefinitionModelService.class)).queryItems(query, parameters);
                }
                catch (ItemNotFoundException e) {
                    return null;
                }
            }
        });
        return new ArrayList<ISystemDefinition>(Arrays.asList(result));
    }

    public final boolean isSMPEEnabled(IProgressMonitor monitor) throws TeamRepositoryException {
        return (Boolean)this.callCancelableService(monitor, (IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<Boolean>(){

            public Boolean run(IProgressMonitor monitor) throws TeamRepositoryException {
                return ((ISystemDefinitionModelService)PackagingQueryClient.this.getService(ISystemDefinitionModelService.class)).isSMPEEnabled();
            }
        });
    }
}

