/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.smpe.client.util;

import com.ibm.team.build.extensions.client.util.CCMProcessArea;
import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.Debugger;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.MethodName;
import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class ProcessAreaEE {
    private static final String className = ProcessAreaEE.class.getSimpleName();

    public static List<IProjectArea> getSystemDefinitionProjectAreas(ITeamRepository repository, IItemType type) throws TeamRepositoryException {
        return ProcessAreaEE.getSystemDefinitionProjectAreas(repository, type, null, (IDebugger)new Debugger(ProcessAreaEE.class));
    }

    public static List<IProjectArea> getSystemDefinitionProjectAreas(ITeamRepository repository, IItemType type, IProgressMonitor monitor) throws TeamRepositoryException {
        return ProcessAreaEE.getSystemDefinitionProjectAreas(repository, type, monitor, (IDebugger)new Debugger(ProcessAreaEE.class));
    }

    public static List<IProjectArea> getSystemDefinitionProjectAreas(ITeamRepository repository, IItemType type, IDebugger dbg) throws TeamRepositoryException {
        return ProcessAreaEE.getSystemDefinitionProjectAreas(repository, type, null, dbg);
    }

    public static List<IProjectArea> getSystemDefinitionProjectAreas(ITeamRepository repository, IItemType type, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        ISystemDefinitionModelClient client = (ISystemDefinitionModelClient)repository.getClientLibrary(ISystemDefinitionModelClient.class);
        List projectAreas = CCMProcessArea.getProjectAreas((ITeamRepository)repository, (IProgressMonitor)monitor, (IDebugger)dbg);
        ArrayList<IProjectArea> projectAreaList = new ArrayList<IProjectArea>(projectAreas.size());
        for (IProjectArea projectArea : projectAreas) {
            if (projectArea == null || projectArea.isArchived() || !client.hasSystemDefinitions((IProjectAreaHandle)projectArea, type, -1, false, null)) continue;
            projectAreas.add(projectArea);
        }
        Collections.sort(projectAreas, new Comparator<IProjectArea>(){

            @Override
            public int compare(IProjectArea o1, IProjectArea o2) {
                String label1 = o1.getName();
                String label2 = o2.getName();
                return label1.compareTo(label2);
            }
        });
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), Integer.toString(projectAreaList.size())});
        }
        return projectAreaList;
    }
}

