/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.smpe.client.packaging;

import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.Debugger;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.MethodName;
import com.ibm.team.enterprise.systemdefinition.common.packaging.IPackagingDataset;
import com.ibm.team.repository.common.TeamRepositoryException;

public class AllocationTools {
    private static final String SPACE_UNITS_CYLINDERS = "cyls";
    private static final String SPACE_UNITS_TRACKS = "trks";
    private static final String Alloc_AdditionalParm = "%s ";
    private static final String Alloc_BlockSize = "blksize(%s) ";
    private static final String Alloc_DataClass = "dataclas(%s) ";
    private static final String Alloc_DirectoryBlocks = "dir(%s) ";
    private static final String Alloc_Dsnyype_Library = "dsntype(library) ";
    private static final String Alloc_Dsnyype_Pds = "dsntype(pds) ";
    private static final String Alloc_Dsorg_Po = "dsorg(PO) ";
    private static final String Alloc_Dsorg_Ps = "dsorg(PS) ";
    private static final String Alloc_ExpirationDate = "expdt(%s) ";
    private static final String Alloc_GenericUnit = "unit(%s)";
    private static final String Alloc_ManagementClass = "mgmtclas(%s) ";
    private static final String Alloc_RecordFormat = "recfm(%s) ";
    private static final String Alloc_RecordLength = "lrecl(%s) ";
    private static final String Alloc_Space = "space(%s) ";
    private static final String Alloc_Space2 = "space(%1$s,%2$s) ";
    private static final String Alloc_SpaceUnits_Cyl = "cyl ";
    private static final String Alloc_SpaceUnits_Tracks = "tracks ";
    private static final String Alloc_StorageClass = "storclas(%s) ";
    private static final String Alloc_VolumeSerial = "vol(%s) ";
    private final IDebugger dbg;
    private final String simpleName;

    public AllocationTools() {
        this((IDebugger)new Debugger(AllocationTools.class));
    }

    public AllocationTools(IDebugger dbg) {
        this.dbg = dbg;
        this.simpleName = this.getClass().getSimpleName();
        if (dbg.isDebug()) {
            Debug.setup((IDebugger)dbg, (String[])new String[]{this.simpleName});
        }
    }

    public final String createAllocationParameter(IPackagingDataset dataset) throws TeamRepositoryException {
        if (this.dbg.isDebug()) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName()});
        }
        StringBuilder result = new StringBuilder();
        if (dataset.hasAdditionalParm()) {
            result.append(String.format(Alloc_AdditionalParm, dataset.getAdditionalParm()));
        }
        if (dataset.hasBlockSize()) {
            result.append(String.format(Alloc_BlockSize, dataset.getBlockSize()));
        }
        if (dataset.hasDataClass()) {
            result.append(String.format(Alloc_DataClass, dataset.getDataClass()));
        }
        if (dataset.hasDirectoryBlocks() && !dataset.getDirectoryBlocks().equals("0")) {
            result.append(String.format(Alloc_DirectoryBlocks, dataset.getDirectoryBlocks()));
        }
        if (dataset.getDsType() == 0) {
            result.append(Alloc_Dsnyype_Library);
        } else if (dataset.getDsType() == 3) {
            result.append(Alloc_Dsnyype_Pds);
        }
        if (dataset.getDsType() == 1) {
            result.append(Alloc_Dsorg_Ps);
        } else {
            result.append(Alloc_Dsorg_Po);
        }
        if (dataset.hasExpirationDate()) {
            result.append(String.format(Alloc_ExpirationDate, dataset.getExpirationDate()));
        }
        if (dataset.hasGenericUnit()) {
            result.append(String.format(Alloc_GenericUnit, dataset.getGenericUnit()));
        }
        if (dataset.hasManagementClass()) {
            result.append(String.format(Alloc_ManagementClass, dataset.getManagementClass()));
        }
        if (dataset.hasRecordFormat()) {
            String recordFormat = dataset.getRecordFormat();
            StringBuilder formatString = new StringBuilder();
            int i = 0;
            while (i < recordFormat.length()) {
                formatString.append(recordFormat.charAt(i)).append(" ");
                ++i;
            }
            result.append(String.format(Alloc_RecordFormat, formatString.toString().trim().replace(" ", ",")));
        }
        if (dataset.hasRecordLength()) {
            result.append(String.format(Alloc_RecordLength, dataset.getRecordLength()));
        }
        if (dataset.hasPrimaryQuantity()) {
            if (dataset.hasSecondaryQuantity()) {
                result.append(String.format(Alloc_Space2, dataset.getPrimaryQuantity(), dataset.getSecondaryQuantity()));
            } else {
                result.append(String.format(Alloc_Space, dataset.getPrimaryQuantity()));
            }
        }
        if (dataset.hasSpaceUnits()) {
            if (dataset.getSpaceUnits().equals(SPACE_UNITS_CYLINDERS)) {
                result.append(Alloc_SpaceUnits_Cyl);
            } else if (dataset.getSpaceUnits().equals(SPACE_UNITS_TRACKS)) {
                result.append(Alloc_SpaceUnits_Tracks);
            }
        }
        if (dataset.hasStorageClass()) {
            result.append(String.format(Alloc_StorageClass, dataset.getStorageClass()));
        }
        if (dataset.hasVolumeSerial()) {
            result.append(String.format(Alloc_VolumeSerial, dataset.getVolumeSerial()));
        }
        if (this.dbg.isDebug()) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName()});
        }
        return result.toString().trim();
    }

    public final String createAllocationParameterDcb(IPackagingDataset dataset) throws TeamRepositoryException {
        if (this.dbg.isDebug()) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName()});
        }
        StringBuilder result = new StringBuilder();
        if (dataset.hasBlockSize()) {
            result.append(String.format(Alloc_BlockSize, dataset.getBlockSize()));
        }
        if (dataset.hasDirectoryBlocks() && !dataset.getDirectoryBlocks().equals("0")) {
            result.append(String.format(Alloc_DirectoryBlocks, dataset.getDirectoryBlocks()));
        }
        if (dataset.getDsType() == 0) {
            result.append(Alloc_Dsnyype_Library);
        } else if (dataset.getDsType() == 3) {
            result.append(Alloc_Dsnyype_Pds);
        }
        if (dataset.getDsType() == 1) {
            result.append(Alloc_Dsorg_Ps);
        } else {
            result.append(Alloc_Dsorg_Po);
        }
        if (dataset.hasRecordFormat()) {
            String recordFormat = dataset.getRecordFormat();
            StringBuilder formatString = new StringBuilder();
            int i = 0;
            while (i < recordFormat.length()) {
                formatString.append(recordFormat.charAt(i)).append(" ");
                ++i;
            }
            result.append(String.format(Alloc_RecordFormat, formatString.toString().trim().replace(" ", ",")));
        }
        if (dataset.hasRecordLength()) {
            result.append(String.format(Alloc_RecordLength, dataset.getRecordLength()));
        }
        if (dataset.hasPrimaryQuantity()) {
            if (dataset.hasSecondaryQuantity()) {
                result.append(String.format(Alloc_Space2, dataset.getPrimaryQuantity(), dataset.getSecondaryQuantity()));
            } else {
                result.append(String.format(Alloc_Space, dataset.getPrimaryQuantity()));
            }
        }
        if (dataset.hasSpaceUnits()) {
            if (dataset.getSpaceUnits().equals(SPACE_UNITS_CYLINDERS)) {
                result.append(Alloc_SpaceUnits_Cyl);
            } else if (dataset.getSpaceUnits().equals(SPACE_UNITS_TRACKS)) {
                result.append(Alloc_SpaceUnits_Tracks);
            }
        }
        if (this.dbg.isDebug()) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName()});
        }
        return result.toString().trim();
    }
}

