/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.scmee.zos;

import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.DebugStack;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogField;
import com.ibm.team.enterprise.scmee.common.SCMEEStorageManager;
import com.ibm.team.enterprise.scmee.zos.nls.Messages;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.internal.RelativeLocation;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.teamz.build.ant.zos.utils.JzosUtility;

public class DataSetLocation
implements ILocation {
    private static final String cls = DataSetLocation.class.getSimpleName();
    public static final String STORAGE_ID = "com.ibm.teamz.filesystem.mvs";
    private final IDebugger dbg;
    private final boolean debug;
    private final boolean trace;
    private final boolean items;
    private String highLevelQualifier;
    private String dataSetName;
    private String memberName;
    private boolean hasHighLevelQualifier;
    private boolean hasDataSetName;
    private boolean hasMember;
    private boolean zFolder;

    public static String getDataSetName(String highLevelQual, String dsName) {
        DataSetLocation location = new DataSetLocation(highLevelQual, dsName, null);
        return location.getDatasetName();
    }

    public DataSetLocation() {
        this(null, null, null);
    }

    public DataSetLocation(String hlq) {
        this(hlq, null, null);
    }

    public DataSetLocation(String hlq, String dsn, String mbr) {
        if (hlq != null || dsn != null || mbr != null) {
            if (hlq == null) {
                throw new IllegalArgumentException(Messages.DataSetLocation_0);
            }
            if ((hlq = hlq.trim()).endsWith(".")) {
                hlq = hlq.substring(0, hlq.length() - 1);
            }
            if (dsn != null) {
                if ((dsn = JzosUtility.substituteSystemSymbols((String)dsn.trim())).startsWith(".")) {
                    dsn = dsn.substring(1);
                }
                if (mbr != null) {
                    if ((mbr = mbr.trim()).startsWith("(")) {
                        mbr = mbr.substring(1);
                    }
                    if (mbr.endsWith(")")) {
                        mbr = mbr.substring(0, mbr.length() - 1);
                    }
                }
            } else if (mbr != null) {
                throw new IllegalArgumentException(Messages.DataSetLocation_1);
            }
        }
        this.highLevelQualifier = hlq == null ? null : hlq.toUpperCase();
        this.dataSetName = dsn == null ? null : JzosUtility.substituteSystemSymbols((String)dsn.toUpperCase());
        this.memberName = mbr == null ? null : mbr.toUpperCase();
        this.hasMember = mbr != null;
        this.dbg = SCMEEStorageManager.getCommonDbg();
        this.debug = this.dbg.isDebug();
        this.trace = this.dbg.isTrace();
        this.items = this.dbg.isItems();
        if (this.debug) {
            Debug.setup((IDebugger)this.dbg, (String[])new String[]{cls});
        }
        if (this.trace) {
            Debug.setup((IDebugger)this.dbg, (String[])new String[]{cls, LogField.valueOf((String)this.highLevelQualifier)});
        }
        if (this.trace) {
            Debug.setup((IDebugger)this.dbg, (String[])new String[]{cls, LogField.valueOf((String)this.dataSetName)});
        }
        if (this.trace) {
            Debug.setup((IDebugger)this.dbg, (String[])new String[]{cls, LogField.valueOf((String)this.memberName)});
        }
        if (this.trace) {
            Debug.setup((IDebugger)this.dbg, (String[])new String[]{cls, LogField.valueOf((boolean)this.hasMember)});
        }
        if (this.items) {
            DebugStack.setup((IDebugger)this.dbg, (String)cls);
        }
    }

    public DataSetLocation(ILocation location, IRelativeLocation relativeLocation) {
        if (location == null) {
            throw new IllegalArgumentException(Messages.DataSetLocation_2);
        }
        if (!location.getStorageId().equals(STORAGE_ID)) {
            throw new IllegalStateException(Messages.DataSetLocation_3);
        }
        if (location.isEmpty()) {
            throw new IllegalStateException(Messages.DataSetLocation_4);
        }
        DataSetLocation dataSetLocation = (DataSetLocation)location.getAdapter(DataSetLocation.class);
        if (dataSetLocation == null) {
            throw new IllegalStateException(Messages.DataSetLocation_5);
        }
        this.highLevelQualifier = JzosUtility.substituteSystemSymbols((String)dataSetLocation.highLevelQualifier);
        this.hasHighLevelQualifier = this.highLevelQualifier != null;
        String dsName = dataSetLocation.dataSetName;
        if (dsName != null) {
            dsName = JzosUtility.substituteSystemSymbols((String)dataSetLocation.dataSetName);
        }
        String member = dataSetLocation.memberName;
        if (relativeLocation != null && !relativeLocation.isEmpty()) {
            int i = 0;
            if (dsName == null) {
                String s = JzosUtility.substituteSystemSymbols((String)relativeLocation.segments()[i]);
                dsName = s == null ? relativeLocation.segments()[i] : s;
                ++i;
            }
            if (member == null && i < relativeLocation.segmentCount()) {
                member = relativeLocation.segments()[i];
                ++i;
            }
            if (i != relativeLocation.segmentCount()) {
                throw new IllegalStateException(NLS.bind((String)Messages.DataSetLocation_6, (Object)location.toString(), (Object[])new Object[]{relativeLocation.toString()}));
            }
        }
        this.dataSetName = dsName == null ? null : JzosUtility.substituteSystemSymbols((String)dsName.toUpperCase());
        this.hasDataSetName = this.dataSetName != null;
        this.memberName = member == null ? null : member.toUpperCase();
        this.hasMember = this.memberName != null;
        this.dbg = SCMEEStorageManager.getCommonDbg();
        this.debug = this.dbg.isDebug();
        this.trace = this.dbg.isTrace();
        this.items = this.dbg.isItems();
        if (this.debug) {
            Debug.setup((IDebugger)this.dbg, (String[])new String[]{cls});
        }
        if (this.trace) {
            Debug.setup((IDebugger)this.dbg, (String[])new String[]{cls, LogField.valueOf((String)this.highLevelQualifier)});
        }
        if (this.trace) {
            Debug.setup((IDebugger)this.dbg, (String[])new String[]{cls, LogField.valueOf((String)this.dataSetName)});
        }
        if (this.trace) {
            Debug.setup((IDebugger)this.dbg, (String[])new String[]{cls, LogField.valueOf((String)this.memberName)});
        }
        if (this.trace) {
            Debug.setup((IDebugger)this.dbg, (String[])new String[]{cls, LogField.valueOf((boolean)this.hasMember)});
        }
        if (this.items) {
            DebugStack.setup((IDebugger)this.dbg, (String)cls);
        }
    }

    public boolean isEmpty() {
        return !(this.highLevelQualifier != null && !this.highLevelQualifier.isEmpty() || this.dataSetName != null && !this.dataSetName.isEmpty());
    }

    public String toOSString() {
        return this.toString();
    }

    public String toString() {
        if (this.highLevelQualifier == null) {
            return "";
        }
        if (this.dataSetName == null) {
            return this.highLevelQualifier;
        }
        StringBuffer buffer = new StringBuffer(this.highLevelQualifier.length() + (this.dataSetName.length() + 1) + (this.memberName == null ? 0 : this.memberName.length() + 2));
        buffer.append(this.highLevelQualifier).append(".").append(this.dataSetName);
        if (this.memberName != null) {
            buffer.append("(").append(this.memberName).append(")");
        }
        return buffer.toString();
    }

    public String getDataSetPrefix() {
        return this.highLevelQualifier;
    }

    public boolean isHierarchical() {
        return false;
    }

    public Object getAdapter(Class adaptTo) {
        if (adaptTo.isAssignableFrom(DataSetLocation.class)) {
            return this;
        }
        return null;
    }

    public ILocation getParent() {
        if (this.memberName != null) {
            return new DataSetLocation(this.highLevelQualifier, this.dataSetName, null);
        }
        if (this.dataSetName != null) {
            return new DataSetLocation(this.highLevelQualifier, null, null);
        }
        return new DataSetLocation(null, null, null);
    }

    public String getName() {
        if (this.memberName != null) {
            return this.memberName;
        }
        if (this.dataSetName != null) {
            return this.dataSetName;
        }
        if (this.highLevelQualifier != null) {
            return this.highLevelQualifier;
        }
        return "";
    }

    public String getDatasetName() {
        if (this.dataSetName != null) {
            return String.valueOf(this.highLevelQualifier) + "." + this.dataSetName;
        }
        return this.highLevelQualifier;
    }

    public String getMember() {
        return this.memberName;
    }

    public boolean hasMember() {
        return this.hasMember;
    }

    public void setMember(String value) {
        this.memberName = value;
        this.hasMember = this.memberName != null;
    }

    public String getHighLevelQualifier() {
        return this.highLevelQualifier;
    }

    public boolean hasHighLevelQualifier() {
        return this.hasHighLevelQualifier;
    }

    public void setHighLevelQualifier(String value) {
        this.highLevelQualifier = value;
        this.hasHighLevelQualifier = this.highLevelQualifier != null;
    }

    public String getDataSetName() {
        return this.dataSetName;
    }

    public boolean hasDataSetName() {
        return this.hasDataSetName;
    }

    public void setDataSetName(String value) {
        this.dataSetName = value;
        this.hasDataSetName = this.dataSetName != null;
    }

    public boolean iszFolder() {
        return this.zFolder;
    }

    public void setzFolder(boolean zFolder) {
        this.zFolder = zFolder;
    }

    public ILocation append(String name) {
        if (this.highLevelQualifier == null) {
            return new DataSetLocation(name, null, null);
        }
        if (this.dataSetName == null) {
            return new DataSetLocation(this.highLevelQualifier, name, null);
        }
        if (this.memberName == null) {
            return new DataSetLocation(this.highLevelQualifier, this.dataSetName, name);
        }
        throw new IllegalStateException(NLS.bind((String)Messages.DataSetLocation_7, (Object)this.toOSString(), (Object[])new Object[0]));
    }

    public ILocation append(IRelativeLocation location) {
        return new DataSetLocation(this, location);
    }

    public ILocation getCanonicalForm() {
        return this;
    }

    public ILocation getCanonicalForm(boolean isCaseSensitive, boolean convertCase) {
        if (isCaseSensitive || !convertCase) {
            return this;
        }
        return new DataSetLocation(this.highLevelQualifier == null ? null : this.highLevelQualifier.toLowerCase(), this.dataSetName == null ? null : JzosUtility.substituteSystemSymbols((String)this.dataSetName.toLowerCase()), this.memberName == null ? null : this.memberName.toLowerCase());
    }

    public boolean isPrefixOf(ILocation anotherLocation) {
        DataSetLocation otherLocation = (DataSetLocation)anotherLocation.getAdapter(DataSetLocation.class);
        if (otherLocation == null) {
            return false;
        }
        if (this.highLevelQualifier == null) {
            return true;
        }
        if (this.highLevelQualifier.equals(otherLocation.highLevelQualifier)) {
            if (this.dataSetName == null) {
                return true;
            }
            if (this.dataSetName.equals(otherLocation.dataSetName)) {
                if (this.memberName == null) {
                    return true;
                }
                return this.memberName.equals(otherLocation.memberName);
            }
        }
        return false;
    }

    public boolean isPrefixOf(ILocation anotherLocation, boolean isCaseSensitive) {
        DataSetLocation otherLocation = (DataSetLocation)anotherLocation.getAdapter(DataSetLocation.class);
        if (otherLocation == null) {
            return false;
        }
        if (this.highLevelQualifier == null) {
            return true;
        }
        if (this.highLevelQualifier.equalsIgnoreCase(otherLocation.highLevelQualifier)) {
            if (this.dataSetName == null) {
                return true;
            }
            if (this.dataSetName.equalsIgnoreCase(otherLocation.dataSetName)) {
                if (this.memberName == null) {
                    return true;
                }
                return this.memberName.equalsIgnoreCase(otherLocation.memberName);
            }
        }
        return false;
    }

    public boolean isCaseSensitive() {
        return true;
    }

    public IRelativeLocation getLocationRelativeTo(ILocation location) {
        DataSetLocation prefix = (DataSetLocation)location.getAdapter(DataSetLocation.class);
        if (prefix == null || !location.isPrefixOf((ILocation)this)) {
            throw new IllegalStateException(NLS.bind((String)Messages.DataSetLocation_8, (Object)location.toString(), (Object[])new Object[]{this.toString()}));
        }
        if (prefix.highLevelQualifier == null) {
            if (this.highLevelQualifier == null) {
                return RelativeLocation.EMPTY_LOCATION;
            }
            if (this.dataSetName == null) {
                return new RelativeLocation(new String[]{this.highLevelQualifier});
            }
            if (this.memberName == null) {
                return new RelativeLocation(new String[]{this.highLevelQualifier, this.dataSetName});
            }
            return new RelativeLocation(new String[]{this.highLevelQualifier, this.dataSetName, this.memberName});
        }
        if (prefix.dataSetName == null) {
            if (this.dataSetName == null) {
                return RelativeLocation.EMPTY_LOCATION;
            }
            if (this.memberName == null) {
                return new RelativeLocation(new String[]{this.dataSetName});
            }
            return new RelativeLocation(new String[]{this.dataSetName, this.memberName});
        }
        if (prefix.memberName == null) {
            if (this.memberName == null) {
                return RelativeLocation.EMPTY_LOCATION;
            }
            return new RelativeLocation(new String[]{this.memberName});
        }
        return RelativeLocation.EMPTY_LOCATION;
    }

    public boolean sameLocation(ILocation anotherLocation, boolean isCaseSensitive) {
        if (isCaseSensitive) {
            return this.equals(anotherLocation);
        }
        if (this == anotherLocation) {
            return true;
        }
        if (anotherLocation == null) {
            return false;
        }
        if (this.getClass() != anotherLocation.getClass()) {
            return false;
        }
        DataSetLocation other = (DataSetLocation)anotherLocation;
        if (this.dataSetName == null ? other.dataSetName != null : !this.dataSetName.equalsIgnoreCase(other.dataSetName)) {
            return false;
        }
        if (this.highLevelQualifier == null ? other.highLevelQualifier != null : !this.highLevelQualifier.equalsIgnoreCase(other.highLevelQualifier)) {
            return false;
        }
        return !(this.memberName == null ? other.memberName != null : !this.memberName.equalsIgnoreCase(other.memberName));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dataSetName == null ? 0 : this.dataSetName.hashCode());
        result = 31 * result + (this.highLevelQualifier == null ? 0 : this.highLevelQualifier.hashCode());
        result = 31 * result + (this.memberName == null ? 0 : this.memberName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DataSetLocation)) {
            return false;
        }
        DataSetLocation other = (DataSetLocation)obj;
        if (this.highLevelQualifier != null ? !this.highLevelQualifier.equals(other.highLevelQualifier) : other.highLevelQualifier != null) {
            return false;
        }
        if (this.dataSetName != null ? !this.dataSetName.equals(other.dataSetName) : other.dataSetName != null) {
            return false;
        }
        if (this.iszFolder()) {
            if (other.iszFolder()) {
                return true;
            }
            return other.memberName != null;
        }
        if (other.iszFolder()) {
            if (this.iszFolder()) {
                return true;
            }
            return this.memberName != null;
        }
        return !(this.memberName != null ? !this.memberName.equals(other.memberName) : other.memberName != null);
    }

    public String getStorageId() {
        return STORAGE_ID;
    }
}

