/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.scmee.ibmi.internal.test;

import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.team.enterprise.scmee.ibmi.internal.IAS400Record;
import com.ibm.team.enterprise.scmee.ibmi.internal.test.SimulatedIAS400Record;
import com.ibm.team.enterprise.scmee.ibmi.internal.test.SimulatedSequentialFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;

public class SimulatedSequentialInputFile
extends SimulatedSequentialFile {
    private BufferedReader in;
    private final byte[] spaceBytes;

    public SimulatedSequentialInputFile(int reclen, String encoding, File file) throws UnsupportedEncodingException {
        super(reclen, encoding, file);
        this.spaceBytes = " ".getBytes(encoding);
    }

    @Override
    public void open(int openType, int blockingFactor, int commitLockLevel) throws IOException {
        super.open(openType, blockingFactor, commitLockLevel);
        this.in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.file), this.encoding));
    }

    @Override
    public IAS400Record readNext() throws IOException, InterruptedException, AS400SecurityException, AS400Exception {
        String line = this.in.readLine();
        if (line == null) {
            return null;
        }
        byte[] lineBytes = line.getBytes(this.encoding);
        if (lineBytes.length > this.recordLength) {
            throw new IllegalStateException("Line too long: " + line);
        }
        byte[] bytes = new byte[this.recordLength];
        int idx = 0;
        while (idx < lineBytes.length) {
            bytes[idx] = lineBytes[idx];
            ++idx;
        }
        while (idx < this.recordLength) {
            int j = 0;
            while (j < this.spaceBytes.length) {
                bytes[idx] = this.spaceBytes[j];
                ++idx;
                ++j;
            }
        }
        SimulatedIAS400Record rec = new SimulatedIAS400Record(this.recordLength);
        rec.setContents(bytes);
        return rec;
    }

    @Override
    public void write(IAS400Record[] records) throws IOException {
        throw new IllegalStateException("Can't write to a SimulatedSequentialInputFile. Use SimulatedSequentialFile instead.");
    }

    @Override
    public void close() throws IOException, InterruptedException, AS400SecurityException, AS400Exception {
        super.close();
        this.in.close();
    }
}

