/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.scmee.ibmi.internal.test;

import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.RecordFormat;
import com.ibm.team.enterprise.scmee.ibmi.internal.IAS400Record;
import com.ibm.team.enterprise.scmee.ibmi.internal.IBMiMemberInputStream;
import com.ibm.team.enterprise.scmee.ibmi.internal.ISequentialFile;
import com.ibm.team.enterprise.scmee.ibmi.internal.test.SimulatedIAS400Record;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class SimulatedSequentialFile
implements ISequentialFile {
    private static final String ENDL = System.getProperty("line.separator");
    protected final int recordLength;
    protected final String encoding;
    private boolean isOpen;
    protected final File file;

    public SimulatedSequentialFile(int reclen, String encoding, File file) {
        this.recordLength = reclen;
        this.encoding = encoding;
        this.file = file;
        this.isOpen = false;
    }

    @Override
    public void setRecordFormat() {
    }

    @Override
    public void setRecordFormat(RecordFormat format) throws PropertyVetoException {
    }

    @Override
    public void open(int openType, int blockingFactor, int commitLockLevel) throws IOException {
        this.isOpen = true;
    }

    @Override
    public IAS400Record getNewRecord() {
        return new SimulatedIAS400Record(this.recordLength);
    }

    @Override
    public void write(IAS400Record[] records) throws IOException {
        FileOutputStream out = new FileOutputStream(this.file);
        IAS400Record[] iAS400RecordArray = records;
        int n = records.length;
        int n2 = 0;
        while (n2 < n) {
            IAS400Record thisRec = iAS400RecordArray[n2];
            String s = String.valueOf(IBMiMemberInputStream.trimTrailing(new String(((SimulatedIAS400Record)thisRec).contents, this.encoding))) + ENDL;
            out.write(s.getBytes(this.encoding));
            ++n2;
        }
        out.close();
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public void close() throws IOException, InterruptedException, AS400SecurityException, AS400Exception {
        this.isOpen = false;
    }

    @Override
    public IAS400Record readNext() throws IOException, InterruptedException, AS400SecurityException, AS400Exception {
        throw new IllegalStateException("Can't read from a SimulatedSequentialFile.  Use SimulatedSequentialInputFile.");
    }
}

