/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.scmee.ibmi.internal.test;

import com.ibm.team.enterprise.common.common.utils.LoadTracing;
import com.ibm.team.enterprise.scmee.common.SCMEEFileStorage;
import com.ibm.team.enterprise.scmee.ibmi.IBMiLibraryLocation;
import com.ibm.team.enterprise.scmee.ibmi.internal.IBMiFileInterface;
import com.ibm.team.enterprise.scmee.ibmi.internal.ISequentialFile;
import com.ibm.team.enterprise.scmee.ibmi.internal.test.SimulatedIBMiMemberInputStream;
import com.ibm.team.enterprise.scmee.ibmi.internal.test.SimulatedSequentialFile;
import com.ibm.team.filesystem.client.FileSystemException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public class SimulatedIBMiFileInterface
extends IBMiFileInterface {
    private static final String ATTRIBUTES_FILE_NAME = ".attributes";
    public static final String CCSID_KEY = "ccsid";
    public static final String RECLEN_KEY = "reclen";
    public static final String IGCDATA_KEY = "igcData";
    public static final String TEXTDESCRIPTION_KEY = "textdescription";
    public static int UPDATE_MEMBER_CONTENTS_CALLS = 0;
    private File file = this.getLibraryFile();

    private File getLibraryFile() {
        return new File(new File(SCMEEFileStorage.SIMULER_AREA, "QSYS.LIB"), String.valueOf(this.getActualLibraryName()) + ".LIB");
    }

    private File getPhysicalFileFile() {
        return new File(this.getLibraryFile(), String.valueOf(this.fullPath.getFilename()) + ".FILE");
    }

    private File getPhysicalAttributesFile() {
        return new File(this.getPhysicalFileFile(), ATTRIBUTES_FILE_NAME);
    }

    public Map<String, String> getPhysicalFileAttributes() {
        try {
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(this.getPhysicalAttributesFile()));
            Map map = (Map)in.readObject();
            in.close();
            return new HashMap<String, String>(map);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private void writePhysicalFileAttributes(String ccsID, String recLen, String igcData, String textDescription) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>(4);
        map.put(CCSID_KEY, ccsID);
        map.put(RECLEN_KEY, recLen);
        map.put(IGCDATA_KEY, igcData);
        map.put(TEXTDESCRIPTION_KEY, textDescription);
        ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(this.getPhysicalAttributesFile()));
        out.writeObject(map);
        out.close();
    }

    public SimulatedIBMiFileInterface(IBMiLibraryLocation location, LoadTracing lt) {
        super(location, lt);
        String member;
        String filename = location.getFilename();
        if (filename != null) {
            this.file = this.getPhysicalFileFile();
        }
        if ((member = location.getMember()) != null) {
            this.file = new File(this.file, String.valueOf(member) + ".MBR");
        }
    }

    @Override
    public boolean updateMemberContents(InputStream in, String serverEncoding, boolean isBinary) throws FileSystemException {
        ++UPDATE_MEMBER_CONTENTS_CALLS;
        return super.updateMemberContents(in, serverEncoding, isBinary);
    }

    @Override
    public boolean exists() throws FileSystemException {
        return this.file.exists();
    }

    @Override
    protected boolean libExists() throws FileSystemException {
        return this.getLibraryFile().exists();
    }

    @Override
    protected void createContainingLibrary() throws FileSystemException {
        File libFile = this.getLibraryFile();
        boolean success = libFile.mkdirs();
        if (!success) {
            throw new FileSystemException("Couldn't create containing library " + libFile.getAbsolutePath());
        }
    }

    @Override
    public void createPhysicalFile(String ccsID, String recLen, String igcData, String textDescription) throws FileSystemException {
        File physicalFileFile = this.getPhysicalFileFile();
        boolean success = physicalFileFile.mkdir();
        if (!success) {
            throw new FileSystemException("Could create physical file " + physicalFileFile.getAbsolutePath());
        }
        try {
            this.writePhysicalFileAttributes(ccsID, recLen, igcData, textDescription);
        }
        catch (IOException ex) {
            throw new FileSystemException((Throwable)ex);
        }
    }

    @Override
    public void createMember(String textDescription, String sourceType) throws FileSystemException {
        if (!this.isMember()) {
            throw new IllegalStateException();
        }
        try {
            this.file.createNewFile();
        }
        catch (IOException ex) {
            throw new FileSystemException((Throwable)ex);
        }
    }

    @Override
    public void clearMember(String textDescription, String sourceType) throws FileSystemException {
        if (!this.isMember()) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void delete() throws FileSystemException {
        if (!this.isMember()) {
            throw new IllegalStateException("Trying to delete non-member");
        }
        boolean success = this.file.delete();
        if (!success) {
            throw new FileSystemException("Couldn't delete " + this.file.getAbsolutePath());
        }
    }

    @Override
    protected boolean runCommand(String cmdStr) throws FileSystemException {
        throw new FileSystemException("Can't run a command in simulation mode.");
    }

    @Override
    protected ISequentialFile createSequentialFile() {
        Map<String, String> attrs = this.getPhysicalFileAttributes();
        return new SimulatedSequentialFile(Integer.parseInt(attrs.get(RECLEN_KEY)), SimulatedIBMiFileInterface.mapLocalEncoding(attrs.get(CCSID_KEY)), this.file);
    }

    @Override
    public int getCCSID() {
        return Integer.parseInt(this.getPhysicalFileAttributes().get(CCSID_KEY));
    }

    @Override
    protected byte[] stringToByteArray(int ccsID, String str) throws UnsupportedEncodingException {
        return str.getBytes(SimulatedIBMiFileInterface.mapLocalEncoding("" + ccsID));
    }

    @Override
    public long getModificationStamp() throws FileSystemException {
        return this.file.lastModified();
    }

    public static String mapLocalEncoding(String origEncoding) {
        String result = origEncoding;
        switch (origEncoding) {
            case "37": {
                result = "IBM-037";
                break;
            }
            case "5035": {
                result = "MS932";
            }
        }
        return result;
    }

    @Override
    public InputStream getEncodedContents(String localEncoding, String serverEncoding) throws UnsupportedEncodingException {
        return new SimulatedIBMiMemberInputStream(this.getActualLibraryName(), this.fullPath.getFilename(), this.fullPath.getMember(), Integer.parseInt(localEncoding), serverEncoding, Integer.parseInt(this.getPhysicalFileAttributes().get(RECLEN_KEY)), this.file);
    }

    public boolean clearAttributesFile() {
        return this.getPhysicalAttributesFile().delete();
    }

    public File getJavaFile() {
        return this.file;
    }
}

