/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.scmee.ibmi.internal;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.Record;
import com.ibm.as400.access.RecordFormat;
import com.ibm.as400.access.SequentialFile;
import com.ibm.team.enterprise.scmee.ibmi.internal.AS400RecordWrapper;
import com.ibm.team.enterprise.scmee.ibmi.internal.IAS400Record;
import com.ibm.team.enterprise.scmee.ibmi.internal.ISequentialFile;
import java.beans.PropertyVetoException;
import java.io.IOException;

public class SequentialFileWrapper
implements ISequentialFile {
    private final SequentialFile file;

    public SequentialFileWrapper(AS400 as400, String ifsPath) {
        this.file = new SequentialFile(as400, ifsPath);
    }

    @Override
    public void setRecordFormat() throws PropertyVetoException, IOException, InterruptedException, AS400SecurityException, AS400Exception {
        this.file.setRecordFormat();
    }

    @Override
    public void open(int openType, int blockingFactor, int commitLockLevel) throws IOException, InterruptedException, AS400SecurityException, AS400Exception {
        this.file.open(openType, blockingFactor, commitLockLevel);
    }

    @Override
    public IAS400Record getNewRecord() {
        return new AS400RecordWrapper(this.file.getRecordFormat().getNewRecord());
    }

    @Override
    public void write(IAS400Record[] records) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        Record[] toWrite = new Record[records.length];
        int i = 0;
        while (i < records.length) {
            toWrite[i] = ((AS400RecordWrapper)records[i]).getRecord();
            ++i;
        }
        this.file.write(toWrite);
    }

    @Override
    public boolean isOpen() {
        return this.file.isOpen();
    }

    @Override
    public void close() throws IOException, InterruptedException, AS400SecurityException, AS400Exception {
        this.file.close();
    }

    @Override
    public void setRecordFormat(RecordFormat format) throws PropertyVetoException {
        this.file.setRecordFormat(format);
    }

    @Override
    public IAS400Record readNext() throws IOException, InterruptedException, AS400SecurityException, AS400Exception {
        Record record = this.file.readNext();
        if (record != null) {
            return new AS400RecordWrapper(record);
        }
        return null;
    }
}

