/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.scmee.ibmi.internal;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.CharConverter;
import java.awt.Point;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

public class IBMiUtilities {
    private static final char SOSI_SPLITTER = '\u200c';
    private static final String SOSI_SPLITTER_STRING = String.valueOf('\u200c');
    private static final List<Integer> mixedDBCSccsids = Arrays.asList(930, 932, 933, 934, 935, 936, 937, 938, 939, 942, 943, 944, 946, 948, 949, 950, 954, 956, 957, 958, 959, 964, 965, 970, 1363, 1364, 1381, 1383, 1386, 1388, 1399, 5026, 5035, 5050, 5052, 5053, 5054, 5055, 17354, 25546, 33722);
    private static final int EOR = -1;
    private static List<Integer> _stringIndices;

    public static String massageTextDescription(String textDescription) {
        if (textDescription == null) {
            return "";
        }
        StringBuffer temp = new StringBuffer(textDescription);
        String quote = "'";
        int index = -1;
        int startIndex = 0;
        index = temp.indexOf(quote, startIndex);
        while (index != -1) {
            if (index < temp.length() - 1) {
                temp = temp.insert(index + 1, quote);
                startIndex = index + 2;
                index = temp.indexOf(quote, startIndex);
                continue;
            }
            temp = temp.append(quote);
            break;
        }
        return temp.toString();
    }

    public static byte[] convClientStringToHostBytes(int targetCCSID, AS400 as400, String source) throws UnsupportedEncodingException {
        Vector<Point> overrideFormat = null;
        if (mixedDBCSccsids.contains(targetCCSID)) {
            source = IBMiUtilities.removeSplitters(source);
            overrideFormat = IBMiUtilities.getRecordFormat();
        }
        Vector<byte[]> result = new Vector<byte[]>();
        if (overrideFormat != null && !overrideFormat.isEmpty()) {
            int start = 0;
            int arrayLen = 0;
            int i = 0;
            while (i < overrideFormat.size()) {
                byte[] temp;
                Point point = overrideFormat.elementAt(i);
                int x = point.x;
                int y = point.y;
                if (y == -1) {
                    y = source.length();
                }
                if (start < x - 1) {
                    temp = CharConverter.stringToByteArray((int)targetCCSID, (AS400)as400, (String)source.substring(start, x - 1));
                    result.add(temp);
                    arrayLen += temp.length;
                    temp = CharConverter.stringToByteArray((int)targetCCSID, (AS400)as400, (String)source.substring(x - 1, y));
                    result.add(temp);
                    arrayLen += temp.length;
                    start = y;
                } else {
                    temp = CharConverter.stringToByteArray((int)targetCCSID, (AS400)as400, (String)source.substring(x - 1, y));
                    result.add(temp);
                    arrayLen += temp.length;
                    start = y;
                }
                ++i;
            }
            byte[] byteResult = new byte[arrayLen];
            int position = 0;
            int i2 = 0;
            while (i2 < result.size()) {
                int length = ((byte[])result.get(i2)).length;
                System.arraycopy(result.get(i2), 0, byteResult, position, length);
                position += length;
                ++i2;
            }
            return byteResult;
        }
        return CharConverter.stringToByteArray((int)targetCCSID, (AS400)as400, (String)source);
    }

    private static String removeSplitters(String line) {
        int found;
        StringBuffer lineBuf = new StringBuffer(line);
        _stringIndices = new LinkedList<Integer>();
        int start = 0;
        do {
            if ((found = lineBuf.indexOf(SOSI_SPLITTER_STRING, start)) != -1) {
                lineBuf.deleteCharAt(found);
                _stringIndices.add(found);
            }
            start = found;
        } while (found != -1);
        return lineBuf.toString();
    }

    private static Vector<Point> getRecordFormat() {
        Vector<Point> points = new Vector<Point>();
        if (!_stringIndices.isEmpty()) {
            Point lastPoint = new Point(_stringIndices.get(0) + 1, -1);
            int i = 1;
            while (i < _stringIndices.size()) {
                int index;
                lastPoint.y = index = _stringIndices.get(i).intValue();
                points.add(lastPoint);
                lastPoint = new Point(index + 1, -1);
                ++i;
            }
            points.add(lastPoint);
        }
        return points;
    }
}

