/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.scmee.ibmi.internal;

import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IBMiProjectResourceNameUtil {
    public static String copyright = "\ufffd Copyright IBM Corp 2008, 2010.";
    private static char[] escapableCharacters = new char[]{'\\', '/', ':', '\"', '<', '>', '|', '%', '#', '\u00a5', '\u00a2', '\u00a6', '\u00ac'};
    private static Character escapeTrigger = new Character('#');
    private static Pattern escapePattern = Pattern.compile("#\\d\\d\\d");
    private static int escapeSequenceLength = 4;
    private static HashMap<Character, String> escapeMap = new HashMap();
    private static HashMap<String, Character> unescapeMap = new HashMap();

    static {
        int i = 0;
        while (i < escapableCharacters.length) {
            Character c = Character.valueOf(escapableCharacters[i]);
            String s = "000" + Integer.toString(c.charValue());
            s = "#" + s.substring(s.length() - 3);
            escapeMap.put(c, s);
            unescapeMap.put(s, c);
            ++i;
        }
    }

    private static String getEscapeSequenceAt(int i, String name) {
        String lookAhead;
        Character d;
        String result = "";
        Character c = new Character(name.charAt(i));
        int n = name.length();
        if (c.equals(escapeTrigger) && i + escapeSequenceLength <= n && (d = unescapeMap.get(lookAhead = name.substring(i, i + escapeSequenceLength))) != null) {
            result = lookAhead;
        }
        return result;
    }

    public static boolean isEscaped(String name) {
        boolean found = false;
        Matcher m = escapePattern.matcher(name);
        while (m.find() && !found) {
            String s = m.group();
            Character c = unescapeMap.get(s);
            boolean bl = found = c != null;
        }
        return found;
    }

    public static boolean isUnescaped(String name) {
        int n = name.length();
        boolean found = false;
        int i = 0;
        while (i < n && !found) {
            String escapeSequence = IBMiProjectResourceNameUtil.getEscapeSequenceAt(i, name);
            if (escapeSequence.length() == 0) {
                Character c = new Character(name.charAt(i));
                String s = escapeMap.get(c);
                found = s != null;
                ++i;
                continue;
            }
            i += escapeSequence.length();
        }
        return found;
    }

    public static String escapeFileName(String name) {
        String result = name;
        if (IBMiProjectResourceNameUtil.isUnescaped(name)) {
            StringBuilder buffer = new StringBuilder(2 * name.length());
            int n = name.length();
            int i = 0;
            while (i < n) {
                String escapeSequence = IBMiProjectResourceNameUtil.getEscapeSequenceAt(i, name);
                if (escapeSequence.length() == 0) {
                    Character c = new Character(name.charAt(i));
                    String s = escapeMap.get(c);
                    if (s == null) {
                        buffer.append(c);
                    } else {
                        buffer.append(s);
                    }
                    ++i;
                    continue;
                }
                buffer.append(escapeSequence);
                i += escapeSequence.length();
            }
            result = buffer.toString();
        }
        return result;
    }

    public static String unEscapeFileName(String name) {
        String result = name;
        if (IBMiProjectResourceNameUtil.isEscaped(name)) {
            StringBuilder buffer = new StringBuilder(name.length());
            Matcher m = escapePattern.matcher(name);
            int pStart = 0;
            int pEnd = 0;
            while (m.find()) {
                pEnd = m.start();
                buffer.append(name.substring(pStart, pEnd));
                String s = m.group();
                Character c = unescapeMap.get(s);
                if (c != null) {
                    buffer.append(c);
                } else {
                    buffer.append(s);
                }
                pStart = m.end();
            }
            pEnd = name.length();
            buffer.append(name.substring(pStart, pEnd));
            result = buffer.toString();
        }
        return result;
    }
}

