/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.scmee.ibmi.internal;

import com.ibm.team.enterprise.scmee.common.DeferredFileLoadInformation;
import com.ibm.team.enterprise.scmee.ibmi.internal.FolderInfo;
import com.ibm.team.enterprise.scmee.ibmi.internal.IPhysicalFileInfo;
import com.ibm.team.enterprise.scmee.ibmi.internal.NonIFolderInfo;
import com.ibm.team.enterprise.scmee.ibmi.internal.SideFilePhysicalFileInfo;
import com.ibm.team.enterprise.scmee.ibmi.internal.messages.Messages;
import com.ibm.team.enterprise.systemdefinition.client.ClientFactory;
import com.ibm.team.enterprise.systemdefinition.common.model.IIBMiResourceDefinition;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.IShareableInternal;
import com.ibm.team.filesystem.client.internal.Shed;
import com.ibm.team.filesystem.client.internal.content.DeletedContent;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.operations.DilemmaHandler;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdate;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;

public abstract class IBMiMutator
extends FileSystemOperation {
    private static final Log LOG = LogFactory.getLog(IBMiMutator.class);
    private Map<UUID, Map<UUID, IIBMiResourceDefinition>> projectsEncountered;
    private Map<UUID, Map<UUID, FolderInfo>> foldersEncountered;
    protected Shed shed;

    protected IBMiMutator(DilemmaHandler dilemmaHandler) {
        super(dilemmaHandler);
        this.initCache();
    }

    protected void initCache() {
        this.projectsEncountered = new HashMap<UUID, Map<UUID, IIBMiResourceDefinition>>();
        this.foldersEncountered = new HashMap<UUID, Map<UUID, FolderInfo>>();
    }

    protected static String getFilename(FileAreaUpdate update) {
        String filename = update.getName().toUpperCase();
        int indexOfPeriod = filename.indexOf(46);
        if (indexOfPeriod > 0) {
            filename = filename.substring(0, filename.indexOf(46));
        }
        return filename;
    }

    protected static IPhysicalFileInfo getPhysicalFileInfo(IConfiguration config, IVersionableHandle vHandle, String vName, IFolderHandle parentFolderHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return new SideFilePhysicalFileInfo(IBMiMutator.fetchSideFileProperties(config, vHandle, vName, parentFolderHandle, monitor));
    }

    protected static Map<String, String> fetchSideFileProperties(IConfiguration config, IVersionableHandle vHandle, String vName, IFolderHandle parentFolderHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        IVersionableHandle metadataFileHandle;
        String[] nameSegments;
        IFolderHandle projectFolder;
        HashMap<String, String> props = new HashMap<String, String>();
        boolean isFolder = vHandle instanceof IFolderHandle;
        if (isFolder) {
            projectFolder = parentFolderHandle;
            nameSegments = new String[]{vName, ".properties"};
        } else {
            IFolder parentFolder = (IFolder)config.fetchCompleteItem((IVersionableHandle)parentFolderHandle, monitor);
            projectFolder = parentFolder.getParent();
            nameSegments = new String[]{parentFolder.getName(), String.valueOf(vName) + ".properties"};
        }
        IVersionableHandle rootMetadataFolder = (IVersionableHandle)config.childEntries(projectFolder, monitor).get(".ibmi");
        if (rootMetadataFolder instanceof IFolderHandle && (metadataFileHandle = config.resolvePath((IFolderHandle)rootMetadataFolder, nameSegments, monitor)) instanceof IFileItemHandle) {
            IFileItem metadataFile = (IFileItem)config.fetchCompleteItem(metadataFileHandle, monitor);
            InputStream in = FileSystemCore.getContentManager((ITeamRepository)config.teamRepository()).retrieveContentStream((IFileItemHandle)metadataFile, metadataFile.getContent(), monitor);
            Properties metaProps = new Properties();
            try {
                try {
                    metaProps.load(in);
                }
                catch (IOException ex) {
                    throw new TeamRepositoryException((Throwable)ex);
                }
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    LOG.error((Object)"", (Throwable)ex);
                }
            }
            for (Map.Entry<Object, Object> next : metaProps.entrySet()) {
                props.put((String)next.getKey(), (String)next.getValue());
            }
        }
        return props;
    }

    protected boolean isIFile(FileAreaUpdate update, IConfiguration config, IProgressMonitor monitor) throws TeamRepositoryException {
        FolderInfo info;
        IVersionableHandle vHandle = update.afterState();
        if (!(vHandle instanceof IFileItemHandle)) {
            return false;
        }
        if (update.getName().startsWith(".")) {
            return false;
        }
        IFolderHandle parentHandle = update.getDestinationParent();
        if (parentHandle == null) {
            return false;
        }
        Map<UUID, FolderInfo> folderUUIDToInfoMap = this.foldersEncountered.get(config.component().getItemId());
        FolderInfo folderInfo = info = folderUUIDToInfoMap == null ? null : folderUUIDToInfoMap.get(parentHandle.getItemId());
        if (info != null) {
            return info.isIFolder();
        }
        IFolder parent = this.fetchCompleteFolder(config, parentHandle, monitor);
        return this.isIFolder((IVersionableHandle)parent, parent.getName(), parent.getParent(), config, monitor);
    }

    protected boolean checkAndRegisterIProject(IFolderHandle potentialIProjectFolderHandle, IConfiguration config, Map<String, String> userProperties, String name, IProgressMonitor monitor) throws TeamRepositoryException {
        String sourceLibVal;
        if (potentialIProjectFolderHandle == null) {
            return false;
        }
        Map<UUID, IIBMiResourceDefinition> projUUIDToResourceDefnMap = this.projectsEncountered.get(config.component().getItemId());
        if (projUUIDToResourceDefnMap != null && projUUIDToResourceDefnMap.get(potentialIProjectFolderHandle.getItemId()) != null) {
            return true;
        }
        Map<UUID, FolderInfo> folderUUIDToInfoMap = this.foldersEncountered.get(config.component().getItemId());
        if (folderUUIDToInfoMap != null && folderUUIDToInfoMap.get(potentialIProjectFolderHandle.getItemId()) != null) {
            return false;
        }
        if (userProperties == null) {
            IFolder potentialIProjectFolder = this.fetchCompleteFolder(config, potentialIProjectFolderHandle, monitor);
            userProperties = potentialIProjectFolder.getUserProperties();
        }
        if ((sourceLibVal = userProperties.get("team.enterprise.source.library")) == null) {
            return false;
        }
        IIBMiResourceDefinition resourceDefn = null;
        try {
            resourceDefn = (IIBMiResourceDefinition)ClientFactory.getSystemDefinitionModelClient((ITeamRepository)config.teamRepository()).findSystemDefinition(sourceLibVal, null, IIBMiResourceDefinition.ITEM_TYPE, monitor);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (resourceDefn == null) {
            this.collectStatus((IStatus)new Status(4, "com.ibm.team.enterprise.scmee.ibmi", NLS.bind((String)Messages.IBMiLoadMutator_1, (Object)sourceLibVal, (Object[])new Object[]{name}), null));
            return false;
        }
        if (projUUIDToResourceDefnMap == null) {
            projUUIDToResourceDefnMap = new HashMap<UUID, IIBMiResourceDefinition>();
            this.projectsEncountered.put(config.component().getItemId(), projUUIDToResourceDefnMap);
        }
        projUUIDToResourceDefnMap.put(potentialIProjectFolderHandle.getItemId(), resourceDefn);
        return true;
    }

    protected boolean isIFolder(FileAreaUpdate update, IConfiguration config, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.isIFolder(update.afterState(), update.getName(), update.getDestinationParent(), config, monitor);
    }

    private boolean isIFolder(IVersionableHandle vHandle, String name, IFolderHandle parentHandle, IConfiguration config, IProgressMonitor monitor) throws TeamRepositoryException {
        FolderInfo info;
        Map<UUID, FolderInfo> folderUUIDToInfoMap = this.foldersEncountered.get(config.component().getItemId());
        FolderInfo folderInfo = info = folderUUIDToInfoMap == null ? null : folderUUIDToInfoMap.get(vHandle.getItemId());
        if (info != null) {
            return info.isIFolder();
        }
        boolean isIFolder = !(vHandle instanceof IFolderHandle) ? false : (name.startsWith(".") ? false : this.checkAndRegisterIProject(parentHandle, config, null, name, monitor));
        if (folderUUIDToInfoMap == null) {
            folderUUIDToInfoMap = new HashMap<UUID, FolderInfo>();
            this.foldersEncountered.put(config.component().getItemId(), folderUUIDToInfoMap);
        }
        if (isIFolder) {
            folderUUIDToInfoMap.put(vHandle.getItemId(), new FolderInfo(name, parentHandle));
        } else {
            folderUUIDToInfoMap.put(vHandle.getItemId(), NonIFolderInfo.INSTANCE);
        }
        return isIFolder;
    }

    protected IFolder fetchCompleteFolder(IConfiguration config, IFolderHandle handle, IProgressMonitor monitor) throws TeamRepositoryException {
        return (IFolder)config.fetchCompleteItem((IVersionableHandle)handle, monitor);
    }

    protected FolderInfo getFolderInfo(IConfiguration config, IFolderHandle handle) {
        Map<UUID, FolderInfo> map = this.foldersEncountered.get(config.component().getItemId());
        return map == null ? null : map.get(handle.getItemId());
    }

    protected IIBMiResourceDefinition getResourceDefinition(IConfiguration config, IVersionableHandle projHandle) {
        Map<UUID, IIBMiResourceDefinition> map = this.projectsEncountered.get(config.component().getItemId());
        return map == null ? null : map.get(projHandle.getItemId());
    }

    protected abstract int notifyHandlerOfDeletedContent(List<IShareable> var1);

    protected abstract String getDeletedContentMessage();

    protected void handleDeletedContent(ArrayList<DeferredFileLoadInformation> pathsToUpdate, IProgressMonitor progress) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(pathsToUpdate.size() * 2));
        LocalChangeManager lcm = LocalChangeManager.getInstance();
        ArrayList<IShareable> contentDeleted = new ArrayList<IShareable>();
        for (DeferredFileLoadInformation deferredUpdateInformation : pathsToUpdate) {
            if (deferredUpdateInformation != null && deferredUpdateInformation.contentDeleted()) {
                IShareableInternal shareable = deferredUpdateInformation.getShareable();
                contentDeleted.add((IShareable)shareable);
                try {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    deferredUpdateInformation.getShareable().getFileStorage().setContents(deferredUpdateInformation.getFileOptions(), DeletedContent.getDeletedContentInputStream((String)deferredUpdateInformation.getEncoding()), this.shed, (IProgressMonitor)monitor.newChild(1));
                    lcm.computeChanges((IShareable)shareable, (IProgressMonitor)monitor.newChild(1));
                }
                catch (FileSystemException fileSystemException) {}
                continue;
            }
            monitor.worked(2);
        }
        if (!contentDeleted.isEmpty()) {
            int response = this.notifyHandlerOfDeletedContent(contentDeleted);
            if (response == 1) {
                throw new OperationCanceledException();
            }
            if (response != 0) {
                for (IShareable sharable : contentDeleted) {
                    this.collectStatus(FileSystemStatusUtil.getStatusFor((int)2, (String)NLS.bind((String)this.getDeletedContentMessage(), (Object)sharable.getLocalPath().toString(), (Object[])new Object[0])));
                }
            }
        }
    }
}

