/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.scmee.ibmi.internal;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400FileRecordDescription;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.RecordFormat;
import com.ibm.team.enterprise.scmee.ibmi.internal.IAS400Record;
import com.ibm.team.enterprise.scmee.ibmi.internal.ISequentialFile;
import com.ibm.team.enterprise.scmee.ibmi.internal.SequentialFileWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class IBMiMemberInputStream
extends InputStream {
    private final List<Byte> newline = new ArrayList<Byte>();
    private final QSYSObjectPathName filePathName;
    private final AS400 as400;
    private ISequentialFile seqFile;
    private boolean eof;
    private final int ccsid;
    private final String serverEncoding;
    private final List<Byte> buf = new ArrayList<Byte>();

    public IBMiMemberInputStream(AS400 as400, String library, String file, String member, int ccsid, String serverEncoding) throws UnsupportedEncodingException {
        this.as400 = as400;
        this.filePathName = new QSYSObjectPathName(library, file, member, "MBR");
        this.eof = false;
        this.ccsid = ccsid;
        this.serverEncoding = serverEncoding;
        byte[] nlBytes = System.getProperty("line.separator").getBytes(serverEncoding);
        int i = 0;
        while (i < nlBytes.length) {
            this.newline.add(nlBytes[i]);
            ++i;
        }
    }

    protected ISequentialFile createSequentialFile(String path) throws UnsupportedEncodingException {
        return new SequentialFileWrapper(this.as400, path);
    }

    protected RecordFormat getRecordFormat(String path) throws IOException, InterruptedException, AS400SecurityException, AS400Exception {
        return new AS400FileRecordDescription(this.as400, path).retrieveRecordFormat()[0];
    }

    private void open() throws IOException {
        String path = this.filePathName.getPath();
        this.seqFile = this.createSequentialFile(path);
        try {
            this.seqFile.setRecordFormat(this.getRecordFormat(path));
            this.seqFile.open(0, 100, 3);
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    protected String byteArrayToString(byte[] bytes) throws UnsupportedEncodingException {
        return CharConverter.byteArrayToString((int)this.ccsid, (AS400)this.as400, (byte[])bytes);
    }

    @Override
    public int read() throws IOException {
        if (this.seqFile == null) {
            this.open();
        }
        if (this.buf.isEmpty() && !this.eof) {
            try {
                IAS400Record rec = this.seqFile.readNext();
                if (rec == null) {
                    this.eof = true;
                } else {
                    String utfString = IBMiMemberInputStream.trimTrailing(this.byteArrayToString(rec.getContents()));
                    byte[] contents = utfString.getBytes(this.serverEncoding);
                    int i = 0;
                    while (i < contents.length) {
                        this.buf.add(contents[i]);
                        ++i;
                    }
                    this.buf.addAll(this.newline);
                }
            }
            catch (Exception ex) {
                throw new IOException(ex);
            }
        }
        if (this.buf.isEmpty()) {
            return -1;
        }
        return this.buf.remove(0).byteValue();
    }

    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            if (this.seqFile != null && this.seqFile.isOpen()) {
                try {
                    this.seqFile.close();
                }
                catch (Exception ex) {
                    throw new IOException(ex);
                }
            }
        }
    }

    public static String trimTrailing(String s) {
        if (s == null) {
            return null;
        }
        int idx = s.length() - 1;
        while (idx >= 0 && s.charAt(idx) == ' ') {
            --idx;
        }
        return idx >= 0 ? s.substring(0, idx + 1) : "";
    }
}

