/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.scmee.ibmi.internal;

import com.ibm.team.enterprise.common.common.utils.LoadTracing;
import com.ibm.team.enterprise.scmee.common.DeferredFileLoadInformation;
import com.ibm.team.enterprise.scmee.common.DownloadHandler;
import com.ibm.team.enterprise.scmee.common.SCMEEUtils;
import com.ibm.team.enterprise.scmee.ibmi.internal.FolderInfo;
import com.ibm.team.enterprise.scmee.ibmi.internal.IBMiMutator;
import com.ibm.team.enterprise.scmee.ibmi.internal.messages.Messages;
import com.ibm.team.enterprise.systemdefinition.common.model.IIBMiResourceDefinition;
import com.ibm.team.filesystem.client.FileDownloadHandler;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IFileContentManagerSession;
import com.ibm.team.filesystem.client.ILoadFilter;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.ILocalChangeManager;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.IFileOptions;
import com.ibm.team.filesystem.client.internal.IShareableInternal;
import com.ibm.team.filesystem.client.internal.RelativeLocation;
import com.ibm.team.filesystem.client.internal.SharingDescriptor;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.Shed;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.operations.ILoadMutator;
import com.ibm.team.filesystem.client.internal.utils.CancellationMonitor;
import com.ibm.team.filesystem.client.internal.utils.NonCancellingProgressMonitor;
import com.ibm.team.filesystem.client.operations.DilemmaHandler;
import com.ibm.team.filesystem.client.operations.IDownloadListener;
import com.ibm.team.filesystem.client.operations.ILoadLocation;
import com.ibm.team.filesystem.client.operations.IRemovedShare;
import com.ibm.team.filesystem.client.operations.LoadDilemmaHandler;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdate;
import com.ibm.team.filesystem.common.internal.dto.LoadTree;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.ThreadCheck;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.ComponentNotInWorkspaceException;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.ISynchronizationTime;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;

public class IBMiLoadMutator
extends IBMiMutator
implements ILoadMutator {
    private IComponent component;
    private IConnection connection;
    private IConfiguration config;
    private IDownloadListener downloadMonitor;
    private LoadTree loadTree;
    private IFileContentManagerSession contentSession = null;
    private final ISandbox sandbox;
    private Set<IRemovedShare> sharesToRemove;
    private HashSet<UUID> inconsistentShares;
    private Map<UUID, HashMap<String, UUID>> allFolderChildren;
    private Map<UUID, ILoadLocation> loadLocations;
    private ArrayList<DeferredFileLoadInformation> pathsToUpdate;
    private ArrayList<IVersionableHandle> shares = new ArrayList();
    private LoadDilemmaHandler problemHandler;
    private LoadTracing loadTracing = null;

    public IBMiLoadMutator(ISandbox sandbox, LoadDilemmaHandler loadProblemHandler, LoadTracing lt) {
        super((DilemmaHandler)(loadProblemHandler == null ? LoadDilemmaHandler.getDefault() : loadProblemHandler));
        this.problemHandler = loadProblemHandler == null ? LoadDilemmaHandler.getDefault() : loadProblemHandler;
        this.sandbox = sandbox;
        this.shed = new Shed(this.problemHandler.getBackupDilemmaHandler());
        this.loadTracing = lt;
    }

    public void configureLoad(int options, IConnection connection, IComponent component, List<? extends ILoadLocation> itemsToLoad, LoadTree loadTree, IDownloadListener downloadMonitor, ILoadFilter filter) {
        if (connection == null) {
            throw new IllegalArgumentException("Connection cannot be null.");
        }
        if (component == null) {
            throw new IllegalArgumentException("Component cannot be null.");
        }
        if (itemsToLoad == null) {
            throw new IllegalArgumentException("itemsToLoad cannot be null.");
        }
        if (loadTree == null) {
            throw new IllegalArgumentException("loadTree cannot be null.");
        }
        this.connection = connection;
        this.component = component;
        this.loadTree = loadTree;
        this.loadLocations = new HashMap<UUID, ILoadLocation>();
        this.downloadMonitor = downloadMonitor;
        for (ILoadLocation iLoadLocation : itemsToLoad) {
            if (!component.sameItemId((IItemHandle)iLoadLocation.getComponent())) {
                throw new IllegalArgumentException();
            }
            this.loadLocations.put(iLoadLocation.getRootToLoad().getItemId(), iLoadLocation);
        }
        if (connection instanceof IWorkspaceConnection) {
            IWorkspaceConnection iWorkspaceConnection = (IWorkspaceConnection)connection;
            try {
                this.config = iWorkspaceConnection.configuration((IComponentHandle)component);
            }
            catch (ComponentNotInWorkspaceException ex) {
                throw new IllegalArgumentException(ex);
            }
            catch (ItemNotFoundException ex) {
                throw new IllegalArgumentException(ex);
            }
        } else {
            IBaselineConnection iBaselineConnection = (IBaselineConnection)connection;
            this.config = iBaselineConnection.configuration();
        }
        this.initCache();
    }

    public void configureShareRemoval(Set<IRemovedShare> sharesToRemove) {
        this.sharesToRemove = sharesToRemove;
    }

    public InputStream prepareContentsToSet(IFileOptions fileOptions, InputStream in) throws FileSystemException {
        return in;
    }

    protected final void execute(IProgressMonitor monitor) throws TeamRepositoryException {
        ThreadCheck.checkLongOpsAllowed();
        int work = this.sharesToRemove == null ? 0 : 5;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(work += this.loadTree == null ? 0 : 95));
        if (this.sharesToRemove != null) {
            SCMEEUtils.removeShares(this.sharesToRemove, (Shed)this.shed, (ISandbox)this.sandbox, (IProgressMonitor)monitor);
        }
        if (this.loadTree != null) {
            this.load((IProgressMonitor)progress.newChild(95));
        }
    }

    private void load(IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)230);
        ITeamRepository repo = this.connection.teamRepository();
        ICopyFileArea cfa = ICopyFileAreaManager.instance.getCopyFileAreaForPath(this.sandbox.getRoot());
        this.pathsToUpdate = new ArrayList();
        this.allFolderChildren = new HashMap<UUID, HashMap<String, UUID>>();
        this.shares = new ArrayList();
        this.inconsistentShares = new HashSet();
        List updates = this.loadTree.getFileAreaUpdates();
        this.contentSession = FileSystemCore.getContentManager((ITeamRepository)repo).createSession(0, true, "", (long)updates.size(), (IProgressMonitor)progress.newChild(175));
        CancellationMonitor cMon = new CancellationMonitor((IProgressMonitor)progress);
        try {
            for (FileAreaUpdate update : updates) {
                ResourceType type = ResourceType.getResourceType((IVersionableHandle)update.afterState());
                if (type == ResourceType.FILE) {
                    this.handleFileUpdate(cfa, update, cMon);
                    continue;
                }
                if (type == ResourceType.FOLDER) {
                    this.handleFolderUpdate(cfa, update, cMon);
                    continue;
                }
                if (type != ResourceType.SYMBOLIC_LINK) continue;
                this.handleLinkUpdate(cfa, update, cMon);
            }
        }
        finally {
            if (this.loadTracing != null) {
                this.loadTracing.close();
            }
            this.contentSession.join();
            try {
                if (!progress.isCanceled()) {
                    this.doDilemmaHandling(this.pathsToUpdate, (IProgressMonitor)progress.newChild(10));
                }
            }
            finally {
                SCMEEUtils.updateContentLoadedMetaData((ICopyFileArea)cfa, this.pathsToUpdate, (IProgressMonitor)new NonCancellingProgressMonitor((IProgressMonitor)progress.newChild(25)));
            }
        }
        IStatus[] failures = this.getDownloadFailures(this.pathsToUpdate);
        if (failures.length > 0) {
            boolean seriousFailure = false;
            IStatus[] iStatusArray = failures;
            int n = failures.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus failure = iStatusArray[n2];
                if (failure.getSeverity() == 4 || failure.getSeverity() == 8) {
                    seriousFailure = true;
                }
                this.collectStatus(failure);
                ++n2;
            }
            if (seriousFailure) {
                SCMEEUtils.throwAppropriateException((String)Messages.IBMiLoadMutator_2, (IStatus[])this.getErrors());
            }
        } else if (this.contentSession.isCanceled()) {
            throw new OperationCanceledException();
        }
        SCMEEUtils.removeExtraneousMetadata((ICopyFileArea)cfa, this.allFolderChildren, (IContextHandle)this.connection.getContextHandle(), (IComponentHandle)this.component, (Shed)this.shed, (IProgressMonitor)progress.newChild(5));
        SCMEEUtils.updateConfigurationStates((ICopyFileArea)cfa, this.shares, this.inconsistentShares, (IContextHandle)this.connection.getContextHandle(), (IComponentHandle)this.component, (ISynchronizationTime)this.loadTree.getConfigurationState(), (IProgressMonitor)progress);
        this.handleDeletedContent(this.pathsToUpdate, (IProgressMonitor)progress.newChild(5));
        progress.done();
    }

    @Override
    protected int notifyHandlerOfDeletedContent(List<IShareable> contentDeleted) {
        return this.problemHandler.deletedContent(contentDeleted);
    }

    @Override
    protected String getDeletedContentMessage() {
        return Messages.IBMiLoadMutator_0;
    }

    private IFolderHandle getLoadRoot(IFolderHandle parent, IVersionableHandle versionable) {
        IFolderHandle root = null;
        ILoadLocation loadLocation = this.loadLocations.get(versionable.getItemId());
        root = loadLocation != null ? null : parent;
        return root;
    }

    private void updateFile(ICopyFileArea cfa, IShareableInternal shareable, FileAreaUpdate update, IShareableInternal shareableLoaded, IProgressMonitor monitor) throws FileSystemException {
        IVersionableHandle vHandle = update.afterState();
        SharingDescriptor sharingDescriptor = SharingDescriptor.create((IConnection)this.connection, (IComponent)this.component, (IVersionableHandle)vHandle, (IFolderHandle)this.getLoadRoot(update.getDestinationParent(), vHandle), null);
        Date date = shareableLoaded == null ? null : new Date(shareableLoaded.getFileStorage().getModificationStamp());
        DeferredFileLoadInformation deferredFileLoadInformation = new DeferredFileLoadInformation(cfa, shareable, update, (ISharingDescriptor)sharingDescriptor, date);
        this.pathsToUpdate.add(deferredFileLoadInformation);
        this.shares.add(deferredFileLoadInformation.getFileItemState());
        try {
            Map<String, String> additionalProperties = IBMiLoadMutator.fetchSideFileProperties(this.config, update.afterState(), update.getName(), update.getDestinationParent(), monitor);
            String versionableName = update.getName();
            int indexOfPeriod = versionableName.lastIndexOf(46);
            if (indexOfPeriod >= 0 && indexOfPeriod < versionableName.length() - 1) {
                additionalProperties.put("com.ibm.team.enterprise.scmee.ibmi.sourcetype", versionableName.substring(indexOfPeriod + 1));
            }
            this.contentSession.retrieveContent((IFileItemHandle)deferredFileLoadInformation.getFileItemState(), deferredFileLoadInformation.getContent(), (FileDownloadHandler)new DownloadHandler(shareable, deferredFileLoadInformation, this.downloadMonitor, false, this.shed, additionalProperties));
        }
        catch (TeamRepositoryException e) {
            this.collectStatus((IStatus)new Status(4, "com.ibm.team.enterprise.scmee.ibmi", NLS.bind((String)Messages.IBMiLoadMutator_11, (Object)shareable.getFullPath().toString(), (Object[])new Object[]{this.component.getName()}), (Throwable)e));
            this.inconsistentShares.add(deferredFileLoadInformation.getFileAreaUpdate().getItem().getItemId());
        }
    }

    private IStatus[] getDownloadFailures(List<DeferredFileLoadInformation> pathsToUpdate) {
        ArrayList<Object> errors = new ArrayList<Object>();
        boolean reportedSupportedCharSets = false;
        for (DeferredFileLoadInformation deferredUpdateInformation : pathsToUpdate) {
            IStatus status;
            if (deferredUpdateInformation.getFailure() == null) continue;
            Throwable rootCause = deferredUpdateInformation.getFailure().getCause();
            int paranoiaCount = 0;
            while (rootCause instanceof TeamRepositoryException && paranoiaCount < 50) {
                Throwable cause = ((TeamRepositoryException)rootCause).getCause();
                if (cause == null) break;
                rootCause = cause;
                ++paranoiaCount;
            }
            if (rootCause instanceof UnsupportedEncodingException || rootCause instanceof UnsupportedCharsetException) {
                if (!reportedSupportedCharSets) {
                    StringBuffer charSetsAvailable = new StringBuffer();
                    for (String charsetName : Charset.availableCharsets().keySet()) {
                        charSetsAvailable.append(charsetName).append(' ');
                    }
                    Status infoStatus = new Status(1, "com.ibm.team.enterprise.scmee.ibmi", NLS.bind((String)Messages.IBMiLoadMutator_5, (Object)charSetsAvailable.toString(), (Object[])new Object[0]));
                    errors.add(infoStatus);
                    reportedSupportedCharSets = true;
                }
                status = FileSystemStatusUtil.getStatusFor((int)4, (String)NLS.bind((String)Messages.IBMiLoadMutator_6, (Object)deferredUpdateInformation.getShareable().getFullPath().toString(), (Object[])new Object[]{this.component.getName(), deferredUpdateInformation.getContent().getCharacterEncoding()}), (Throwable)deferredUpdateInformation.getFailure());
            } else if (rootCause instanceof CharacterCodingException) {
                status = FileSystemStatusUtil.getStatusFor((int)4, (String)NLS.bind((String)Messages.IBMiLoadMutator_7, (Object)deferredUpdateInformation.getShareable().getFullPath().toString(), (Object[])new Object[]{this.component.getName(), deferredUpdateInformation.getContent().getCharacterEncoding()}), (Throwable)deferredUpdateInformation.getFailure());
            } else {
                if (rootCause instanceof OperationCanceledException) continue;
                status = FileSystemStatusUtil.getStatusFor((int)4, (String)NLS.bind((String)Messages.IBMiLoadMutator_8, (Object)deferredUpdateInformation.getShareable().getFullPath().toString(), (Object[])new Object[]{this.component.getName()}), (Throwable)deferredUpdateInformation.getFailure());
            }
            errors.add(status);
        }
        return errors.toArray(new IStatus[errors.size()]);
    }

    private void handleFileUpdate(ICopyFileArea cfa, FileAreaUpdate update, CancellationMonitor cMon) {
        IVersionableHandle versionableState = update.afterState();
        IFolderHandle parent = update.getDestinationParent();
        String errorName = update.getName();
        try {
            HashMap<String, UUID> contents;
            HashMap<String, UUID> children;
            String projectLoadLibName;
            boolean alreadyExisted;
            IShareableInternal shareableLoaded = (IShareableInternal)this.sandbox.findShareable(this.connection.getContextHandle(), (IComponentHandle)this.component, versionableState, (IProgressMonitor)cMon);
            FolderInfo info = this.getFolderInfo(this.config, parent);
            boolean bl = alreadyExisted = info != null;
            if (!this.isIFile(update, this.config, (IProgressMonitor)cMon)) {
                SCMEEUtils.deleteShareableLoaded((IShareableInternal)shareableLoaded, (IContextHandle)this.connection.getContextHandle(), (IComponentHandle)this.component, (IVersionableHandle)versionableState, (Shed)this.shed, (ISandbox)this.sandbox, (IProgressMonitor)cMon);
                return;
            }
            if (!alreadyExisted) {
                info = this.getFolderInfo(this.config, parent);
                projectLoadLibName = this.getResourceDefinition(this.config, (IVersionableHandle)info.parent).getResourceName();
                IShareableInternal physicalFileShareable = (IShareableInternal)this.sandbox.findShareable((IRelativeLocation)new RelativeLocation(new String[]{projectLoadLibName, info.name}), ResourceType.FOLDER);
                if (!physicalFileShareable.exists((IProgressMonitor)cMon)) {
                    physicalFileShareable.getFileStorage().create(true, (Object)IBMiLoadMutator.getPhysicalFileInfo(this.config, (IVersionableHandle)parent, info.name, info.parent, (IProgressMonitor)cMon), (IProgressMonitor)cMon);
                }
            } else {
                projectLoadLibName = this.getResourceDefinition(this.config, (IVersionableHandle)info.parent).getResourceName();
            }
            RelativeLocation path = new RelativeLocation(new String[]{projectLoadLibName, info.name, IBMiLoadMutator.getFilename(update)});
            errorName = this.sandbox.getRoot().append((IRelativeLocation)path).toOSString();
            IShareableInternal shareableToLoad = (IShareableInternal)this.sandbox.findShareable((IRelativeLocation)path, ResourceType.FILE);
            ResourceType type = shareableToLoad.getResourceType((IProgressMonitor)cMon);
            if (type == null && shareableLoaded == null) {
                SharingManager.getInstance().forget(this.sandbox.getRoot(), this.connection.getContextHandle(), (IComponentHandle)this.component, update.getItem(), (IProgressMonitor)cMon);
                this.updateFile(cfa, shareableToLoad, update, null, (IProgressMonitor)cMon);
            } else if (type == null && shareableLoaded != null) {
                SCMEEUtils.deleteShareableLoaded((IShareableInternal)shareableLoaded, (IContextHandle)this.connection.getContextHandle(), (IComponentHandle)this.component, (IVersionableHandle)versionableState, (Shed)this.shed, (ISandbox)this.sandbox, (IProgressMonitor)cMon);
                this.updateFile(cfa, shareableToLoad, update, null, (IProgressMonitor)cMon);
            } else if (type != null && shareableLoaded == null) {
                if (parent != null && (children = this.allFolderChildren.get(parent.getItemId())) != null && children.containsKey(shareableToLoad.getLocalPath().getName())) {
                    this.collectStatus((IStatus)new Status(4, "com.ibm.team.enterprise.scmee.ibmi", NLS.bind((String)Messages.IBMiLoadMutator_9, (Object)update.getName(), (Object[])new Object[]{this.component.getName(), shareableToLoad.getFullPath().toOSString()})));
                    this.inconsistentShares.add(update.getItem().getItemId());
                    return;
                }
                SCMEEUtils.deleteShareableLoaded((IShareableInternal)shareableToLoad, null, null, null, (Shed)this.shed, (ISandbox)this.sandbox, (IProgressMonitor)cMon);
                this.updateFile(cfa, shareableToLoad, update, null, (IProgressMonitor)cMon);
            } else if (shareableToLoad.getLocalPath().equals((Object)shareableLoaded.getLocalPath())) {
                IShare share;
                boolean isDirty;
                LocalChangeManager localChangeManager = LocalChangeManager.getInstance();
                boolean bl2 = isDirty = !versionableState.sameStateId((IItemHandle)shareableToLoad.getRemote((IProgressMonitor)cMon));
                if (!isDirty) {
                    ILocalChange change = localChangeManager.getPendingChange((IShareable)shareableToLoad, (IProgressMonitor)cMon);
                    isDirty |= change != null && change.getType() != 0;
                }
                if (!isDirty && (share = shareableToLoad.getShare((IProgressMonitor)cMon)) != null) {
                    localChangeManager.refreshChanges(new IShare[]{share}, ILocalChangeManager.RefreshType.TRAVERSE_ALL_KNOWN, (IProgressMonitor)cMon);
                    isDirty |= localChangeManager.isContentDirty((IShareable)shareableToLoad, (IProgressMonitor)cMon);
                }
                if (isDirty) {
                    this.updateFile(cfa, shareableToLoad, update, shareableLoaded, (IProgressMonitor)cMon);
                } else {
                    this.shares.add(versionableState);
                    this.contentSession.decrementTransferCount(1L);
                }
            } else {
                if (parent != null && (children = this.allFolderChildren.get(parent.getItemId())) != null && children.containsKey(shareableToLoad.getLocalPath().getName())) {
                    this.collectStatus((IStatus)new Status(4, "com.ibm.team.enterprise.scmee.ibmi", NLS.bind((String)Messages.IBMiLoadMutator_10, (Object)update.getName(), (Object[])new Object[]{this.component.getName(), shareableLoaded.getFullPath().toOSString()})));
                    this.inconsistentShares.add(update.getItem().getItemId());
                    return;
                }
                SCMEEUtils.deleteShareableLoaded((IShareableInternal)shareableToLoad, null, null, null, (Shed)this.shed, (ISandbox)this.sandbox, (IProgressMonitor)cMon);
                this.updateFile(cfa, shareableToLoad, update, null, (IProgressMonitor)cMon);
            }
            if (!this.loadLocations.containsKey(versionableState.getItemId()) && (contents = this.allFolderChildren.get(update.parent().getItemId())) != null) {
                contents.put(path.getName(), update.getItem().getItemId());
            }
        }
        catch (TeamRepositoryException e) {
            this.collectStatus((IStatus)new Status(4, "com.ibm.team.enterprise.scmee.ibmi", NLS.bind((String)Messages.IBMiLoadMutator_3, (Object)update.getName(), (Object[])new Object[]{this.component.getName(), errorName}), (Throwable)e));
            this.inconsistentShares.add(update.getItem().getItemId());
        }
    }

    private void handleFolderUpdate(ICopyFileArea cfa, FileAreaUpdate update, CancellationMonitor cMon) throws TeamRepositoryException {
        IFolderHandle folderHandle = (IFolderHandle)update.afterState();
        if (this.checkAndRegisterIProject(folderHandle, this.config, update.getMetadataProperties(), update.getName(), (IProgressMonitor)cMon)) {
            return;
        }
        if (this.getFolderInfo(this.config, folderHandle) != null) {
            return;
        }
        if (!this.isIFolder(update, this.config, (IProgressMonitor)cMon)) {
            return;
        }
        IFolderHandle versionableState = (IFolderHandle)update.getItem();
        this.allFolderChildren.put(versionableState.getItemId(), new HashMap());
        IIBMiResourceDefinition resourceDefn = this.getResourceDefinition(this.config, (IVersionableHandle)update.getDestinationParent());
        RelativeLocation path = new RelativeLocation(new String[]{resourceDefn.getResourceName(), update.getName()});
        try {
            IShareableInternal shareable = (IShareableInternal)this.sandbox.findShareable((IRelativeLocation)path, ResourceType.FOLDER);
            if (!shareable.exists((IProgressMonitor)cMon)) {
                shareable.getFileStorage().create(true, (Object)IBMiLoadMutator.getPhysicalFileInfo(this.config, update.afterState(), update.getName(), update.getDestinationParent(), (IProgressMonitor)cMon), (IProgressMonitor)cMon);
            }
        }
        catch (FileSystemException e) {
            this.collectStatus((IStatus)new Status(4, "com.ibm.team.enterprise.scmee.ibmi", NLS.bind((String)Messages.UpdateMutator_ErrorCreatingPhysicalFile, (Object)this.sandbox.getRoot().append((IRelativeLocation)path).toOSString(), (Object[])new Object[]{update.getName(), this.component.getName()}), (Throwable)e));
        }
    }

    private void handleLinkUpdate(ICopyFileArea cfa, FileAreaUpdate update, CancellationMonitor cMon) throws TeamRepositoryException {
        if (this.isIFolder(update, this.config, (IProgressMonitor)cMon)) {
            this.collectStatus((IStatus)new Status(4, "com.ibm.team.enterprise.scmee.ibmi", NLS.bind((String)Messages.IBMiLoadMutator_4, (Object)update.getName(), (Object[])new Object[0])));
            this.inconsistentShares.add(update.getItem().getItemId());
        }
    }

    private void doDilemmaHandling(ArrayList<DeferredFileLoadInformation> pathsToUpdate, IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        progress.setWorkRemaining(100);
        ArrayList<DeferredFileLoadInformation> encodingFailures = new ArrayList<DeferredFileLoadInformation>();
        for (DeferredFileLoadInformation deferredUpdateInformation : pathsToUpdate) {
            if (deferredUpdateInformation == null || deferredUpdateInformation.getFailure() == null) continue;
            Throwable rootCause = deferredUpdateInformation.getFailure().getCause();
            int digParanoiaCount = 0;
            while (rootCause instanceof TeamRepositoryException && digParanoiaCount < 50) {
                Throwable cause = ((TeamRepositoryException)rootCause).getCause();
                if (cause == null) break;
                rootCause = cause;
                ++digParanoiaCount;
            }
            if (rootCause instanceof UnsupportedEncodingException || rootCause instanceof UnsupportedCharsetException) {
                deferredUpdateInformation.setAlternateEncoding("ISO-8859-1");
                encodingFailures.add(deferredUpdateInformation);
                continue;
            }
            if (!(rootCause instanceof OperationCanceledException)) continue;
            throw new OperationCanceledException();
        }
        if (encodingFailures.size() > 0) {
            boolean moreContentUploaded = false;
            this.contentSession = FileSystemCore.getContentManager((ITeamRepository)this.connection.teamRepository()).createSession(0, true, "", (long)encodingFailures.size(), (IProgressMonitor)progress.newChild(75));
            try {
                for (DeferredFileLoadInformation failure : encodingFailures) {
                    IVersionableHandle fileItemState = failure.getFileItemState();
                    this.contentSession.retrieveContent((IFileItemHandle)fileItemState, failure.getContent(), failure.getEncoding(), failure.getLineDelimiter(), (FileDownloadHandler)new DownloadHandler(failure.getShareable(), failure, this.downloadMonitor, false, this.shed));
                    moreContentUploaded = true;
                }
            }
            finally {
                if (moreContentUploaded) {
                    this.contentSession.join();
                }
            }
        }
    }
}

