/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.scmee.ibmi.internal;

import com.ibm.as400.access.AS400SecurityException;
import com.ibm.team.enterprise.common.common.utils.LoadTracing;
import com.ibm.team.enterprise.scmee.common.SCMEEFileStorage;
import com.ibm.team.enterprise.scmee.common.SCMEEStorageManager;
import com.ibm.team.enterprise.scmee.ibmi.IBMiLibraryLocation;
import com.ibm.team.enterprise.scmee.ibmi.internal.IBMiFileInterface;
import com.ibm.team.enterprise.scmee.ibmi.internal.IBMiSCMConstants;
import com.ibm.team.enterprise.scmee.ibmi.internal.IBMiUtilities;
import com.ibm.team.enterprise.scmee.ibmi.internal.IPhysicalFileInfo;
import com.ibm.team.enterprise.scmee.ibmi.internal.messages.Messages;
import com.ibm.team.enterprise.scmee.ibmi.internal.test.SimulatedIBMiFileInterface;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileStorage;
import com.ibm.team.filesystem.client.internal.FileStorageWrapper;
import com.ibm.team.filesystem.client.internal.IFileOptions;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.exceptions.ContentRetrievalFailure;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.repository.common.util.NLS;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

public class IBMiFileStorage
extends SCMEEFileStorage {
    protected final IBMiFileInterface file;

    public IBMiFileStorage(IFileStorage storage, LoadTracing lt) {
        super(storage);
        IBMiLibraryLocation location = (IBMiLibraryLocation)storage.getShareable().getFullPath().getAdapter(IBMiLibraryLocation.class);
        if (location == null) {
            throw new IllegalArgumentException();
        }
        this.file = SCMEEStorageManager.SIMULATION_ENABLED ? new SimulatedIBMiFileInterface(location, lt) : new IBMiFileInterface(location, lt);
    }

    public void create(boolean createParents, Object additionalInfo, IProgressMonitor monitor) throws FileSystemException {
        if (!(additionalInfo instanceof IPhysicalFileInfo)) {
            throw new IllegalArgumentException();
        }
        IPhysicalFileInfo info = (IPhysicalFileInfo)additionalInfo;
        if (!this.file.libExists()) {
            this.file.createContainingLibrary();
        }
        String ccsID = info.getCCSID();
        String recLen = info.getRecordLength();
        String textDescription = info.getTextDescription();
        String igcDataPropValue = info.getIGCData();
        if (ccsID == null || ccsID.length() == 0) {
            ccsID = "*JOB";
        }
        if (recLen == null || recLen.length() == 0) {
            recLen = "112";
        }
        if (textDescription == null || textDescription.length() == 0) {
            textDescription = "";
        }
        String igcData = Boolean.valueOf(igcDataPropValue) != false ? "*YES" : "*NO";
        this.file.createPhysicalFile(ccsID, recLen, igcData, textDescription);
    }

    public void create(IFileOptions fileOptions, InputStream in, IProgressMonitor monitor) throws FileSystemException {
        Map props = fileOptions.getProperties();
        String textDescription = IBMiUtilities.massageTextDescription((String)props.get(IBMiSCMConstants.KEY_TEXT_DESCRIPTION.toString()));
        String sourceType = (String)props.get("com.ibm.team.enterprise.scmee.ibmi.sourcetype");
        if (sourceType == null || sourceType.length() == 0) {
            sourceType = "*NONE";
        }
        if (this.file.exists()) {
            this.file.clearMember(textDescription, sourceType);
        } else {
            this.file.createMember(textDescription, sourceType);
        }
        this.updateMemberContents(in, fileOptions.getCharacterEncoding(), fileOptions.getLineDelimiter().equals((Object)FileLineDelimiter.LINE_DELIMITER_NONE));
    }

    public void delete(IProgressMonitor monitor) throws FileSystemException {
        if (this.file.isMember() && this.file.exists()) {
            this.file.delete();
        }
    }

    public String getActualName() {
        return this.file.getName();
    }

    public Object getAdapter(Class clazz) {
        if (clazz.isAssignableFrom(IBMiFileInterface.class)) {
            return this.file;
        }
        return null;
    }

    public long getModificationStamp() throws FileSystemException {
        long timestamp = this.file.getModificationStamp();
        return timestamp == 0L ? -1L : timestamp;
    }

    public void move(FileStorage storage, IProgressMonitor monitor) throws FileSystemException {
        this.file.rename(((IBMiFileStorage)storage).file);
    }

    public void resolveChildStorage(FileStorageWrapper childStorage, String name, ResourceType type) {
        childStorage.setUnderlyingStorage((FileStorage)new IBMiFileStorage((IFileStorage)childStorage, this.file.loadTracing));
    }

    public boolean storageExists(IProgressMonitor monitor) throws FileSystemException {
        return this.file.exists();
    }

    public boolean isFile(IProgressMonitor progress) throws FileSystemException {
        return this.file.isMember();
    }

    public boolean isFolder(IProgressMonitor progress) throws FileSystemException {
        return this.file.isPhysicalFile();
    }

    protected InputStream transmitBinaryContents() throws ContentRetrievalFailure {
        return null;
    }

    protected InputStream getBinaryContents() throws ContentRetrievalFailure {
        try {
            return this.file.getBinaryContents();
        }
        catch (AS400SecurityException ex) {
            throw new ContentRetrievalFailure(NLS.bind((String)Messages.IBMiFileStorage_0, (Object)this.getLocalPath().toString(), (Object[])new Object[]{ex.getMessage()}), this.getLocalPath(), (Throwable)ex);
        }
        catch (IOException ex) {
            throw new ContentRetrievalFailure(NLS.bind((String)Messages.IBMiFileStorage_1, (Object)this.getLocalPath().toString(), (Object[])new Object[]{ex.getMessage()}), this.getLocalPath(), (Throwable)ex);
        }
    }

    protected InputStream getEncodedContents(String localEncoding, String serverEncoding) throws UnsupportedEncodingException, ContentRetrievalFailure {
        try {
            return this.file.getEncodedContents(localEncoding, serverEncoding);
        }
        catch (AS400SecurityException ex) {
            throw new ContentRetrievalFailure(NLS.bind((String)Messages.IBMiFileStorage_2, (Object)this.getLocalPath().toString(), (Object[])new Object[]{ex.getMessage()}), this.getLocalPath(), (Throwable)ex);
        }
        catch (IOException ex) {
            throw new ContentRetrievalFailure(NLS.bind((String)Messages.IBMiFileStorage_3, (Object)this.getLocalPath().toString(), (Object[])new Object[]{ex.getMessage()}), this.getLocalPath(), (Throwable)ex);
        }
    }

    protected String retrieveLocalEncoding(IFileOptions options) {
        return "" + this.file.getCCSID();
    }

    protected boolean updateSpecialContents(InputStream in) throws FileSystemException {
        return false;
    }

    protected boolean updateMemberContents(InputStream inputStream, String serverEncoding, boolean isBinary) throws FileSystemException {
        return this.file.updateMemberContents(inputStream, serverEncoding, isBinary);
    }

    public final void setLocalTimeStamp(long timeStamp, IProgressMonitor progress) throws FileSystemException {
    }

    protected boolean updateContents(InputStream in, IFileOptions fileOptions, String localCodePage) throws FileSystemException {
        if (this.file.exists()) {
            Map props = fileOptions.getProperties();
            String textDescription = IBMiUtilities.massageTextDescription((String)props.get(IBMiSCMConstants.KEY_TEXT_DESCRIPTION.toString()));
            String sourceType = (String)props.get("com.ibm.team.enterprise.scmee.ibmi.sourcetype");
            if (sourceType == null || sourceType.length() == 0) {
                sourceType = "*NONE";
            }
            this.file.clearMember(textDescription, sourceType);
        }
        return this.updateMemberContents(in, fileOptions.getCharacterEncoding(), fileOptions.getLineDelimiter().equals((Object)FileLineDelimiter.LINE_DELIMITER_NONE));
    }

    public ResourceType getResourceType(IProgressMonitor progress) throws FileSystemException {
        if (this.file.exists()) {
            if (this.file.isMember()) {
                return ResourceType.FILE;
            }
            return ResourceType.FOLDER;
        }
        return null;
    }

    public final long getSize(IProgressMonitor progress) throws FileSystemException {
        return -1L;
    }

    protected boolean isSpecialBinaryContent(IFileOptions fileOptions) throws FileSystemException {
        return Boolean.valueOf((String)fileOptions.getProperties().get("isBinary"));
    }
}

