/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.scmee.ibmi.internal;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.IFSFileInputStream;
import com.ibm.as400.access.User;
import com.ibm.etools.iseries.comm.ISeriesListObjects;
import com.ibm.etools.iseries.comm.ISeriesRetrieveDatabaseFileDescription;
import com.ibm.etools.iseries.comm.filters.ISeriesAbstractFilterString;
import com.ibm.etools.iseries.comm.filters.ISeriesLibraryFilterString;
import com.ibm.etools.iseries.comm.filters.ISeriesObjectFilterString;
import com.ibm.etools.iseries.comm.interfaces.ISeriesHostObjectBasic;
import com.ibm.etools.iseries.util.AS400Factory;
import com.ibm.team.enterprise.common.common.utils.LoadTracing;
import com.ibm.team.enterprise.common.common.utils.StringNormalizer;
import com.ibm.team.enterprise.scmee.ibmi.IBMiLibraryLocation;
import com.ibm.team.enterprise.scmee.ibmi.IBMiStorageManager;
import com.ibm.team.enterprise.scmee.ibmi.internal.IAS400Record;
import com.ibm.team.enterprise.scmee.ibmi.internal.IBMiMemberInputStream;
import com.ibm.team.enterprise.scmee.ibmi.internal.IBMiUtilities;
import com.ibm.team.enterprise.scmee.ibmi.internal.ISequentialFile;
import com.ibm.team.enterprise.scmee.ibmi.internal.SequentialFileWrapper;
import com.ibm.team.enterprise.scmee.ibmi.internal.messages.Messages;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.repository.common.util.NLS;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IBMiFileInterface {
    private static final Log LOG = LogFactory.getLog(IBMiFileInterface.class);
    private static boolean TRACING_ENABLED = false;
    private static final AS400 as400;
    private static String qsys;
    private static String iasp;
    private static final ISeriesListObjects listObjectPGM;
    private static final ISeriesRetrieveDatabaseFileDescription getFileDescriptionPGM;
    protected final IBMiLibraryLocation fullPath;
    public LoadTracing loadTracing;

    static {
        qsys = "/QSYS.LIB/";
        iasp = null;
        if (IBMiStorageManager.REMOTE_IBMI_TESTING_ENABLED) {
            as400 = new AS400(System.getProperty("rtci.remote.test.mode.system"), System.getProperty("rtci.remote.test.mode.user"), System.getProperty("rtci.remote.test.mode.password"));
        } else if (IBMiStorageManager.SIMULATION_ENABLED) {
            as400 = null;
        } else {
            as400 = AS400Factory.getInstance().getAS400();
            boolean useUserIASP = Boolean.valueOf(System.getProperty("team.enterprise.ibmi.toolkit.setASP"));
            String useIASPValue = System.getProperty("team.enterprise.ibmi.toolkit.ASPName");
            if (as400 != null && useUserIASP && useIASPValue != null && useIASPValue.trim().isEmpty()) {
                String[] userIASPs = null;
                try {
                    userIASPs = new User(as400, as400.getUserId()).getIASPNames();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (userIASPs != null && userIASPs.length > 0) {
                    iasp = userIASPs[0];
                }
            } else if (useIASPValue != null && !useIASPValue.trim().isEmpty()) {
                iasp = useIASPValue;
            }
            if (iasp != null && !iasp.isEmpty()) {
                qsys = "/" + iasp + "/QSYS.LIB/";
                String command = "SETASPGRP ASPGRP(" + iasp + ")";
                CommandCall cmd = new CommandCall(as400, command);
                try {
                    cmd.run();
                }
                catch (AS400SecurityException | ErrorCompletingRequestException | IOException | InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        if (as400 != null) {
            listObjectPGM = new ISeriesListObjects(as400);
            getFileDescriptionPGM = new ISeriesRetrieveDatabaseFileDescription(as400);
        } else {
            listObjectPGM = null;
            getFileDescriptionPGM = null;
        }
        if (System.getProperty("team.enterprise.scm.log.loading") != null) {
            TRACING_ENABLED = System.getProperty("team.enterprise.scm.log.loading").equals("true");
        }
    }

    public IBMiFileInterface(IBMiLibraryLocation fullPath, LoadTracing lt) {
        this.fullPath = fullPath;
        this.loadTracing = lt;
    }

    public boolean isMember() {
        String memberName = this.fullPath.getMember();
        return memberName != null && memberName.length() > 0;
    }

    public boolean isPhysicalFile() {
        if (!this.isMember()) {
            String filename = this.fullPath.getFilename();
            return filename != null && filename.length() > 0;
        }
        return false;
    }

    protected final String getActualLibraryName() {
        return String.valueOf(this.fullPath.getPrefix()) + this.fullPath.getLibname();
    }

    protected boolean libExists() throws FileSystemException {
        List list;
        ISeriesListObjects pgm = new ISeriesListObjects(as400);
        try {
            list = pgm.getList((ISeriesAbstractFilterString)new ISeriesLibraryFilterString(this.getActualLibraryName()));
        }
        catch (Exception ex) {
            throw new FileSystemException((Throwable)ex);
        }
        return list != null && list.size() > 0 && list.get(0) != null;
    }

    protected boolean runCommand(String cmdStr) throws FileSystemException {
        boolean success;
        CommandCall cmd = new CommandCall(as400, cmdStr);
        DecimalFormat df = new DecimalFormat("00");
        try {
            success = cmd.run();
            if (TRACING_ENABLED && this.loadTracing != null) {
                if (success) {
                    this.loadTracing.printToLog(NLS.bind((String)Messages.IBMiFileInterface_logging_command, (Object)cmdStr, (Object[])new Object[0]));
                } else {
                    this.loadTracing.printToLog(NLS.bind((String)Messages.IBMiFileInterface_logging_command_failed, (Object)cmdStr, (Object[])new Object[0]));
                }
            }
            if (TRACING_ENABLED && this.loadTracing != null) {
                AS400Message[] messages = cmd.getMessageList();
                int numMessages = messages == null ? 0 : messages.length;
                int i = 0;
                while (i < numMessages) {
                    String id = messages[i].getID();
                    String sev = df.format(messages[i].getSeverity());
                    this.loadTracing.printToLog(NLS.bind((String)Messages.IBMiFileInterface_logging_response, (Object[])new Object[]{id == null ? "" : id, sev, messages[i].getText()}, (Object[])new Object[0]));
                    ++i;
                }
            }
        }
        catch (InterruptedException ex) {
            throw new FileSystemException((Throwable)ex);
        }
        catch (IOException ex) {
            throw new FileSystemException((Throwable)ex);
        }
        catch (AS400SecurityException ex) {
            throw new FileSystemException((Throwable)ex);
        }
        catch (ErrorCompletingRequestException ex) {
            throw new FileSystemException((Throwable)ex);
        }
        if (!success) {
            StringBuffer sBuf = new StringBuffer();
            AS400Message[] messages = cmd.getMessageList();
            int numMessages = messages == null ? 0 : messages.length;
            int i = 0;
            while (i < numMessages) {
                sBuf.append(messages[i]);
                ++i;
            }
            throw new FileSystemException(sBuf.toString());
        }
        return success;
    }

    protected void createContainingLibrary() throws FileSystemException {
        String aspArguments = "";
        if (iasp != null && !iasp.isEmpty()) {
            aspArguments = " ASP(*ASPDEV) ASPDEV(" + iasp + ")";
        }
        this.runCommand("CRTLIB " + this.getActualLibraryName() + aspArguments);
    }

    public void createPhysicalFile(String ccsID, String recLen, String igcData, String textDescription) throws FileSystemException {
        this.runCommand("CRTSRCPF FILE(" + this.getActualLibraryName() + "/" + this.fullPath.getFilename() + ") " + "CCSID(" + ccsID + ") " + "RCDLEN(" + recLen + ") " + "IGCDTA(" + igcData + ") " + "TEXT('" + textDescription + "')");
    }

    public void clearMember(String textDescription, String sourceType) throws FileSystemException {
        if (!this.isMember()) {
            throw new IllegalStateException();
        }
        this.runCommand("CHGPFM FILE(" + this.getActualLibraryName() + "/" + this.fullPath.getFilename() + ") MBR(" + this.fullPath.getMember() + ") " + "TEXT('" + textDescription + "') SRCTYPE(" + sourceType + ")");
        this.runCommand("CLRPFM FILE(" + this.getActualLibraryName() + "/" + this.fullPath.getFilename() + ") MBR(" + this.fullPath.getMember() + ")");
    }

    public void createMember(String textDescription, String sourceType) throws FileSystemException {
        if (!this.isMember()) {
            throw new IllegalStateException();
        }
        this.runCommand("ADDPFM FILE(" + this.getActualLibraryName() + "/" + this.fullPath.getFilename() + ") MBR(" + this.fullPath.getMember() + ") " + "TEXT('" + textDescription + "') SRCTYPE(" + sourceType + ")");
    }

    private ISeriesHostObjectBasic getHostObject() throws FileSystemException {
        List list;
        try {
            list = listObjectPGM.getList((ISeriesAbstractFilterString)new ISeriesObjectFilterString(String.valueOf(this.getActualLibraryName()) + "/" + this.fullPath.getFilename() + " OBJTYPE(*FILE:PF-SRC)"));
        }
        catch (Exception ex) {
            throw new FileSystemException((Throwable)ex);
        }
        if (list != null && list.size() > 0) {
            return (ISeriesHostObjectBasic)list.get(0);
        }
        return null;
    }

    public boolean exists() throws FileSystemException {
        if (this.isMember()) {
            try {
                return new IFSFile(as400, this.getIFSPath()).exists();
            }
            catch (IOException ex) {
                throw new FileSystemException((Throwable)ex);
            }
        }
        if (this.isPhysicalFile()) {
            return this.libExists() && this.getHostObject() != null;
        }
        return false;
    }

    public long getModificationStamp() throws FileSystemException {
        if (this.isMember()) {
            try {
                return new IFSFile(as400, this.getIFSPath()).lastModified();
            }
            catch (IOException ex) {
                throw new FileSystemException((Throwable)ex);
            }
        }
        if (this.isPhysicalFile()) {
            return this.getHostObject().getDateModified().getTime();
        }
        return 0L;
    }

    public void rename(IBMiFileInterface renameTo) {
    }

    public String getName() {
        return this.fullPath.getName();
    }

    private String getIFSPath() {
        String memberName = StringNormalizer.getBestGuessNormalizedString((String)this.fullPath.getMember());
        return String.valueOf(qsys) + this.getActualLibraryName() + ".LIB/" + this.fullPath.getFilename() + ".FILE/" + memberName + ".MBR";
    }

    public InputStream getEncodedContents(String localEncoding, String serverEncoding) throws AS400SecurityException, IOException, UnsupportedEncodingException {
        return new IBMiMemberInputStream(as400, this.getActualLibraryName(), this.fullPath.getFilename(), this.fullPath.getMember(), Integer.parseInt(localEncoding), serverEncoding);
    }

    public InputStream getBinaryContents() throws IOException, AS400SecurityException {
        return new IFSFileInputStream(as400, this.getIFSPath());
    }

    public int getCCSID() {
        try {
            return getFileDescriptionPGM.retrieveFileCCSID(this.getActualLibraryName(), this.fullPath.getFilename());
        }
        catch (Exception ex) {
            LOG.error((Object)"", (Throwable)ex);
            return as400.getCcsid();
        }
    }

    protected ISequentialFile createSequentialFile() {
        return new SequentialFileWrapper(as400, this.getIFSPath());
    }

    protected byte[] stringToByteArray(int ccsID, String str) throws UnsupportedEncodingException {
        return IBMiUtilities.convClientStringToHostBytes(ccsID, as400, str);
    }

    public boolean updateMemberContents(InputStream in, String serverEncoding, boolean isBinary) throws FileSystemException {
        ISequentialFile file = this.createSequentialFile();
        boolean success = false;
        try {
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(in, serverEncoding));
                int ccsID = this.getCCSID();
                byte[] spaceBytes = this.stringToByteArray(ccsID, " ");
                file.setRecordFormat();
                file.open(2, 4740, 3);
                String line = reader.readLine();
                ArrayList<IAS400Record> recsToWrite = new ArrayList<IAS400Record>();
                while (line != null) {
                    int recordLength;
                    IAS400Record newRec = file.getNewRecord();
                    byte[] contentBytes = this.stringToByteArray(ccsID, line);
                    if (contentBytes.length > (recordLength = newRec.getRecordLength())) {
                        throw new FileSystemException(NLS.bind((String)Messages.IBMiFileInterface_TruncationOccurred, (Object)this.fullPath.toOSString(), (Object[])new Object[]{recordLength}));
                    }
                    byte[] bytesToWrite = new byte[recordLength];
                    int i = 0;
                    while (i < contentBytes.length) {
                        bytesToWrite[i] = contentBytes[i];
                        ++i;
                    }
                    i = contentBytes.length;
                    while (i < bytesToWrite.length) {
                        int j = 0;
                        while (j < spaceBytes.length) {
                            bytesToWrite[i + j] = spaceBytes[j];
                            ++j;
                        }
                        i += spaceBytes.length;
                    }
                    newRec.setContents(bytesToWrite);
                    recsToWrite.add(newRec);
                    line = reader.readLine();
                }
                file.write(recsToWrite.toArray(new IAS400Record[recsToWrite.size()]));
                if (TRACING_ENABLED && this.loadTracing != null) {
                    this.loadTracing.printToLog(NLS.bind((String)Messages.IBMiFileInterface_logging_1, (Object)this.fullPath.getMember(), (Object[])new Object[]{this.fullPath.getFilename(), this.getActualLibraryName()}));
                }
                success = true;
            }
            catch (FileSystemException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new FileSystemException((Throwable)ex);
            }
        }
        finally {
            block18: {
                if (file.isOpen()) {
                    try {
                        file.close();
                    }
                    catch (Exception ex) {
                        if (!success) break block18;
                        throw new FileSystemException((Throwable)ex);
                    }
                }
            }
        }
        return success;
    }

    public void delete() throws FileSystemException {
        this.runCommand("RMVM FILE(" + this.getActualLibraryName() + "/" + this.fullPath.getFilename() + ") MBR(" + this.fullPath.getMember() + ")");
    }
}

