/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.scmee.ibmi;

import com.ibm.team.enterprise.scmee.common.SCMEEStorageManager;
import com.ibm.team.enterprise.scmee.ibmi.IBMiLibraryLocation;
import com.ibm.team.enterprise.scmee.ibmi.internal.IBMiFileStorage;
import com.ibm.team.enterprise.scmee.ibmi.internal.IBMiLoadMutator;
import com.ibm.team.enterprise.scmee.ibmi.internal.IBMiUpdateMutator;
import com.ibm.team.enterprise.scmee.ibmi.internal.messages.Messages;
import com.ibm.team.enterprise.scmee.ibmi.internal.test.IBMiTestStorage;
import com.ibm.team.enterprise.scmee.ibmi.internal.test.TestIBMiLoadMutator;
import com.ibm.team.enterprise.scmee.ibmi.internal.test.TestIBMiUpdateMutator;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileStorage;
import com.ibm.team.filesystem.client.internal.FileStorageWrapper;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.operations.ILoadMutator;
import com.ibm.team.filesystem.client.internal.operations.IUpdateMutator;
import com.ibm.team.filesystem.client.operations.IDownloadListener;
import com.ibm.team.filesystem.client.operations.LoadDilemmaHandler;
import com.ibm.team.filesystem.client.operations.UpdateDilemmaHandler;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdateReport2;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.common.dto.IComponentStateSummary;
import com.ibm.team.scm.common.dto.IItemUpdateReport;
import java.util.Collection;
import org.eclipse.osgi.util.NLS;

public class IBMiStorageManager
extends SCMEEStorageManager {
    public static final boolean IBMI_TESTING_ENABLED = System.getProperty("rtci.test.mode") != null;
    public static final boolean REMOTE_IBMI_TESTING_ENABLED = System.getProperty("rtci.remote.test.mode") != null;

    public ILocation createLocation(String locationStr) {
        return new IBMiLibraryLocation(locationStr, null, null, null);
    }

    public ILoadMutator getLoadMutator(ISandbox sandbox, LoadDilemmaHandler loadProblemHandler) {
        if (sandbox.getRoot().getStorageId().equals("com.ibm.team.enterprise.scmee.ibmi")) {
            if (SIMULATION_ENABLED || IBMI_TESTING_ENABLED || REMOTE_IBMI_TESTING_ENABLED) {
                return new TestIBMiLoadMutator(sandbox, loadProblemHandler, loadTracing);
            }
            return new IBMiLoadMutator(sandbox, loadProblemHandler, loadTracing);
        }
        throw new IllegalStateException(NLS.bind((String)Messages.UNSUPPORTED_STORAGE_TYPE, (Object)sandbox.getRoot().getStorageId()));
    }

    public IUpdateMutator getUpdateMutator(IConnection connection, Collection<IComponentStateSummary> componentStatesBefore, Collection<IComponentStateSummary> componentStatesAfter, FileAreaUpdateReport2 updates, Collection<IItemUpdateReport> rawUpdates, Collection<ICopyFileArea> copyFileAreasToUpdate, UpdateDilemmaHandler dilemmaHandler, IDownloadListener downloadMonitor) {
        if (SIMULATION_ENABLED || IBMI_TESTING_ENABLED || REMOTE_IBMI_TESTING_ENABLED) {
            return new TestIBMiUpdateMutator(connection, componentStatesBefore, componentStatesAfter, updates, rawUpdates, copyFileAreasToUpdate, dilemmaHandler, downloadMonitor);
        }
        return new IBMiUpdateMutator(connection, componentStatesBefore, componentStatesAfter, updates, rawUpdates, copyFileAreasToUpdate, dilemmaHandler, downloadMonitor);
    }

    public void resolveFileStorage(FileStorageWrapper storage, ResourceType resourceTypeHint) {
        String storageID = storage.getShareable().getFullPath().getStorageId();
        if (!"com.ibm.team.enterprise.scmee.ibmi".equals(storageID)) {
            throw new IllegalStateException(NLS.bind((String)Messages.UNSUPPORTED_STORAGE_TYPE, (Object)storageID));
        }
        IBMiFileStorage newStorage = IBMI_TESTING_ENABLED || REMOTE_IBMI_TESTING_ENABLED ? new IBMiTestStorage((IFileStorage)storage, loadTracing) : new IBMiFileStorage((IFileStorage)storage, loadTracing);
        storage.setUnderlyingStorage((FileStorage)newStorage);
    }
}

