/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.scmee.ibmi;

import com.ibm.as400.access.AS400;
import com.ibm.etools.iseries.util.AS400Factory;
import com.ibm.team.enterprise.scmee.ibmi.IBMiStorageManager;
import com.ibm.team.enterprise.scmee.ibmi.internal.IBMiProjectResourceNameUtil;
import com.ibm.team.enterprise.scmee.ibmi.internal.messages.Messages;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.internal.RelativeLocation;
import com.ibm.team.repository.common.util.NLS;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;

public class IBMiLibraryLocation
implements ILocation {
    private static final boolean DEBUG = false;
    public static final String STORAGE_ID = "com.ibm.team.enterprise.scmee.ibmi";
    public static final String EMPTY_STRING = "";
    private static final AS400 as400 = IBMiStorageManager.REMOTE_IBMI_TESTING_ENABLED ? new AS400(System.getProperty("rtci.remote.test.mode.system"), System.getProperty("rtci.remote.test.mode.user"), System.getProperty("rtci.remote.test.mode.password")) : (IBMiStorageManager.SIMULATION_ENABLED ? null : AS400Factory.getInstance().getAS400());
    private final String prefix;
    private final String libname;
    private final String filename;
    private final String memberName;

    public IBMiLibraryLocation(String prefix, String libname, String filename, String memberName) {
        this.libname = libname;
        this.filename = IBMiLibraryLocation.unescapeAndSubstituteYenSignIfNeeded(filename);
        this.memberName = IBMiLibraryLocation.unescapeAndSubstituteYenSignIfNeeded(memberName);
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getLibname() {
        return this.libname;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getMember() {
        return this.memberName;
    }

    public IBMiLibraryLocation(ILocation location, IRelativeLocation relativeLocation) {
        if (location == null) {
            throw new IllegalArgumentException(Messages.IBMiLibraryLocation_0);
        }
        if (!location.getStorageId().equals(STORAGE_ID)) {
            throw new IllegalStateException(NLS.bind((String)Messages.IBMiLibraryLocation_1, (Object)location.getStorageId(), (Object[])new Object[0]));
        }
        if (location.isEmpty()) {
            throw new IllegalStateException(Messages.IBMiLibraryLocation_2);
        }
        IBMiLibraryLocation libLocation = (IBMiLibraryLocation)location.getAdapter(IBMiLibraryLocation.class);
        if (libLocation == null) {
            throw new IllegalStateException(NLS.bind((String)Messages.IBMiLibraryLocation_3, (Object)location.getClass().toString(), (Object[])new Object[0]));
        }
        this.prefix = libLocation.prefix;
        String libname = libLocation.libname;
        String file = libLocation.filename;
        String member = libLocation.memberName;
        if (relativeLocation != null && !relativeLocation.isEmpty()) {
            int i = 0;
            if (libname == null) {
                libname = relativeLocation.segments()[i];
                ++i;
            }
            if (file == null && i < relativeLocation.segmentCount()) {
                file = IBMiLibraryLocation.unescapeAndSubstituteYenSignIfNeeded(relativeLocation.segments()[i]);
                ++i;
            }
            if (member == null && i < relativeLocation.segmentCount()) {
                member = IBMiLibraryLocation.unescapeAndSubstituteYenSignIfNeeded(relativeLocation.segments()[i]);
                ++i;
            }
            if (i != relativeLocation.segmentCount()) {
                throw new IllegalStateException(NLS.bind((String)Messages.IBMiLibraryLocation_4, (Object)relativeLocation.toString(), (Object[])new Object[]{location.toString()}));
            }
        }
        this.libname = libname;
        this.filename = file;
        this.memberName = member;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(IBMiLibraryLocation.class)) {
            return this;
        }
        return null;
    }

    public ILocation append(String name) {
        if (this.prefix == null) {
            return new IBMiLibraryLocation(name, null, null, null);
        }
        if (this.libname == null) {
            return new IBMiLibraryLocation(this.prefix, name, null, null);
        }
        if (this.filename == null) {
            return new IBMiLibraryLocation(this.prefix, this.libname, name, null);
        }
        if (this.memberName == null) {
            return new IBMiLibraryLocation(this.prefix, this.libname, this.filename, name);
        }
        throw new IllegalStateException(NLS.bind((String)Messages.IBMiLibraryLocation_5, (Object)name, (Object[])new Object[]{this.toString()}));
    }

    public ILocation append(IRelativeLocation relLoc) {
        return new IBMiLibraryLocation(this, relLoc);
    }

    public ILocation getCanonicalForm() {
        return new IBMiLibraryLocation(this.prefix == null ? null : this.prefix.toUpperCase(), this.libname == null ? null : this.libname.toUpperCase(), this.filename == null ? null : this.filename.toUpperCase(), this.memberName == null ? null : this.memberName.toUpperCase());
    }

    public ILocation getCanonicalForm(boolean isCaseSensitive, boolean convertCase) {
        if (isCaseSensitive || !convertCase) {
            return this;
        }
        return new IBMiLibraryLocation(this.prefix == null ? null : this.prefix.toLowerCase(), this.libname == null ? null : this.libname.toLowerCase(), this.filename == null ? null : this.filename.toLowerCase(), this.memberName == null ? null : this.memberName.toLowerCase());
    }

    public IRelativeLocation getLocationRelativeTo(ILocation location) {
        IBMiLibraryLocation relTo = (IBMiLibraryLocation)location.getAdapter(IBMiLibraryLocation.class);
        if (relTo == null) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.IBMiLibraryLocation_6, (Object)location, (Object[])new Object[0]));
        }
        if (!relTo.isPrefixOf(this)) {
            throw new IllegalStateException(NLS.bind((String)Messages.IBMiLibraryLocation_7, (Object)relTo.toString(), (Object[])new Object[]{this.toString()}));
        }
        if (relTo.prefix == null) {
            if (this.prefix == null) {
                return RelativeLocation.EMPTY_LOCATION;
            }
            if (this.libname == null) {
                return new RelativeLocation(new String[]{this.prefix});
            }
            if (this.filename == null) {
                return new RelativeLocation(new String[]{this.prefix, this.libname});
            }
            if (this.memberName == null) {
                return new RelativeLocation(new String[]{this.prefix, this.libname, this.filename});
            }
            return new RelativeLocation(new String[]{this.prefix, this.libname, this.filename, this.memberName});
        }
        if (relTo.libname == null) {
            if (this.libname == null) {
                return RelativeLocation.EMPTY_LOCATION;
            }
            if (this.filename == null) {
                return new RelativeLocation(new String[]{this.libname});
            }
            if (this.memberName == null) {
                return new RelativeLocation(new String[]{this.libname, this.filename});
            }
            return new RelativeLocation(new String[]{this.libname, this.filename, this.memberName});
        }
        if (relTo.filename == null) {
            if (this.filename == null) {
                return RelativeLocation.EMPTY_LOCATION;
            }
            if (this.memberName == null) {
                return new RelativeLocation(new String[]{this.filename});
            }
            return new RelativeLocation(new String[]{this.filename, this.memberName});
        }
        if (relTo.memberName == null) {
            if (this.memberName == null) {
                return RelativeLocation.EMPTY_LOCATION;
            }
            return new RelativeLocation(new String[]{this.memberName});
        }
        return RelativeLocation.EMPTY_LOCATION;
    }

    public String getName() {
        if (this.memberName != null) {
            return this.memberName;
        }
        if (this.filename != null) {
            return this.filename;
        }
        if (this.libname != null) {
            return this.libname;
        }
        if (this.prefix != null) {
            return this.prefix;
        }
        return EMPTY_STRING;
    }

    public ILocation getParent() {
        if (this.memberName != null) {
            return new IBMiLibraryLocation(this.prefix, this.libname, this.filename, null);
        }
        if (this.filename != null) {
            return new IBMiLibraryLocation(this.prefix, this.libname, null, null);
        }
        if (this.libname != null) {
            return new IBMiLibraryLocation(this.prefix, null, null, null);
        }
        return new IBMiLibraryLocation(null, null, null, null);
    }

    public String getStorageId() {
        return STORAGE_ID;
    }

    public boolean isCaseSensitive() {
        return false;
    }

    public boolean isEmpty() {
        return !(this.prefix != null && !EMPTY_STRING.equals(this.prefix) || this.libname != null && !EMPTY_STRING.equals(this.libname) || this.filename != null && !EMPTY_STRING.equals(this.filename) || this.memberName != null && !EMPTY_STRING.equals(this.memberName));
    }

    public boolean isPrefixOf(ILocation otherLoc) {
        return this.isPrefixOf(otherLoc, true);
    }

    public boolean isPrefixOf(ILocation otherLoc, boolean isCaseSensitive) {
        boolean prefixMatches;
        IBMiLibraryLocation other = (IBMiLibraryLocation)otherLoc.getAdapter(IBMiLibraryLocation.class);
        if (other == null) {
            return false;
        }
        if (this.prefix == null) {
            return true;
        }
        boolean bl = prefixMatches = isCaseSensitive ? this.prefix.equals(other.prefix) : this.prefix.equalsIgnoreCase(other.prefix);
        if (prefixMatches) {
            boolean libnameMatches;
            if (this.libname == null) {
                return true;
            }
            boolean bl2 = libnameMatches = isCaseSensitive ? this.libname.equals(other.libname) : this.libname.equalsIgnoreCase(other.libname);
            if (libnameMatches) {
                boolean filenameMatches;
                if (this.filename == null) {
                    return true;
                }
                boolean bl3 = filenameMatches = isCaseSensitive ? this.filename.equals(other.filename) : this.filename.equalsIgnoreCase(other.filename);
                if (filenameMatches) {
                    if (this.memberName == null) {
                        return true;
                    }
                    return isCaseSensitive ? this.memberName.equals(other.memberName) : this.memberName.equalsIgnoreCase(other.memberName);
                }
            }
        }
        return false;
    }

    public boolean sameLocation(ILocation anotherLocation, boolean isCaseSensitive) {
        if (this == anotherLocation) {
            return true;
        }
        if (!(anotherLocation instanceof IBMiLibraryLocation)) {
            return false;
        }
        IBMiLibraryLocation other = (IBMiLibraryLocation)anotherLocation;
        if (this.filename == null) {
            if (other.filename != null) {
                return false;
            }
        } else {
            boolean filenamesMatch;
            boolean bl = filenamesMatch = isCaseSensitive ? this.filename.equals(other.filename) : this.filename.equalsIgnoreCase(other.filename);
            if (!filenamesMatch) {
                return false;
            }
        }
        if (this.libname == null) {
            if (other.libname != null) {
                return false;
            }
        } else {
            boolean libnamesMatch;
            boolean bl = libnamesMatch = isCaseSensitive ? this.libname.equals(other.libname) : this.libname.equalsIgnoreCase(other.libname);
            if (!libnamesMatch) {
                return false;
            }
        }
        if (this.memberName == null) {
            if (other.memberName != null) {
                return false;
            }
        } else {
            boolean memberNamesMatch;
            boolean bl = memberNamesMatch = isCaseSensitive ? this.memberName.equals(other.memberName) : this.memberName.equalsIgnoreCase(other.memberName);
            if (!memberNamesMatch) {
                return false;
            }
        }
        if (this.prefix == null) {
            if (other.prefix != null) {
                return false;
            }
        } else {
            boolean prefixesMatch;
            boolean bl = prefixesMatch = isCaseSensitive ? this.prefix.equals(other.prefix) : this.prefix.equalsIgnoreCase(other.prefix);
            if (!prefixesMatch) {
                return false;
            }
        }
        return true;
    }

    public String toOSString() {
        return this.toString();
    }

    public String toString() {
        if (this.prefix == null) {
            return EMPTY_STRING;
        }
        if (this.libname == null) {
            return this.prefix;
        }
        if (this.filename == null) {
            return String.valueOf(this.prefix) + this.libname;
        }
        if (this.memberName == null) {
            return String.valueOf(this.prefix) + this.libname + '/' + this.filename;
        }
        return String.valueOf(this.prefix) + this.libname + '/' + this.filename + '(' + this.memberName + ')';
    }

    public boolean equals(Object obj) {
        if (obj instanceof IBMiLibraryLocation) {
            return this.sameLocation((IBMiLibraryLocation)obj, true);
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.filename == null ? 0 : this.filename.hashCode());
        result = 31 * result + (this.prefix == null ? 0 : this.prefix.hashCode());
        result = 31 * result + (this.libname == null ? 0 : this.libname.hashCode());
        result = 31 * result + (this.memberName == null ? 0 : this.memberName.hashCode());
        return result;
    }

    private static String unescapeAndSubstituteYenSignIfNeeded(String value) {
        String ret;
        String string = ret = value != null ? IBMiProjectResourceNameUtil.unEscapeFileName(value) : null;
        if (ret != null && !ret.startsWith("\"") && ret.contains("\u00a5") && !IBMiLibraryLocation.keepYenSign()) {
            ret = ret.replace('\u00a5', '$');
        }
        return ret;
    }

    private static boolean keepYenSign() {
        String codePage = null;
        try {
            codePage = String.valueOf(IBMiLibraryLocation.getPlatformCCSID());
            Charset cs = null;
            try {
                cs = Charset.forName(codePage);
            }
            catch (UnsupportedCharsetException e) {
                return false;
            }
            ByteBuffer bb = cs.encode("\u00a5");
            byte b = bb.get();
            if (b == 91) {
                return true;
            }
        }
        finally {
            return false;
        }
        {
        }
    }

    private static int getPlatformCCSID() {
        return as400 != null ? as400.getCcsid() : 37;
    }
}

