/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.scmee.common;

import com.ibm.team.enterprise.scmee.common.DeferredFileLoadInformation;
import com.ibm.team.enterprise.scmee.common.nls.SCMEEMessages;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.FileSystemStatusException;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileItemInfoProxy;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.IShareableInternal;
import com.ibm.team.filesystem.client.internal.MetadataProperties;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.Shed;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.utils.NonCancellingProgressMonitor;
import com.ibm.team.filesystem.client.operations.IRemovedShare;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.internal.FileContent;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdate;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IAncestorReport;
import com.ibm.team.scm.common.dto.INameItemPair;
import com.ibm.team.scm.common.dto.ISyncTime;
import com.ibm.team.scm.common.dto.ISynchronizationTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

public class SCMEEUtils {
    public static boolean isSimulation() {
        return System.getProperty("scmee.simulate") != null;
    }

    public static void throwAppropriateException(String msg, IStatus[] statuses) throws FileSystemStatusException {
        MultiStatus multi = new MultiStatus("com.ibm.team.filesystem.client", 0, statuses, msg, null);
        if (multi.isOK()) {
            return;
        }
        if (multi.matches(4)) {
            throw new FileSystemStatusException((IStatus)multi);
        }
        if (multi.matches(8)) {
            throw new OperationCanceledException();
        }
        throw new FileSystemStatusException((IStatus)multi);
    }

    public static void deleteShareableLoaded(final IShareableInternal shareableLoaded, IContextHandle connectionHandle, IComponentHandle componentHandle, IVersionableHandle versionable, final Shed shed, ISandbox sandbox, IProgressMonitor progress) throws FileSystemException {
        if (shareableLoaded == null) {
            return;
        }
        final SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        SharingManager.getInstance().doSilentChange(new SharingManager.FileSystemAccessor(){

            public void run() throws FileSystemException {
                if (shareableLoaded.getFileStorage().exists((IProgressMonitor)monitor.newChild(5))) {
                    shareableLoaded.getFileStorage().delete(shed, (IProgressMonitor)monitor.newChild(90));
                }
            }
        });
        FileItemInfo info = shareableLoaded.getFileItemInfo((IProgressMonitor)monitor.newChild(1));
        if (info != null) {
            SharingManager.getInstance().forget(shareableLoaded, (IProgressMonitor)monitor.newChild(5));
        } else if (versionable != null) {
            SharingManager.getInstance().forget(sandbox.getRoot(), connectionHandle, componentHandle, versionable, (IProgressMonitor)monitor.newChild(5));
        }
    }

    public static void removeExtraneousMetadata(ICopyFileArea cfa, Map<UUID, HashMap<String, UUID>> allFolderChildren, IContextHandle connectionHandle, IComponentHandle component, Shed shed, IProgressMonitor progress) throws FileSystemException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)allFolderChildren.size());
        Collection allShares = cfa.allShares(connectionHandle, component, (IProgressMonitor)monitor.newChild(1));
        Map<UUID, Set<IShare>> relatedShares = SCMEEUtils.organizeSharesByLoadRoot(allShares);
        for (Map.Entry<UUID, HashMap<String, UUID>> entry : allFolderChildren.entrySet()) {
            SubMonitor subProgress = monitor.newChild(1);
            HashMap<String, UUID> namesOfChildrenLoaded = entry.getValue();
            Set<IShare> shares = relatedShares.get(entry.getKey());
            if (shares != null) {
                subProgress.setWorkRemaining(shares.size() * 4);
                for (IShare share : shares) {
                    IShareableInternal shareable = (IShareableInternal)share.getShareable();
                    UUID childLoaded = namesOfChildrenLoaded.get(shareable.getLocalPath().getName());
                    if (childLoaded == null) {
                        SharingManager.getInstance().disableChangeMonitoring();
                        try {
                            if (!shareable.exists((IProgressMonitor)subProgress.newChild(1))) continue;
                            shareable.getFileStorage().delete(shed, (IProgressMonitor)subProgress.newChild(1));
                            continue;
                        }
                        finally {
                            SharingManager.getInstance().enableChangeMonitoring();
                            FileItemInfo info = cfa.getItemInfo(shareable.getLocalPath());
                            if (info != null) {
                                cfa.forget(shareable.getLocalPath(), (IProgressMonitor)subProgress.newChild(1));
                            } else {
                                cfa.forget(connectionHandle, component, share.getSharingDescriptor().getRootVersionable(), (IProgressMonitor)subProgress.newChild(1));
                            }
                        }
                    }
                    if (share.getSharingDescriptor().getRootVersionable().getItemId().equals((Object)childLoaded)) continue;
                    cfa.forget(connectionHandle, component, share.getSharingDescriptor().getRootVersionable(), (IProgressMonitor)subProgress.newChild(3));
                }
            }
            subProgress.done();
        }
    }

    public static void updateConfigurationStates(ICopyFileArea cfa, ArrayList<IVersionableHandle> shares, HashSet<UUID> inconsistentShares, IContextHandle connectionHandle, IComponentHandle component, ISynchronizationTime time, IProgressMonitor progress) throws FileSystemException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)shares.size());
        ISyncTime syncTime = ISyncTime.FACTORY.createFrom(time);
        for (IVersionableHandle shareRoot : shares) {
            if (inconsistentShares.contains(shareRoot.getItemId())) continue;
            cfa.setConfigurationState(connectionHandle, component, shareRoot, syncTime, (IProgressMonitor)monitor.newChild(1));
        }
    }

    private static Map<UUID, Set<IShare>> organizeSharesByLoadRoot(Collection<IShare> allShares) {
        HashMap<UUID, Set<IShare>> shares = new HashMap<UUID, Set<IShare>>();
        for (IShare share : allShares) {
            IVersionableHandle root = share.getSharingDescriptor().getReloadRoot();
            HashSet<IShare> children = (HashSet<IShare>)shares.get(root.getItemId());
            if (children == null) {
                children = new HashSet<IShare>();
                shares.put(root.getItemId(), children);
            }
            children.add(share);
        }
        return shares;
    }

    public static void updateContentLoadedMetaData(ICopyFileArea cfa, ArrayList<DeferredFileLoadInformation> pathsToUpdate, IProgressMonitor progress) throws FileSystemException {
        SubMonitor subProgress = SubMonitor.convert((IProgressMonitor)progress, (int)(pathsToUpdate.size() * 2 + 10));
        for (DeferredFileLoadInformation loadInfo : pathsToUpdate) {
            if (!loadInfo.contentUpdated()) {
                subProgress.worked(1);
                continue;
            }
            FileAreaUpdate update = loadInfo.getFileAreaUpdate();
            IShareableInternal shareable = loadInfo.getShareable();
            SCMEEUtils.updateMetaInfoForPath(cfa, update.getComponent(), update.afterState(), shareable, loadInfo, (IProgressMonitor)subProgress.newChild(1));
        }
        subProgress.done();
    }

    private static void updateMetaInfoForPath(ICopyFileArea copyFileArea, IComponentHandle componentHandle, IVersionableHandle fileItem, IShareableInternal shareable, DeferredFileLoadInformation updateInfo, IProgressMonitor monitor) throws FileSystemException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)new NonCancellingProgressMonitor(monitor), (int)100);
        IFileStorage file = shareable.getFileStorage();
        IFolderHandle parent = null;
        String name = null;
        boolean loadedWithAnotherName = false;
        parent = updateInfo.getRemoteParent();
        name = updateInfo.getRemoteName();
        loadedWithAnotherName = true;
        FileContent content = (FileContent)updateInfo.getContent();
        FileItemInfoProxy newInfoProxy = new FileItemInfoProxy(fileItem, parent, name, loadedWithAnotherName);
        newInfoProxy.setContentInfo(file.getModificationStamp(), updateInfo.getHash(), updateInfo.getContentSize(), content);
        newInfoProxy.setExecutable(updateInfo.isExecutable(), updateInfo.isExecutable());
        newInfoProxy.setContentType(updateInfo.getFileAreaUpdate().getContentType());
        FileItemInfo newInfo = newInfoProxy.getFileItemInfo();
        MetadataProperties properties = updateInfo.getMetadataProperties();
        if (updateInfo.isShare()) {
            ISharingDescriptor descriptor = updateInfo.getSharingDescriptor();
            SharingManager.getInstance().share(shareable, descriptor, newInfo, properties, 2, (IProgressMonitor)progress.newChild(10));
        } else {
            copyFileArea.setItemMetaData(updateInfo.getShareable().getLocalPath(), newInfo, ICopyFileArea.PropertyUpdate.REPLACE, properties, (IProgressMonitor)progress.newChild(10));
        }
        file.setExecutable(updateInfo.isExecutable(), (IProgressMonitor)progress.newChild(10));
        progress.done();
    }

    public static void removeShares(Set<IRemovedShare> sharesToRemove, Shed shed, ISandbox sandbox, IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)sharesToRemove.size());
        for (IRemovedShare shareToRemove : sharesToRemove) {
            IShare share = shareToRemove.getShare();
            mon.setTaskName(NLS.bind((String)SCMEEMessages.SCMEEUtils_0, (Object)share.getPath().toString(), (Object[])new Object[0]));
            if (shareToRemove.isToBeDeleted()) {
                SCMEEUtils.removeShare(share, shed, sandbox, (IProgressMonitor)mon.newChild(1));
            } else {
                ResourceType type = ResourceType.FOLDER;
                ISharingDescriptor descriptor = share.getSharingDescriptor();
                if (descriptor != null) {
                    type = ResourceType.getResourceType((IVersionableHandle)descriptor.getRootVersionable());
                }
                Shareable shareable = (Shareable)share.getSandbox().findShareable(share.getPath(), type);
                shareable.unshare((IProgressMonitor)mon.newChild(1));
            }
            if (!mon.isCanceled()) continue;
            throw new OperationCanceledException();
        }
        mon.done();
    }

    private static void removeShare(IShare share, Shed shed, ISandbox sandbox, IProgressMonitor progress) throws FileSystemException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        IShareableInternal shareable = (IShareableInternal)share.getShareable();
        SCMEEUtils.deleteShareableLoaded(shareable, share.getSharingDescriptor().getConnectionHandle(), share.getSharingDescriptor().getComponent(), share.getSharingDescriptor().getRootVersionable(), shed, sandbox, (IProgressMonitor)monitor.newChild(70));
    }

    public static String getFileFullPath(IWorkspaceConnection wsConnection, IComponentHandle componentHandle, IFileItemHandle fileItem, IProgressMonitor monitor) throws TeamRepositoryException {
        String result = null;
        StringBuffer sb = new StringBuffer();
        IConfiguration configuration = wsConnection.configuration(componentHandle);
        try {
            List niPairs = ((IAncestorReport)configuration.determineAncestorsInHistory(Collections.singletonList(fileItem), null).get(0)).getNameItemPairs();
            for (INameItemPair niPair : niPairs) {
                String name = niPair.getName();
                if (name == null) continue;
                sb.append("/");
                sb.append(name);
            }
            result = sb.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }
}

