/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.scmee.common;

import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.DebugStack;
import com.ibm.team.build.extensions.common.debug.Debugger;
import com.ibm.team.build.extensions.common.debug.IDebugLogger;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.enterprise.common.common.BuildPropertyTable;
import com.ibm.team.enterprise.common.common.utils.LoadTracing;
import com.ibm.team.enterprise.scmee.common.DebuggerLoggerLoad;
import com.ibm.team.enterprise.scmee.common.EncodedContentExaminer;
import com.ibm.team.enterprise.scmee.common.SCMEEBackupHandler;
import com.ibm.team.filesystem.client.IContentExaminer;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.api.storage.AbstractStorageManager;
import com.ibm.team.filesystem.client.internal.api.storage.IBackupHandler;
import com.ibm.team.filesystem.client.internal.magic.LocalContentExaminer;
import com.ibm.team.filesystem.client.internal.operations.ILoadEvaluator;
import com.ibm.team.filesystem.client.internal.operations.NonHierarchicalLoadEvaluator;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import java.io.File;

public abstract class SCMEEStorageManager
extends AbstractStorageManager {
    private static final String cls = SCMEEStorageManager.class.getSimpleName();
    public static final boolean SIMULATION_ENABLED = Boolean.getBoolean("scmee.simulate");
    public static final boolean TRACING_ENABLED;
    public static final LoadTracing loadTracing;
    public static final IDebugger commonDbg;
    public static final IDebugLogger commonLogger;

    static {
        commonDbg = new Debugger(SCMEEStorageManager.class);
        TRACING_ENABLED = Boolean.getBoolean("team.enterprise.scm.log.loading");
        if (TRACING_ENABLED) {
            loadTracing = new LoadTracing();
            loadTracing.setLogFile(SCMEEStorageManager.getLogFile());
            loadTracing.setWriter();
            commonLogger = new DebuggerLoggerLoad(loadTracing, commonDbg);
            loadTracing.setLogger(commonLogger);
            loadTracing.addDebugger(commonDbg);
            if (BuildPropertyTable.getInstance().getDbg().isDebugOn()) {
                loadTracing.addDebugger(BuildPropertyTable.getInstance().getDbg());
            }
        } else {
            loadTracing = null;
            commonLogger = null;
        }
        if (commonDbg.isDebug()) {
            Debug.setup((IDebugger)commonDbg, (String[])new String[]{cls});
        }
        if (commonDbg.isTrace()) {
            DebugStack.setup((IDebugger)commonDbg, (String)cls);
        }
    }

    public static IDebugger getCommonDbg() {
        return commonDbg;
    }

    public static LoadTracing getLoadTracing() {
        return loadTracing;
    }

    private static String getLogFile() {
        String fileSep;
        String logDir = System.getProperty("team.enterprise.scm.fetchDestination");
        String buildLabel = System.getProperty("buildLabel");
        String logFile = "";
        if (logDir != null) {
            File dir = new File(logDir);
            if (!dir.exists()) {
                dir.mkdirs();
            }
        } else {
            logDir = SCMEEStorageManager.getTempDirectory();
        }
        if ((fileSep = System.getProperty("file.separator")) != null && !logDir.endsWith(fileSep)) {
            logDir = String.valueOf(logDir) + fileSep;
        }
        logFile = String.valueOf(logDir) + "load-" + buildLabel + ".log";
        return logFile;
    }

    private static String getTempDirectory() {
        String tmpDir = System.getProperty("java.io.tmpdir");
        if (tmpDir != null) {
            String fileSep = System.getProperty("file.separator");
            if (fileSep != null && !tmpDir.endsWith(fileSep)) {
                tmpDir = String.valueOf(tmpDir) + fileSep;
            }
        } else {
            tmpDir = "";
        }
        return tmpDir;
    }

    public boolean hasEFSSupport() {
        return false;
    }

    public IBackupHandler getBackupHandler(ISandbox sandbox, BackupDilemmaHandler backupDilemmaHandler) {
        return new SCMEEBackupHandler(sandbox, backupDilemmaHandler);
    }

    public IContentExaminer getContentExaminer(IShareable arg0) {
        return new EncodedContentExaminer(LocalContentExaminer.getInstance());
    }

    public ILoadEvaluator getLoadEvaluator() {
        return new NonHierarchicalLoadEvaluator();
    }

    public boolean transformsContentsSet() {
        return false;
    }
}

