/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.scmee.common;

import com.ibm.team.enterprise.scmee.common.MissingEnvironmentVariableException;
import com.ibm.team.enterprise.scmee.common.SCMEEFileStorage;
import com.ibm.team.enterprise.scmee.common.SCMEESharingMetadata;
import com.ibm.team.enterprise.scmee.common.nls.SCMEEMessages;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.internal.PathLocation;
import com.ibm.team.filesystem.client.internal.api.storage.AbstractSharingMetadata;
import com.ibm.team.filesystem.client.internal.api.storage.AbstractSharingMetadataFactory;
import com.ibm.team.filesystem.client.internal.core.SharingMetadataFactory;
import com.ibm.team.filesystem.client.internal.operations.RebuildCFAOperation;
import com.ibm.team.filesystem.client.operations.IMetadataRepairOperation;
import com.ibm.team.filesystem.client.operations.MetadataRepairDilemmaHandler;
import java.io.File;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

public abstract class SCMEEMetadataFactory
extends AbstractSharingMetadataFactory {
    private static String scmHome = null;
    private static final String SCM_PRIVATE_QUALIFIER = "SCM";
    private static final String SCM_WORK_ENVIRONMENT_VARIABLE = "SCM_WORK";

    public boolean hasInterumSharingMetadata(ILocation root) {
        return false;
    }

    public boolean hasOldSharingMetadata(ILocation root) {
        return false;
    }

    public boolean hasAnySharingMetadata(ILocation root) {
        return this.hasSharingMetadata(root);
    }

    public boolean hasSharingMetadata(ILocation root) {
        File metadataRoot = new File(this.getSharingMetadataRoot(root).toOSString());
        return metadataRoot.exists();
    }

    public IMetadataRepairOperation getMetadataRepairOperation(ILocation root, MetadataRepairDilemmaHandler dilemmaHandler, IRepositoryResolver resolver) {
        return new RebuildCFAOperation(root, this.getSharingMetadataRoot(root), dilemmaHandler, resolver);
    }

    protected ILocation getSharingMetadataRoot(ILocation root) {
        if (scmHome == null && ((scmHome = System.getenv(SCM_WORK_ENVIRONMENT_VARIABLE)) == null || scmHome.trim().length() < 1)) {
            if (System.getProperty("scmee.simulate") != null) {
                scmHome = new File(SCMEEFileStorage.SIMULER_AREA, ".scm-work").toString();
            } else {
                throw new MissingEnvironmentVariableException(NLS.bind((String)SCMEEMessages.ZSharingMetadataFactory_1, (Object)SCM_WORK_ENVIRONMENT_VARIABLE));
            }
        }
        return SharingMetadataFactory.getMetadataRoot((ILocation)new PathLocation(new Path(scmHome).append(SCM_PRIVATE_QUALIFIER).append(root.toOSString())));
    }

    public AbstractSharingMetadata getSharingMetadata(ILocation root) throws FileSystemException {
        return new SCMEESharingMetadata(root, root.isCaseSensitive(), this.getSharingMetadataRoot(root));
    }
}

