/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.scmee.common;

import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.DebugStack;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogField;
import com.ibm.team.build.extensions.common.debug.Mnm;
import com.ibm.team.enterprise.scmee.common.SCMEEStorageManager;
import com.ibm.team.enterprise.scmee.common.nls.SCMEEMessages;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingManager;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileStorage;
import com.ibm.team.filesystem.client.internal.FileStorageWrapper;
import com.ibm.team.filesystem.client.internal.IFileOptions;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.INonEFS;
import com.ibm.team.filesystem.client.internal.IShareableInternal;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.Shed;
import com.ibm.team.filesystem.client.internal.api.storage.IBackupHandler;
import com.ibm.team.filesystem.client.internal.exceptions.ContentRetrievalFailure;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.repository.common.util.NLS;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;

public abstract class SCMEEFileStorage
extends FileStorage
implements INonEFS {
    private static final String cls = SCMEEFileStorage.class.getSimpleName();
    public static final File SIMULER_AREA = new File(System.getProperty("java.io.tmpdir"));
    private final IDebugger dbg = SCMEEStorageManager.getCommonDbg();
    private final boolean debug = this.dbg.isDebug();
    private final boolean trace = this.dbg.isTrace();
    private final boolean items = this.dbg.isItems();
    private final String dbgName;

    protected abstract InputStream transmitBinaryContents() throws ContentRetrievalFailure;

    protected abstract boolean updateSpecialContents(InputStream var1) throws FileSystemException;

    protected abstract InputStream getBinaryContents() throws ContentRetrievalFailure;

    protected abstract InputStream getEncodedContents(String var1, String var2) throws UnsupportedEncodingException, ContentRetrievalFailure;

    protected abstract boolean updateContents(InputStream var1, IFileOptions var2, String var3) throws FileSystemException;

    protected abstract boolean isSpecialBinaryContent(IFileOptions var1) throws FileSystemException;

    protected abstract String retrieveLocalEncoding(IFileOptions var1);

    protected SCMEEFileStorage(IFileStorage storage) {
        super(storage);
        this.dbgName = storage.getName();
        if (this.debug) {
            Debug.setup((IDebugger)this.dbg, (String[])new String[]{cls, this.dbgName});
        }
        if (this.trace) {
            Debug.setup((IDebugger)this.dbg, (String[])new String[]{cls, this.dbgName, LogField.valueOf((storage.getShareable() != null ? 1 : 0) != 0)});
        }
        if (this.items) {
            DebugStack.setup((IDebugger)this.dbg, (String)cls);
        }
    }

    public void backup(IBackupHandler shed, BackupDilemmaHandler dilemmaHandler, IProgressMonitor monitor) throws FileSystemException {
        shed.backupInShed((IShareable)this.getStorage().getShareable(), monitor);
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), this.dbgName});
        }
    }

    protected IFileStore getFileStore() {
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), this.dbgName});
        }
        return null;
    }

    public IRelativeLocation getIDEPath() {
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), this.dbgName});
        }
        return this.getLocalPath();
    }

    public long getLocalTimeStamp() throws FileSystemException {
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), this.dbgName});
        }
        return this.getModificationStamp();
    }

    public boolean supportsExecBit() {
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), this.dbgName});
        }
        return false;
    }

    public boolean shouldBeIgnored(IProgressMonitor monitor) {
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), this.dbgName});
        }
        return false;
    }

    public boolean setWritable(boolean writable, IProgressMonitor progress) {
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), this.dbgName});
        }
        return false;
    }

    public boolean setExecutable(boolean exec, IProgressMonitor monitor) {
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), this.dbgName});
        }
        return false;
    }

    public boolean isSymbolicLink(IProgressMonitor monitor) throws FileSystemException {
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), this.dbgName});
        }
        return false;
    }

    public void setSymLinkTarget(String targetPath, IProgressMonitor newChild) throws FileSystemException {
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), this.dbgName});
        }
    }

    public String getSymLinkTarget(IProgressMonitor newChild) throws FileSystemException {
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), this.dbgName});
        }
        return null;
    }

    public boolean contains(ISchedulingRule rule) {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
        if (this == rule) {
            if (this.debug) {
                Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName, "0"});
            }
            return true;
        }
        if (rule instanceof MultiRule) {
            MultiRule multi = (MultiRule)rule;
            ISchedulingRule[] children = multi.getChildren();
            int i = 0;
            while (i < children.length) {
                if (!this.contains(children[i])) {
                    if (this.debug) {
                        Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName, "1"});
                    }
                    return false;
                }
                ++i;
            }
            if (this.debug) {
                Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName, "2"});
            }
            return true;
        }
        if (!(rule instanceof IFileStorage)) {
            if (this.debug) {
                Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName, "3"});
            }
            return false;
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName, "4"});
        }
        return this.getIDEPath().isPrefixOf(((IFileStorage)rule).getIDEPath());
    }

    public void deregisterRepositoryProvider(IProgressMonitor monitor) throws FileSystemException {
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), this.dbgName});
        }
    }

    public Collection<IFileStorage> getChildren(boolean refreshAllowed, IProgressMonitor progress) throws FileSystemException {
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), this.dbgName});
        }
        return Collections.emptyList();
    }

    public ISchedulingRule getResourceRuleForIDE(ISharingManager.RuleKind kind) {
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), this.dbgName});
        }
        return null;
    }

    public boolean isConflicting(ISchedulingRule rule) {
        if (!(rule instanceof IFileStorage)) {
            return false;
        }
        ILocation otherPath = ((IFileStorage)rule).getShareable().getFullPath();
        ILocation fullPath = this.getStorage().getShareable().getFullPath();
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), this.dbgName});
        }
        return fullPath.isPrefixOf(otherPath) || otherPath.isPrefixOf(fullPath);
    }

    public boolean isExecutable(IProgressMonitor monitor) throws FileSystemException {
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), this.dbgName});
        }
        return false;
    }

    public boolean isRepositoryProviderRegistered(IProgressMonitor monitor) throws FileSystemException {
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), this.dbgName});
        }
        return false;
    }

    public void preserveHistory(IProgressMonitor monitor) throws FileSystemException {
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), this.dbgName});
        }
    }

    public void refreshCachedSubTree(int depth, IProgressMonitor monitor) throws FileSystemException {
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), this.dbgName});
        }
    }

    public void registerRepositorProvider(IProgressMonitor monitor) throws FileSystemException {
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), this.dbgName});
        }
    }

    public IFileStorage getParent() {
        IRelativeLocation parentPath = this.getStorage().getShareable().getLocalPath().getParent();
        FileStorageWrapper parent = null;
        if (parentPath != null && !parentPath.isEmpty()) {
            Shareable parentShareable = new Shareable(this.getStorage().getShareable().getSandbox(), parentPath, ResourceType.FOLDER);
            parent = new FileStorageWrapper((IShareableInternal)parentShareable, ResourceType.FOLDER);
        }
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), this.dbgName});
        }
        return parent;
    }

    public boolean isReadOnly(IProgressMonitor progress) throws FileSystemException {
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get(), this.dbgName});
        }
        return false;
    }

    public InputStream getContents(IFileOptions fileOptions) throws ContentRetrievalFailure {
        boolean isFile;
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
        if (fileOptions == null) {
            throw new IllegalStateException();
        }
        try {
            isFile = this.isFile((IProgressMonitor)new NullProgressMonitor());
        }
        catch (FileSystemException e) {
            throw new ContentRetrievalFailure(this.getIDEPath().toPath(), (Throwable)e);
        }
        if (!isFile) {
            if (this.debug) {
                Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName, "0"});
            }
            return null;
        }
        InputStream in = null;
        boolean isSpecialBinary = false;
        try {
            isSpecialBinary = this.isSpecialBinaryContent(fileOptions);
        }
        catch (FileSystemException e) {
            throw new ContentRetrievalFailure(NLS.bind((String)SCMEEMessages.SCMEEFileStorage_0, (Object)this.getLocalPath().toString(), (Object[])new Object[]{e.getMessage()}), this.getLocalPath(), (Throwable)e);
        }
        if (isSpecialBinary) {
            in = this.transmitBinaryContents();
        } else {
            FileLineDelimiter lineDelimiter = fileOptions.getLineDelimiter();
            if (lineDelimiter.equals((Object)FileLineDelimiter.LINE_DELIMITER_NONE)) {
                in = this.getBinaryContents();
            } else {
                String localEncoding = this.retrieveLocalEncoding(fileOptions);
                String serverEncoding = fileOptions.getCharacterEncoding();
                try {
                    in = this.getEncodedContents(localEncoding, serverEncoding);
                }
                catch (UnsupportedEncodingException e) {
                    throw new ContentRetrievalFailure(NLS.bind((String)SCMEEMessages.SCMEEFileStorage_1, (Object)this.getLocalPath().toString(), (Object[])new Object[]{localEncoding, e.getMessage()}), this.getLocalPath(), (Throwable)e);
                }
            }
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName, "1"});
        }
        return in;
    }

    public void setContents(IFileOptions fileOptions, InputStream in, Shed backupShed, IProgressMonitor monitor) throws FileSystemException {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
        if (fileOptions == null) {
            throw new IllegalStateException();
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        boolean success = false;
        try {
            success = this.isSpecialBinaryContent(fileOptions) ? this.updateSpecialContents(in) : this.updateContents(in, fileOptions, null);
        }
        finally {
            block12: {
                progress.done();
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        if (!success) break block12;
                        throw new FileSystemException((Throwable)e);
                    }
                }
            }
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, this.dbgName});
        }
    }
}

