/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.scmee.common;

import java.io.PrintStream;
import org.apache.commons.logging.Log;

public class LogUtility {
    private static final boolean DEBUG = false;

    static {
        new LogUtility();
    }

    private LogUtility() {
    }

    public static void logTrace(Log log, Exception e, String ... mess) {
        if (log.isTraceEnabled()) {
            log.trace((Object)LogUtility.formattedMess(mess, e));
        }
    }

    public static void logDebug(Log log, Exception e, String ... mess) {
        if (log.isDebugEnabled()) {
            log.debug((Object)LogUtility.formattedMess(mess, e));
        }
    }

    public static void logInfo(Log log, Exception e, String ... mess) {
        if (log.isInfoEnabled()) {
            log.info((Object)LogUtility.formattedMess(mess, e));
        }
    }

    public static void logWarn(Log log, Exception e, String ... mess) {
        if (log.isWarnEnabled()) {
            log.warn((Object)LogUtility.formattedMess(mess, e));
        }
    }

    public static void logError(Log log, Exception e, String ... mess) {
        if (log.isErrorEnabled()) {
            log.error((Object)LogUtility.formattedMess(mess, e));
        }
    }

    public static void logFatal(Log log, Exception e, String ... mess) {
        if (log.isFatalEnabled()) {
            log.fatal((Object)LogUtility.formattedMess(mess, e));
        }
    }

    private static String formattedMess(String[] mess, Exception e) {
        StringBuffer bf = new StringBuffer();
        if (mess != null) {
            String[] stringArray = mess;
            int n = mess.length;
            int n2 = 0;
            while (n2 < n) {
                String m = stringArray[n2];
                if (m != null) {
                    bf.append(m);
                }
                ++n2;
            }
        }
        if (e != null) {
            bf.append(e.getMessage() != null ? e.getMessage() : e.toString());
            e.printStackTrace();
        }
        return bf.toString();
    }

    private static void display(PrintStream print, String formattedMess) {
        print.println(formattedMess);
    }
}

