/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.scmee.common;

import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.Mnm;
import com.ibm.team.enterprise.scmee.common.SCMEEStorageManager;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IContentExaminer;
import com.ibm.team.filesystem.client.IContentProperties;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.magic.ContentProperties;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import java.nio.charset.Charset;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class EncodedContentExaminer
implements IContentExaminer {
    private static final String cls = EncodedContentExaminer.class.getSimpleName();
    private static final String DEFAULT_SCM_ENCODING = "UTF-8";
    private final IContentExaminer parentExaminer;
    private final IDebugger dbg;
    private final boolean debug;
    private final boolean trace;

    public EncodedContentExaminer(IContentExaminer contentExaminer) {
        this.parentExaminer = contentExaminer;
        this.dbg = SCMEEStorageManager.getCommonDbg();
        this.debug = this.dbg.isDebug();
        this.trace = this.dbg.isTrace();
        if (this.debug) {
            Debug.setup((IDebugger)this.dbg, (String[])new String[]{cls});
        }
    }

    public IContentProperties examine(IShareable shareable, IProgressMonitor monitor) throws FileSystemException {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        IContentProperties properties = this.parentExaminer.examine(shareable, (IProgressMonitor)progress.newChild(1));
        boolean isBinaryCode = Boolean.valueOf((String)shareable.getMetadataProperties((IProgressMonitor)progress.newChild(1)).getCurrentProperties().get("isBinary"));
        if (isBinaryCode) {
            if (this.debug) {
                Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, "0"});
            }
            return new ContentProperties("", "application/unknown", FileLineDelimiter.LINE_DELIMITER_NONE);
        }
        String encoding = this.retrieveServerEncoding(((Shareable)shareable).getFileItemInfo((IProgressMonitor)progress.newChild(1)));
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, "1"});
        }
        return new ContentProperties(encoding, properties.getMimeType(), properties.getLineDelimiter(), properties.getContentTypeForMerge(), properties.isText());
    }

    private String retrieveServerEncoding(FileItemInfo info) throws FileSystemException {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
        String enc = null;
        if (info != null) {
            enc = info.getStoredEncoding();
        }
        if (!(enc != null && enc.trim().length() >= 1 || (enc = System.getenv("JAZZ_LANG")) != null && enc.trim().length() >= 1)) {
            enc = DEFAULT_SCM_ENCODING;
        }
        if (!Charset.isSupported(enc)) {
            enc = DEFAULT_SCM_ENCODING;
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
        return enc;
    }

    public IContentProperties findStoredProperties(IShareable shareable, IProgressMonitor monitor) throws FileSystemException {
        boolean isBinaryCode;
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
        if (isBinaryCode = Boolean.valueOf((String)shareable.getMetadataProperties((IProgressMonitor)new NullProgressMonitor()).getCurrentProperties().get("isBinary")).booleanValue()) {
            if (this.debug) {
                Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, "0"});
            }
            return new ContentProperties("", "application/unknown", FileLineDelimiter.LINE_DELIMITER_NONE);
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        FileItemInfo fileItemInfo = ((Shareable)shareable).getFileItemInfo((IProgressMonitor)progress.newChild(25));
        String mimeType = "application/unknown";
        FileLineDelimiter delimiter = FileLineDelimiter.LINE_DELIMITER_NONE;
        if (fileItemInfo != null) {
            mimeType = fileItemInfo.getContentType();
            delimiter = fileItemInfo.getLineDelimiter();
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, "1"});
        }
        return new ContentProperties(this.retrieveServerEncoding(fileItemInfo), mimeType, delimiter);
    }

    public String getEncoding(IShareable shareable, IProgressMonitor monitor) throws FileSystemException {
        if (this.trace) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get()});
        }
        return this.findStoredProperties(shareable, monitor).getEncoding();
    }
}

