/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.scmee.common;

import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.DebugStack;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.Mnm;
import com.ibm.team.enterprise.scmee.common.SCMEEStorageManager;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.IFileOptions;
import com.ibm.team.filesystem.client.internal.IShareableInternal;
import com.ibm.team.filesystem.client.internal.MetadataProperties;
import com.ibm.team.filesystem.client.internal.api.storage.FileOptionsFactory;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.IFileContent;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdate;
import com.ibm.team.scm.common.ContentHash;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.util.Collections;
import java.util.Date;
import java.util.Map;

public class DeferredFileLoadInformation {
    private static final String cls = DeferredFileLoadInformation.class.getSimpleName();
    static final boolean SKIP_MODIFICATION_STAMPS = "true".equals(System.getenv("JAZZ_CCM_SKIP_MOD_TIME"));
    public static final String ISO_8859_1 = "ISO-8859-1";
    private final ICopyFileArea cfa;
    private final IShareableInternal shareable;
    private final FileAreaUpdate fileAreaUpdate;
    private final ISharingDescriptor sharingDescriptor;
    private String alternateEncoding;
    private boolean contentTransferred;
    private ContentHash hash;
    private long contentSize;
    private Exception failure;
    private Date existingShareableTimestamp;
    private boolean contentDeleted;
    private final IDebugger dbg;
    private final boolean debug;
    private final boolean trace;
    private final boolean items;

    public DeferredFileLoadInformation(ICopyFileArea cfa, IShareableInternal shareable, FileAreaUpdate update, ISharingDescriptor descriptor, Date existingShareableTimestamp) {
        this.cfa = cfa;
        this.shareable = shareable;
        this.fileAreaUpdate = update;
        this.sharingDescriptor = descriptor;
        this.contentTransferred = false;
        this.existingShareableTimestamp = existingShareableTimestamp;
        this.dbg = SCMEEStorageManager.getCommonDbg();
        this.debug = this.dbg.isDebug();
        this.trace = this.dbg.isTrace();
        this.items = this.dbg.isItems();
        if (this.debug) {
            Debug.setup((IDebugger)this.dbg, (String[])new String[]{cls});
        }
        if (this.trace) {
            Debug.setup((IDebugger)this.dbg, (String[])new String[]{cls, update.getName()});
        }
        if (this.items) {
            DebugStack.setup((IDebugger)this.dbg, (String)cls);
        }
    }

    public DeferredFileLoadInformation(ICopyFileArea cfa, IShareableInternal shareable, FileAreaUpdate update, ISharingDescriptor descriptor) {
        this.cfa = cfa;
        this.shareable = shareable;
        this.fileAreaUpdate = update;
        this.sharingDescriptor = descriptor;
        this.contentTransferred = false;
        this.existingShareableTimestamp = null;
        this.dbg = SCMEEStorageManager.getCommonDbg();
        this.debug = this.dbg.isDebug();
        this.trace = this.dbg.isTrace();
        this.items = this.dbg.isItems();
        if (this.debug) {
            Debug.setup((IDebugger)this.dbg, (String[])new String[]{cls});
        }
        if (this.items) {
            DebugStack.setup((IDebugger)this.dbg, (String)cls);
        }
    }

    public ICopyFileArea getCopyFileArea() {
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get()});
        }
        return this.cfa;
    }

    public boolean isShare() {
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get()});
        }
        return true;
    }

    public ISharingDescriptor getSharingDescriptor() {
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get()});
        }
        return this.sharingDescriptor;
    }

    public boolean contentUpdated() {
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get()});
        }
        return this.contentTransferred;
    }

    public boolean isExecutable() {
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get()});
        }
        return this.fileAreaUpdate.isExecutable();
    }

    public void setContentUpdated(ContentHash hash, long contentSize) {
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get()});
        }
        this.contentTransferred = true;
        this.hash = hash;
        this.contentSize = contentSize;
    }

    public IFileContent getContent() {
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get()});
        }
        return this.fileAreaUpdate.getOptionalContent();
    }

    public String getContentType() {
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get()});
        }
        return this.fileAreaUpdate.getContentType();
    }

    public MetadataProperties getMetadataProperties() {
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get()});
        }
        return new MetadataProperties(this.fileAreaUpdate.getMetadataProperties(), Collections.EMPTY_MAP, Collections.EMPTY_SET);
    }

    public String getRemoteName() {
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get()});
        }
        return this.fileAreaUpdate.getName();
    }

    public IFolderHandle getRemoteParent() {
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get()});
        }
        return this.fileAreaUpdate.getDestinationParent();
    }

    public IVersionableHandle getFileItemState() {
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get()});
        }
        return this.fileAreaUpdate.afterState();
    }

    public Date getFileTimestamp() {
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get()});
        }
        return this.fileAreaUpdate.getFileTimestamp();
    }

    public Date getExistingShareableTimestamp() {
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get()});
        }
        return this.existingShareableTimestamp;
    }

    public void setExistingShareableTimestamp(Date existingShareableTimestamp) {
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get()});
        }
        this.existingShareableTimestamp = existingShareableTimestamp;
    }

    public IComponentHandle getComponent() {
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get()});
        }
        return this.fileAreaUpdate.getComponent();
    }

    public ContentHash getHash() {
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get()});
        }
        return this.hash;
    }

    public long getContentSize() {
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get()});
        }
        return this.contentSize;
    }

    public void setFailure(Exception failureCause) {
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get()});
        }
        this.failure = failureCause;
        this.contentTransferred = false;
    }

    public Exception getFailure() {
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get()});
        }
        return this.failure;
    }

    public String getEncoding() {
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get()});
        }
        if (this.alternateEncoding == null) {
            return this.fileAreaUpdate.getOptionalContent().getCharacterEncoding();
        }
        return this.alternateEncoding;
    }

    public FileLineDelimiter getLineDelimiter() {
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get()});
        }
        return this.fileAreaUpdate.getOptionalContent().getLineDelimiter();
    }

    public FileAreaUpdate getFileAreaUpdate() {
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get()});
        }
        return this.fileAreaUpdate;
    }

    public void setAlternateEncoding(String alternateEncoding) {
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get()});
        }
        this.alternateEncoding = alternateEncoding;
    }

    public boolean hasAlternateDownloadDirection() {
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get()});
        }
        return this.alternateEncoding != null && !this.alternateEncoding.equals(this.fileAreaUpdate.getOptionalContent().getCharacterEncoding());
    }

    public IFileOptions getFileOptions() {
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get()});
        }
        return FileOptionsFactory.getFileOptions((boolean)false, (FileLineDelimiter)this.getLineDelimiter(), (String)this.getEncoding(), (Map)this.fileAreaUpdate.getMetadataProperties());
    }

    public void reset() {
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get()});
        }
        this.failure = null;
        this.contentTransferred = false;
        this.hash = null;
        this.contentSize = 0L;
    }

    public IShareableInternal getShareable() {
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get()});
        }
        return this.shareable;
    }

    public long getModificationStampToProcess() throws FileSystemException {
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get()});
        }
        if (!SKIP_MODIFICATION_STAMPS) {
            Date timestamp = this.getFileTimestamp();
            Date now = new Date();
            if (timestamp.getTime() != -1L && now.after(timestamp) && (this.getExistingShareableTimestamp() == null || timestamp.after(this.getExistingShareableTimestamp()))) {
                return timestamp.getTime();
            }
        }
        return -1L;
    }

    public void setContentDeleted() {
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get()});
        }
        this.contentDeleted = true;
    }

    public boolean contentDeleted() {
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get()});
        }
        return this.contentDeleted;
    }

    public void processModificationStamp() throws FileSystemException {
        if (this.debug) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{cls, new Mnm(){}.get()});
        }
        if (!this.getShareable().getFileStorage().exists(null)) {
            return;
        }
        if (!SKIP_MODIFICATION_STAMPS) {
            Date timestamp = this.getFileTimestamp();
            Date now = new Date();
            if (timestamp.getTime() != -1L && now.after(timestamp) && (this.getExistingShareableTimestamp() == null || timestamp.after(this.getExistingShareableTimestamp()))) {
                this.getShareable().getFileStorage().setLocalTimeStamp(timestamp.getTime(), null);
            }
        }
    }
}

