/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.scmee.common;

import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.DebugStack;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogField;
import com.ibm.team.build.extensions.common.debug.Mnm;
import com.ibm.team.enterprise.scmee.common.DeferredFileLoadInformation;
import com.ibm.team.enterprise.scmee.common.IThreadOwner;
import com.ibm.team.enterprise.scmee.common.LogUtility;
import com.ibm.team.enterprise.scmee.common.SCMEEStorageManager;
import com.ibm.team.enterprise.scmee.common.SCMEEUtils;
import com.ibm.team.enterprise.scmee.common.nls.SCMEEMessages;
import com.ibm.team.filesystem.client.FileDownloadHandler;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.IFileOptions;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.IShareableInternal;
import com.ibm.team.filesystem.client.internal.Shed;
import com.ibm.team.filesystem.client.internal.api.storage.FileOptionsFactory;
import com.ibm.team.filesystem.client.internal.content.DeletedContent;
import com.ibm.team.filesystem.client.operations.IDownloadListener;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.IFileContent;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.internal.repository.rcp.streams.DigestComputingInputStream;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.ContentHash;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractDownloadHandler
extends FileDownloadHandler {
    private static final String cls = AbstractDownloadHandler.class.getSimpleName();
    private static final Log LOG = LogFactory.getLog(AbstractDownloadHandler.class);
    private final IShareableInternal shareable;
    private final DeferredFileLoadInformation downloadInfo;
    private final boolean skipWrite;
    private final IDownloadListener downloadMonitor;
    private final Shed shed;
    private final IThreadOwner threadOwner;
    private final Map<String, String> additionalProperties;
    private final IDebugger dbg;
    private final boolean debug;
    private final boolean trace;

    public AbstractDownloadHandler(IShareableInternal shareable, DeferredFileLoadInformation downloadInfo, IDownloadListener downloadListener, boolean skipWrite, Shed shed) {
        this(shareable, downloadInfo, downloadListener, skipWrite, shed, null, null);
    }

    public AbstractDownloadHandler(IShareableInternal shareable, DeferredFileLoadInformation downloadInfo, IDownloadListener downloadListener, boolean skipWrite, Shed shed, IThreadOwner threadOwner) {
        this(shareable, downloadInfo, downloadListener, skipWrite, shed, threadOwner, null);
    }

    public AbstractDownloadHandler(IShareableInternal shareable, DeferredFileLoadInformation downloadInfo, IDownloadListener downloadListener, boolean skipWrite, Shed shed, Map<String, String> additionalProperties) {
        this(shareable, downloadInfo, downloadListener, skipWrite, shed, null, additionalProperties);
    }

    public AbstractDownloadHandler(IShareableInternal shareable, DeferredFileLoadInformation downloadInfo, IDownloadListener downloadListener, boolean skipWrite, Shed shed, IThreadOwner threadOwner, Map<String, String> additionalProperties) {
        this.shareable = shareable;
        this.downloadInfo = downloadInfo;
        this.skipWrite = skipWrite;
        this.downloadMonitor = downloadListener;
        this.shed = shed;
        this.threadOwner = threadOwner;
        this.additionalProperties = additionalProperties;
        this.dbg = SCMEEStorageManager.getCommonDbg();
        this.debug = this.dbg.isDebug();
        this.trace = this.dbg.isTrace();
        if (this.debug) {
            Debug.setup((IDebugger)this.dbg, (String[])new String[]{cls});
        }
        if (this.trace) {
            DebugStack.setup((IDebugger)this.dbg, (String)cls);
        }
    }

    public void downloadStreamAcquired(IFileItemHandle item, IFileContent content, InputStream in) throws TeamRepositoryException {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
        Exception downloadException = null;
        Throwable unswitchException = null;
        try {
            this.downloadInfo.reset();
            if (this.downloadMonitor != null) {
                this.downloadMonitor.downloadStarted(this.shareable.getSandbox().getRoot(), this.shareable.getLocalPath(), this.downloadInfo.getContent().getEstimatedConvertedLength());
            }
            boolean completed = false;
            try {
                DigestComputingInputStream inStream;
                block35: {
                    inStream = ContentHash.getDigestComputingStream((InputStream)in);
                    if (this.skipWrite) {
                        assert (this.skipWrite);
                        AbstractDownloadHandler.read((InputStream)inStream);
                    } else {
                        IFileOptions fileOptions;
                        boolean bAdd = this.additionalProperties != null && !this.additionalProperties.isEmpty();
                        long time = this.downloadInfo.getModificationStampToProcess();
                        if (bAdd || time != -1L) {
                            IFileOptions options = this.downloadInfo.getFileOptions();
                            Map properties = options.getProperties();
                            int size = 0;
                            if (bAdd) {
                                size += this.additionalProperties.size();
                            }
                            if (time != -1L) {
                                ++size;
                            }
                            HashMap<String, String> enhancedProperties = new HashMap<String, String>(properties.size() + size);
                            enhancedProperties.putAll(properties);
                            if (bAdd) {
                                for (Map.Entry<String, String> entry : this.additionalProperties.entrySet()) {
                                    enhancedProperties.put(entry.getKey(), entry.getValue());
                                }
                            }
                            if (time != -1L) {
                                enhancedProperties.put("PrivateZOSProp_Timestamp", Long.toString(time, 10));
                            }
                            fileOptions = FileOptionsFactory.getFileOptions((boolean)false, (FileLineDelimiter)options.getLineDelimiter(), (String)options.getCharacterEncoding(), enhancedProperties);
                        } else {
                            fileOptions = this.downloadInfo.getFileOptions();
                        }
                        try {
                            try {
                                this.switchAuth(this.threadOwner);
                                if (!this.downloadInfo.getShareable().getFileStorage().exists(null)) {
                                    this.downloadInfo.getShareable().getFileStorage().create(fileOptions, (InputStream)inStream, null);
                                } else {
                                    this.downloadInfo.getShareable().getFileStorage().setContents(fileOptions, (InputStream)inStream, this.shed, null);
                                }
                            }
                            catch (Exception e) {
                                downloadException = e;
                                try {
                                    this.unSwitchAuth(this.threadOwner);
                                }
                                catch (Exception e2) {
                                    unswitchException = e2;
                                }
                                break block35;
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                this.unSwitchAuth(this.threadOwner);
                            }
                            catch (Exception e) {
                                unswitchException = e;
                            }
                            throw throwable;
                        }
                        try {
                            this.unSwitchAuth(this.threadOwner);
                        }
                        catch (Exception e) {
                            unswitchException = e;
                        }
                    }
                }
                if (downloadException == null) {
                    this.downloadInfo.setContentUpdated(ContentHash.valueOf((byte[])inStream.getFinalDigest()), inStream.getContentSize());
                    completed = true;
                }
            }
            finally {
                if (!completed && !this.skipWrite) {
                    IFileStorage victim = this.shareable.getFileStorage();
                    victim.delete(this.shed, null);
                }
            }
        }
        catch (Exception e) {
            downloadException = e;
        }
        if (unswitchException != null) {
            String errorMessage = NLS.bind((String)SCMEEMessages.DownloadHandler_0, (Object)this.shareable.getFullPath().toString(), (Object[])new Object[]{unswitchException.getMessage()});
            LogUtility.logError(LOG, (Exception)unswitchException, errorMessage);
        }
        if (downloadException != null) {
            String errorMessage = downloadException instanceof FileSystemException ? NLS.bind((String)SCMEEMessages.DownloadHandler_1, (Object)this.getFullName(item), (Object[])new Object[]{downloadException.getMessage()}) : NLS.bind((String)SCMEEMessages.DownloadHandler_0, (Object)this.shareable.getFullPath().toString(), (Object[])new Object[]{downloadException.getMessage()});
            LogUtility.logError(LOG, downloadException, errorMessage);
            throw new TeamRepositoryException(errorMessage, (Throwable)downloadException);
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
    }

    public void downloadFailed(IFileItemHandle item, IFileContent content, Exception e) {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
        this.downloadInfo.setFailure(e);
        if (DeletedContent.isRootCauseDeletedContent((Throwable)e)) {
            InputStream in = DeletedContent.getDeletedContentInputStream((String)this.downloadInfo.getEncoding());
            try {
                this.downloadStreamAcquired(item, content, in);
                this.downloadInfo.setContentUpdated(content.getHash(), content.getRawLength());
                this.downloadInfo.setContentDeleted();
            }
            catch (TeamRepositoryException e2) {
                this.downloadInfo.setFailure(e);
            }
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
    }

    private static void read(InputStream in) throws IOException {
        byte[] b = new byte[16000];
        try {
            while (in.read(b) != -1) {
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    private String getFullName(IFileItemHandle fileItem) {
        String mnm;
        String string = mnm = this.dbg.isOn() ? new Mnm(){}.get() : null;
        if (this.debug) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{cls, mnm});
        }
        String fullName = null;
        try {
            IComponentHandle component = this.downloadInfo.getFileAreaUpdate().getComponent();
            ITeamRepository repository = (ITeamRepository)component.getOrigin();
            IWorkspaceHandle workspace = (IWorkspaceHandle)this.downloadInfo.getSharingDescriptor().getConnectionHandle();
            IWorkspaceConnection wsConnection = SCMPlatform.getWorkspaceManager((ITeamRepository)repository).getWorkspaceConnection(workspace, null);
            fullName = SCMEEUtils.getFileFullPath(wsConnection, component, fileItem, null);
        }
        catch (Exception e) {
            LogUtility.logInfo(LOG, e, e.getMessage());
        }
        if (this.debug) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{cls, mnm, LogField.valueOf((String)fullName)});
        }
        return fullName;
    }

    public abstract void switchAuth(IThreadOwner var1) throws Exception;

    public abstract void unSwitchAuth(IThreadOwner var1) throws Exception;
}

