/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.scd.ide.ui.wizard;

import com.ibm.team.enterprise.scd.common.ScdCommonUtil;
import com.ibm.team.enterprise.scd.common.model.IComponentEntry;
import com.ibm.team.enterprise.scd.common.model.IScanConfiguration;
import com.ibm.team.enterprise.scd.common.model.IScanRequest;
import com.ibm.team.enterprise.scd.common.model.ScanScope;
import com.ibm.team.enterprise.scd.common.model.ScanType;
import com.ibm.team.enterprise.scd.ide.ui.Activator;
import com.ibm.team.enterprise.scd.ide.ui.wizard.RequestScanOverrideSettingsWizardPage;
import com.ibm.team.enterprise.scd.ide.ui.wizard.RequestScanTypeWizardPage;
import com.ibm.team.enterprise.scd.internal.common.model.ComponentEntry;
import com.ibm.team.enterprise.scd.internal.common.model.ScdFactory;
import com.ibm.team.enterprise.scd.internal.ide.ui.nls.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IWorkspace;
import java.util.List;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.Wizard;

public class RequestScanWizard
extends Wizard
implements IWizard {
    private IScanConfiguration scanConfiguration;
    private IWorkspace stream;
    private IScanRequest scanRequest;
    private RequestScanTypeWizardPage page1;
    private RequestScanOverrideSettingsWizardPage page2;

    public RequestScanWizard(IScanConfiguration scanConfiguration, IWorkspace stream) {
        this.setWindowTitle(Messages.RequestScanWizard_TITLE);
        this.setDefaultPageImageDescriptor(Activator.getImageDescriptor("icons/obj16/requestScanWiz.jpg"));
        this.scanConfiguration = scanConfiguration;
        this.stream = stream;
    }

    public boolean performFinish() {
        ScanType scanType = this.page1.getScanType();
        ScanScope scanScope = this.page1.getScanScope();
        List<UUID> scanList = this.page1.getScanList();
        long maxWaitTime = this.page2.getMaxWaitTime();
        boolean isContinueOnError = this.page2.isContinueOnError();
        List<IComponentEntry> excludedComponents = this.page2.getExcludedComponents();
        String scanArguments = this.page2.getScanArguments();
        ITeamRepository repository = (ITeamRepository)this.scanConfiguration.getOrigin();
        this.scanRequest = ScdCommonUtil.createDefaultScanRequest((IScanConfiguration)this.scanConfiguration, (IAuditableHandle)repository.loggedInContributor(), (ScanType)scanType, (ScanScope)scanScope);
        this.scanRequest.setMaxWaitTimeToScan(maxWaitTime);
        this.scanRequest.setContinueOnError(isContinueOnError);
        this.scanRequest.getComponents().clear();
        for (IComponentEntry excludedComponent : excludedComponents) {
            ComponentEntry tempComponent = ScdFactory.eINSTANCE.createComponentEntry();
            tempComponent.setComponent(excludedComponent.getComponent());
            this.scanRequest.getComponents().add(tempComponent);
        }
        if (this.scanRequest.getScope() == ScanScope.LANGDEF || this.scanRequest.getScope() == ScanScope.COMPONENT) {
            this.scanRequest.getScanList().addAll(scanList);
        }
        this.scanRequest.setScanArguments(scanArguments);
        return true;
    }

    public void addPages() {
        this.page1 = new RequestScanTypeWizardPage(this);
        this.addPage(this.page1);
        this.page2 = new RequestScanOverrideSettingsWizardPage(this);
        this.addPage(this.page2);
    }

    public IScanConfiguration getScanConfiguration() {
        return this.scanConfiguration;
    }

    public IWorkspace getStream() {
        return this.stream;
    }

    public RequestScanTypeWizardPage getPage1() {
        return this.page1;
    }

    public IScanRequest getScanRequest() {
        return this.scanRequest;
    }
}

