/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.scd.ide.ui.wizard;

import com.ibm.team.enterprise.scd.common.model.IScanConfiguration;
import com.ibm.team.enterprise.scd.common.model.ScanScope;
import com.ibm.team.enterprise.scd.common.model.ScanType;
import com.ibm.team.enterprise.scd.ide.ui.ScdUIUtil;
import com.ibm.team.enterprise.scd.ide.ui.wizard.RequestScanWizard;
import com.ibm.team.enterprise.scd.internal.ide.ui.nls.Messages;
import com.ibm.team.enterprise.systemdefinition.common.model.ILanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.util.ItemHandleAwareHashSet;
import com.ibm.team.enterprise.systemdefinition.ui.dialogs.LanguageDefinitionSelectionDialog;
import com.ibm.team.jface.labelProviders.BaseLabelProvider;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListSelectionDialog;

public class RequestScanTypeWizardPage
extends WizardPage
implements IWizardPage {
    private Button streamRadio;
    private Button componentRadio;
    private Button ldRadio;
    private Button updateScanButton;
    private Label partListLabel;
    private ListViewer partListViewer;
    private Button addPartButton;
    private Button removePartButton;
    private ItemHandleAwareHashSet<ISystemDefinition> ldList;
    private ItemHandleAwareHashSet<IComponentHandle> componentList;
    private Map<UUID, String> componentNames;

    public RequestScanTypeWizardPage(RequestScanWizard wizard) {
        super(RequestScanTypeWizardPage.class.getName(), Messages.RequestScanWizard_TITLE, null);
        this.setDescription(NLS.bind((String)Messages.RequestScanTypeWizardPage_DESC, (Object)wizard.getStream().getName()));
        this.ldList = new ItemHandleAwareHashSet();
        this.componentList = new ItemHandleAwareHashSet();
        this.componentNames = new HashMap<UUID, String>();
    }

    public void performHelp() {
        PlatformUI.getWorkbench().getHelpSystem().displayHelp("com.ibm.team.build.ui.request_scan_scd_wizard");
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        Composite typeComposite = new Composite(composite, 0);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).indent(15, 1).applyTo((Control)typeComposite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(typeComposite);
        this.streamRadio = new Button(typeComposite, 16);
        this.streamRadio.setText(Messages.RequestScanTypeWizardPage_SCAN_SCOPE_STREAM);
        this.streamRadio.setSelection(true);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.streamRadio);
        this.streamRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (RequestScanTypeWizardPage.this.streamRadio.getSelection()) {
                    RequestScanTypeWizardPage.this.partListLabel.setVisible(false);
                    RequestScanTypeWizardPage.this.updatePartListFields();
                    RequestScanTypeWizardPage.this.updatePartList();
                    RequestScanTypeWizardPage.this.validate();
                }
            }
        });
        this.componentRadio = new Button(typeComposite, 16);
        this.componentRadio.setText(Messages.RequestScanTypeWizardPage_SCAN_SCOPE_COMPONENT);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.componentRadio);
        this.componentRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (RequestScanTypeWizardPage.this.componentRadio.getSelection()) {
                    RequestScanTypeWizardPage.this.partListLabel.setVisible(true);
                    RequestScanTypeWizardPage.this.partListLabel.setText(Messages.RequestScanTypeWizardPage_COMPONENT_LIST_LABEL);
                    RequestScanTypeWizardPage.this.updatePartList();
                    RequestScanTypeWizardPage.this.updatePartListFields();
                    RequestScanTypeWizardPage.this.validate();
                }
            }
        });
        this.ldRadio = new Button(typeComposite, 16);
        this.ldRadio.setText(Messages.RequestScanTypeWizardPage_SCAN_SCOPE_LANGUAGE_DEFINITION);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.ldRadio);
        this.ldRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (RequestScanTypeWizardPage.this.ldRadio.getSelection()) {
                    RequestScanTypeWizardPage.this.partListLabel.setVisible(true);
                    RequestScanTypeWizardPage.this.partListLabel.setText(Messages.RequestScanTypeWizardPage_LANGUAGE_DEFINITION_LIST_LABEL);
                    RequestScanTypeWizardPage.this.updatePartList();
                    RequestScanTypeWizardPage.this.updatePartListFields();
                    RequestScanTypeWizardPage.this.validate();
                }
            }
        });
        this.updateScanButton = new Button(typeComposite, 32);
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)this.updateScanButton);
        this.updateScanButton.setText(Messages.RequestScanTypeWizardPage_SCAN_TYPE_UPDATE);
        this.updateScanButton.setSelection(true);
        this.partListLabel = new Label(typeComposite, 16384);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.partListLabel);
        this.partListViewer = new ListViewer(typeComposite, 2816);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.partListViewer.getList());
        this.partListViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.partListViewer.setLabelProvider((IBaseLabelProvider)new BaseLabelProvider(){

            public void updateLabel(ViewerLabel label, Object element) {
                if (element instanceof ISystemDefinition) {
                    label.setText(((ISystemDefinition)element).getName());
                } else if (element instanceof IComponentHandle) {
                    label.setText((String)RequestScanTypeWizardPage.this.componentNames.get(((IComponentHandle)element).getItemId()));
                }
            }
        });
        this.partListViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                String e1Name = "";
                String e2Name = "";
                if (e1 instanceof ISystemDefinition && e2 instanceof ISystemDefinition) {
                    e1Name = ((ISystemDefinition)e1).getName();
                    e2Name = ((ISystemDefinition)e2).getName();
                } else if (e1 instanceof IComponentHandle && e2 instanceof IComponentHandle) {
                    e1Name = (String)RequestScanTypeWizardPage.this.componentNames.get(((IComponentHandle)e1).getItemId());
                    e2Name = (String)RequestScanTypeWizardPage.this.componentNames.get(((IComponentHandle)e2).getItemId());
                }
                return e1Name.compareTo(e2Name);
            }
        });
        this.partListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                RequestScanTypeWizardPage.this.updatePartListFields();
            }
        });
        this.partListViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof ISystemDefinitionHandle) {
                    ISystemDefinition ld = (ISystemDefinition)element;
                    return RequestScanTypeWizardPage.this.partListViewer.getData(ld.getItemId().getUuidValue()) == null;
                }
                if (element instanceof IComponentHandle) {
                    IComponentHandle component = (IComponentHandle)element;
                    return RequestScanTypeWizardPage.this.partListViewer.getData(component.getItemId().getUuidValue()) == null;
                }
                return false;
            }
        });
        Composite buttonComposite = new Composite(typeComposite, 0);
        buttonComposite.setLayout((Layout)new FillLayout(512));
        this.addPartButton = new Button(buttonComposite, 8);
        this.addPartButton.setText(Messages.ScanConfigurationsOverviewEditorPage_ADD_LABEL);
        this.addPartButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ITeamRepository repository = (ITeamRepository)RequestScanTypeWizardPage.this.getWizard().getScanConfiguration().getOrigin();
                if (RequestScanTypeWizardPage.this.ldRadio.getSelection()) {
                    ViewerFilter viewerFilter = new ViewerFilter(){

                        public boolean select(Viewer viewer, Object parentElement, Object element) {
                            return !(element instanceof ISystemDefinitionHandle) || !RequestScanTypeWizardPage.this.isInList((ISystemDefinitionHandle)element);
                        }
                    };
                    LanguageDefinitionSelectionDialog dialog = new LanguageDefinitionSelectionDialog(RequestScanTypeWizardPage.this.addPartButton.getShell(), repository, null, viewerFilter, true, ILanguageDefinition.ITEM_TYPE);
                    if (dialog.open() == 0) {
                        Object[] objs;
                        Object[] objectArray = objs = dialog.getSelectedSystemDefinitions();
                        int n = objs.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object obj = objectArray[n2];
                            ISystemDefinition ld = (ISystemDefinition)obj;
                            if (!RequestScanTypeWizardPage.this.ldList.contains((Object)ld)) {
                                RequestScanTypeWizardPage.this.ldList.add((Object)ld);
                            }
                            ++n2;
                        }
                        RequestScanTypeWizardPage.this.updatePartList();
                        RequestScanTypeWizardPage.this.validate();
                    }
                } else if (RequestScanTypeWizardPage.this.componentRadio.getSelection()) {
                    Object[] objs;
                    IScanConfiguration scanConfiguration = RequestScanTypeWizardPage.this.getWizard().getScanConfiguration();
                    IWorkspaceHandle streamHandle = scanConfiguration.getStream();
                    ListSelectionDialog selectionDialog = ScdUIUtil.getComponentSelectionDialog(RequestScanTypeWizardPage.this.addPartButton.getShell(), repository, streamHandle, Messages.RequestScanTypeWizardPage_COMPONENT_SELECTION_TITLE, Messages.RequestScanTypeWizardPage_COMPONENT_SELECTION_DESCRIPTION, new ArrayList<IComponentHandle>((Collection<IComponentHandle>)RequestScanTypeWizardPage.this.componentList));
                    if (selectionDialog.open() == 0 && (objs = selectionDialog.getResult()) != null) {
                        Object[] objectArray = objs;
                        int n = objs.length;
                        int n3 = 0;
                        while (n3 < n) {
                            Object obj = objectArray[n3];
                            IComponent component = (IComponent)obj;
                            if (!RequestScanTypeWizardPage.this.componentList.contains((Object)component)) {
                                RequestScanTypeWizardPage.this.componentList.add((Object)component);
                                RequestScanTypeWizardPage.this.componentNames.put(component.getItemId(), component.getName());
                            }
                            ++n3;
                        }
                        RequestScanTypeWizardPage.this.updatePartList();
                        RequestScanTypeWizardPage.this.validate();
                    }
                }
            }
        });
        this.removePartButton = new Button(buttonComposite, 8);
        this.removePartButton.setText(Messages.ScanConfigurationsOverviewEditorPage_REMOVE_LABEL);
        this.removePartButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IStructuredSelection selection = (IStructuredSelection)RequestScanTypeWizardPage.this.partListViewer.getSelection();
                if (!selection.isEmpty()) {
                    Object[] objectArray = selection.toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        UUID uuid;
                        Object obj = objectArray[n2];
                        if (obj instanceof ISystemDefinition) {
                            uuid = ((ISystemDefinition)obj).getItemId();
                            for (ISystemDefinition ld : RequestScanTypeWizardPage.this.ldList) {
                                if (!uuid.equals((Object)ld.getItemId())) continue;
                                RequestScanTypeWizardPage.this.ldList.remove((Object)ld);
                            }
                        } else if (obj instanceof IComponentHandle) {
                            uuid = ((IComponentHandle)obj).getItemId();
                            for (IComponentHandle component : RequestScanTypeWizardPage.this.componentList) {
                                if (!uuid.equals((Object)component.getItemId())) continue;
                                RequestScanTypeWizardPage.this.componentList.remove((Object)component);
                            }
                        }
                        ++n2;
                    }
                }
                RequestScanTypeWizardPage.this.updatePartList();
                RequestScanTypeWizardPage.this.validate();
            }
        });
        this.updatePartListFields();
        this.updatePartList();
        this.setControl((Control)composite);
    }

    private void updatePartListFields() {
        if (this.ldRadio != null && !this.ldRadio.isDisposed() && this.componentRadio != null && !this.componentRadio.isDisposed()) {
            this.partListViewer.getList().setVisible(this.ldRadio.getSelection() || this.componentRadio.getSelection());
            this.addPartButton.setVisible(this.ldRadio.getSelection() || this.componentRadio.getSelection());
            this.removePartButton.setVisible(this.ldRadio.getSelection() || this.componentRadio.getSelection());
            this.removePartButton.setEnabled((this.ldRadio.getSelection() || this.componentRadio.getSelection()) && !((IStructuredSelection)this.partListViewer.getSelection()).isEmpty());
        }
    }

    private void updatePartList() {
        this.partListViewer.getList().removeAll();
        if (this.ldRadio.getSelection()) {
            for (ISystemDefinitionHandle ld : this.ldList) {
                this.partListViewer.add((Object)ld);
                this.partListViewer.setData(ld.getItemId().getUuidValue(), (Object)ld);
            }
        } else if (this.componentRadio.getSelection()) {
            for (IComponentHandle component : this.componentList) {
                this.partListViewer.add((Object)component);
                this.partListViewer.setData(component.getItemId().getUuidValue(), (Object)component);
            }
        }
        this.partListViewer.resetFilters();
    }

    protected ScanType getScanType() {
        if (this.updateScanButton.getSelection()) {
            return ScanType.UPDATE;
        }
        return ScanType.RESET;
    }

    protected ScanScope getScanScope() {
        if (this.ldRadio.getSelection()) {
            return ScanScope.LANGDEF;
        }
        if (this.componentRadio.getSelection()) {
            return ScanScope.COMPONENT;
        }
        return ScanScope.STREAM;
    }

    protected List<UUID> getScanList() {
        ArrayList<UUID> uuids;
        block3: {
            block2: {
                uuids = new ArrayList<UUID>();
                if (!this.ldRadio.getSelection()) break block2;
                for (ISystemDefinitionHandle ld : this.ldList) {
                    uuids.add(ld.getItemId());
                }
                break block3;
            }
            if (!this.componentRadio.getSelection()) break block3;
            for (IComponentHandle component : this.componentList) {
                uuids.add(component.getItemId());
            }
        }
        return uuids;
    }

    public RequestScanWizard getWizard() {
        return (RequestScanWizard)super.getWizard();
    }

    private boolean isInList(ISystemDefinitionHandle aSystemDefinition) {
        if (this.ldList != null && aSystemDefinition != null && aSystemDefinition.getItemId() != null) {
            for (ISystemDefinitionHandle systemDefinition : this.ldList) {
                if (!aSystemDefinition.getItemId().equals((Object)systemDefinition.getItemId())) continue;
                return true;
            }
        }
        return false;
    }

    protected void validate() {
        if ((this.componentRadio.getSelection() || this.ldRadio.getSelection()) && this.partListViewer.getList().getItemCount() == 0) {
            if (this.componentRadio.getSelection()) {
                this.setErrorMessage(Messages.RequestScanTypeWizardPage_ERROR_NO_COMPONENT_SELECTED);
            } else {
                this.setErrorMessage(Messages.RequestScanTypeWizardPage_ERROR_NO_LANGUAGE_DEFINITION_SELECTED);
            }
            this.setPageComplete(false);
        } else {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        }
    }
}

