/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.scd.ide.ui.wizard;

import com.ibm.team.enterprise.scd.common.model.IComponentEntry;
import com.ibm.team.enterprise.scd.common.model.ScanType;
import com.ibm.team.enterprise.scd.ide.ui.ScdUIUtil;
import com.ibm.team.enterprise.scd.ide.ui.helper.ComponentListComposite;
import com.ibm.team.enterprise.scd.ide.ui.wizard.RequestScanWizard;
import com.ibm.team.enterprise.scd.internal.ide.ui.nls.Messages;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class RequestScanOverrideSettingsWizardPage
extends WizardPage
implements IWizardPage {
    private Text maxWaitTimeTextField;
    private Button continueOnErrorCheckbox;
    private ComponentListComposite excludedComponentListViewer;
    private Text scanArgumentField;

    public RequestScanOverrideSettingsWizardPage(RequestScanWizard wizard) {
        super(RequestScanOverrideSettingsWizardPage.class.getName(), Messages.RequestScanOverrideSettingsWizardPage_TITLE, null);
        this.setDescription(NLS.bind((String)Messages.RequestScanOverrideSettingsWizardPage_DESC, (Object)wizard.getStream().getName()));
    }

    public void performHelp() {
        PlatformUI.getWorkbench().getHelpSystem().displayHelp("com.ibm.team.build.ui.request_scan_scd_wizard");
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        Label label = new Label(composite, 16384);
        GridDataFactory.fillDefaults().applyTo((Control)label);
        label.setText(Messages.RequestScanOverrideSettingsWizardPage_MAX_WAIT_TIME_LABEL);
        this.maxWaitTimeTextField = new Text(composite, 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.maxWaitTimeTextField);
        this.maxWaitTimeTextField.setText(String.valueOf(this.getWizard().getScanConfiguration().getMaxWaitTimeToScan()));
        this.maxWaitTimeTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IStatus status = ScdUIUtil.maxWaitTimeValidator.validate((Object)RequestScanOverrideSettingsWizardPage.this.maxWaitTimeTextField.getText());
                if (status.isOK()) {
                    RequestScanOverrideSettingsWizardPage.this.setErrorMessage(null);
                    if (!RequestScanOverrideSettingsWizardPage.this.isPageComplete()) {
                        RequestScanOverrideSettingsWizardPage.this.setPageComplete(true);
                    }
                } else {
                    RequestScanOverrideSettingsWizardPage.this.setErrorMessage(NLS.bind((String)Messages.RequestScanOverrideSettingsWizardPage_MAX_WAIT_TIME_ERROR, (Object)status.getMessage()));
                    RequestScanOverrideSettingsWizardPage.this.setPageComplete(false);
                }
            }
        });
        this.continueOnErrorCheckbox = new Button(composite, 32);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.continueOnErrorCheckbox);
        this.continueOnErrorCheckbox.setText(Messages.RequestScanOverrideSettingsWizardPage_CONTINUE_ON_ERROR_LABEL);
        this.continueOnErrorCheckbox.setSelection(this.getWizard().getScanConfiguration().isContinueOnError());
        this.excludedComponentListViewer = new ComponentListComposite(composite, Messages.ScanConfigurationsOverviewEditorPage_EXCLUDED_COMPONENT_LABEL, Messages.ScanConfigurationsOverviewEditorPage_EXCLUDED_COMPONENT_DESC, null);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)this.excludedComponentListViewer.getComposite());
        this.excludedComponentListViewer.setInput(this.getWizard().getScanConfiguration());
        Label advancedLabel = new Label(composite, 0);
        advancedLabel.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)advancedLabel);
        advancedLabel.setText(Messages.ScanConfigurationsOverviewEditorPage_ADVANCED_SECTION_TITLE);
        Composite advancedComposite = new Composite(composite, 0);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, true).indent(15, -1).applyTo((Control)advancedComposite);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(0, 0).applyTo(advancedComposite);
        Label scanArgumentLabel = new Label(advancedComposite, 0);
        GridDataFactory.fillDefaults().indent(15, -1).applyTo((Control)scanArgumentLabel);
        scanArgumentLabel.setText(Messages.ScanConfigurationsOverviewEditorPage_SCAN_ARGUMENTS_LABEL);
        this.scanArgumentField = new Text(advancedComposite, 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.scanArgumentField);
        this.scanArgumentField.setText(this.getWizard().getScanConfiguration().getScanArguments() == null ? "" : this.getWizard().getScanConfiguration().getScanArguments());
        this.setControl((Control)composite);
    }

    protected long getMaxWaitTime() {
        return Long.parseLong(this.maxWaitTimeTextField.getText().trim());
    }

    protected boolean isContinueOnError() {
        return this.continueOnErrorCheckbox.getSelection();
    }

    protected List<IComponentEntry> getExcludedComponents() {
        return this.excludedComponentListViewer.getComponents();
    }

    protected String getScanArguments() {
        return this.scanArgumentField.getText();
    }

    public RequestScanWizard getWizard() {
        return (RequestScanWizard)super.getWizard();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.excludedComponentListViewer.setReadOnly(this.getWizard().getPage1().getScanType() == ScanType.UPDATE);
    }
}

