/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.scd.ide.ui.view;

import com.ibm.team.enterprise.scd.common.model.IScanResult;
import com.ibm.team.enterprise.scd.ide.ui.ScdUIUtil;
import com.ibm.team.enterprise.scd.ide.ui.view.ScanQueryColumn;
import com.ibm.team.enterprise.scd.ide.ui.view.ScanQueryRow;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class ScanQueryViewerComparator
extends ViewerComparator {
    public int compare(Viewer viewer, Object e1, Object e2) {
        int cat2;
        if (viewer == null || e1 == null || e2 == null) {
            return 0;
        }
        Table table = (Table)viewer.getControl();
        TableColumn sortColumn = table.getSortColumn();
        ScanQueryColumn column = this.getScanQueryColumn(sortColumn);
        if (column == null) {
            return 0;
        }
        ScanQueryRow row1 = (ScanQueryRow)e1;
        ScanQueryRow row2 = (ScanQueryRow)e2;
        int cat1 = this.category(e1);
        if (cat1 != (cat2 = this.category(e2))) {
            return cat1 - cat2;
        }
        String value1 = row1.getColumnValue(column);
        String value2 = row2.getColumnValue(column);
        int sortDirection = ScdUIUtil.getSortDirection(table);
        int comparedValue = value1.compareTo(value2);
        return sortDirection == 128 ? comparedValue : comparedValue * -1;
    }

    public int category(Object element) {
        IScanResult scanResult;
        if (element instanceof ScanQueryRow && (scanResult = ((ScanQueryRow)element).getScanResult()).getScanStartTime() <= 0L) {
            return 0;
        }
        return 1;
    }

    public boolean isSorterProperty(Object element, String property) {
        return true;
    }

    public ScanQueryColumn getScanQueryColumn(TableColumn tableColumn) {
        if (tableColumn == null) {
            return ScanQueryColumn.START_TIME_COLUMN;
        }
        ScanQueryColumn[] scanQueryColumnArray = ScanQueryColumn.COLUMNs;
        int n = ScanQueryColumn.COLUMNs.length;
        int n2 = 0;
        while (n2 < n) {
            ScanQueryColumn scanQueryColumn = scanQueryColumnArray[n2];
            if (scanQueryColumn == tableColumn.getData()) {
                return scanQueryColumn;
            }
            ++n2;
        }
        return null;
    }
}

