/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.scd.ide.ui.view;

import com.ibm.team.enterprise.scd.common.model.IScanConfiguration;
import com.ibm.team.enterprise.scd.common.model.IScanConfigurationHandle;
import com.ibm.team.enterprise.scd.ide.ui.Activator;
import com.ibm.team.enterprise.scd.ide.ui.ScdUIUtil;
import com.ibm.team.enterprise.scd.ide.ui.action.OpenScanResultAction;
import com.ibm.team.enterprise.scd.ide.ui.action.RunScanQueryAction;
import com.ibm.team.enterprise.scd.ide.ui.helper.ScanQueryTooltipSupport;
import com.ibm.team.enterprise.scd.ide.ui.view.ScanQuery;
import com.ibm.team.enterprise.scd.ide.ui.view.ScanQueryColumn;
import com.ibm.team.enterprise.scd.ide.ui.view.ScanQueryContentProvider;
import com.ibm.team.enterprise.scd.ide.ui.view.ScanQueryLabelProvider;
import com.ibm.team.enterprise.scd.ide.ui.view.ScanQueryRow;
import com.ibm.team.enterprise.scd.ide.ui.view.ScanQueryViewerComparator;
import com.ibm.team.enterprise.scd.internal.ide.ui.nls.Messages;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.scm.common.IWorkspace;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.ViewPart;

public class ScanQueryView
extends ViewPart {
    public static final String VIEW_ID = "com.ibm.team.enterprise.scd.ide.ui.view.ScanQueryView";
    private Label resultLabel;
    private Table table;
    private TableViewer tableViewer;
    private OpenScanResultAction openAction;
    private Action rerunQueryAction;

    public void createPartControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(composite);
        this.resultLabel = new Label(composite, 16384);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.resultLabel);
        int style = 101122;
        this.table = new Table(composite, style);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.table);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.setContentProvider((IContentProvider)new ScanQueryContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ScanQueryLabelProvider(this.table));
        this.tableViewer.setComparator((ViewerComparator)new ScanQueryViewerComparator());
        ScanQueryColumn[] scanQueryColumnArray = ScanQueryColumn.COLUMNs;
        int n = ScanQueryColumn.COLUMNs.length;
        int n2 = 0;
        while (n2 < n) {
            ScanQueryColumn scanQueryColumn = scanQueryColumnArray[n2];
            final TableColumn tableColumn = new TableColumn(this.table, 16384);
            tableColumn.setData((Object)scanQueryColumn);
            tableColumn.setText(scanQueryColumn.getColumnName());
            tableColumn.setWidth(scanQueryColumn.getDefaultColumnWidth());
            tableColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int newSortDirection = ScdUIUtil.getSortDirection(ScanQueryView.this.table) == 128 ? 1024 : 128;
                    ScanQueryView.this.table.setSortDirection(newSortDirection);
                    ScanQueryView.this.table.setSortColumn(tableColumn);
                    ScanQueryView.this.tableViewer.refresh();
                }
            });
            ++n2;
        }
        new ScanQueryTooltipSupport(this.table);
        this.rerunQueryAction = new RunScanQueryAction(this){

            @Override
            protected ScanQuery getScanQuery() {
                if (ScanQueryView.this.tableViewer.getInput() == null) {
                    return null;
                }
                return (ScanQuery)ScanQueryView.this.tableViewer.getInput();
            }
        };
        this.rerunQueryAction.setImageDescriptor(Activator.getImageDescriptor("icons/elcl16/refresh.gif"));
        this.addToolbarMenu();
        this.createContextMenu();
        this.enableOpenResults();
        parent.layout(true);
    }

    public void setInput(Object input) {
        this.tableViewer.setInput(input);
        this.refresh();
    }

    public void refresh() {
        this.resultLabel.setText(this.getResultLabel());
        this.tableViewer.refresh();
    }

    private String getResultLabel() {
        if (this.tableViewer.getInput() == null || !(this.tableViewer.getInput() instanceof ScanQuery)) {
            return "";
        }
        ScanQuery scanQuery = (ScanQuery)this.tableViewer.getInput();
        int results = 0;
        if (scanQuery.getResult() != null) {
            results = scanQuery.getResult().getScanQueryRows().size();
        }
        return NLS.bind((String)Messages.ScanResultsView_SCAN_QUERY_RESULT_LABEL, (Object)scanQuery.getLabel(), (Object)results);
    }

    public void setFocus() {
        if (this.table != null && !this.table.isDisposed()) {
            this.table.setFocus();
        }
    }

    private void addToolbarMenu() {
        IToolBarManager toolbarMgr = this.getViewSite().getActionBars().getToolBarManager();
        toolbarMgr.add((IAction)this.rerunQueryAction);
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)this.rerunQueryAction);
        this.getViewSite().getActionBars().updateActionBars();
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IContributionItem)new Separator("open"));
                manager.add((IContributionItem)new Separator("additions"));
            }
        });
        Menu menu = menuMgr.createContextMenu(this.tableViewer.getControl());
        this.tableViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.tableViewer);
    }

    private void enableOpenResults() {
        this.openAction = new OpenScanResultAction();
        this.openAction.init(this.getViewSite().getPage());
        this.tableViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                IStructuredSelection selection = (IStructuredSelection)ScanQueryView.this.tableViewer.getSelection();
                if (!selection.isEmpty()) {
                    StructuredSelection ssel = new StructuredSelection((Object)((ScanQueryRow)selection.getFirstElement()).getScanResult());
                    ScanQueryView.this.openAction.selectionChanged(null, (ISelection)ssel);
                    ScanQueryView.this.openAction.run(null);
                }
            }
        });
    }

    public void rerunQuery() {
        if (this.rerunQueryAction != null) {
            this.rerunQueryAction.run();
        }
    }

    public static void openQueryView(IScanConfiguration scanConfiguration, IWorkspace stream) {
        ScanQueryView view = ScanQueryView.findScanQueryView();
        if (view == null) {
            return;
        }
        final ScanQuery scanQuery = new ScanQuery((ITeamRepository)scanConfiguration.getOrigin(), stream.getName(), (IScanConfigurationHandle)scanConfiguration);
        view.setInput(scanQuery);
        RunScanQueryAction action = new RunScanQueryAction(view){

            @Override
            protected ScanQuery getScanQuery() {
                return scanQuery;
            }
        };
        action.run();
    }

    public static void openQueryView(List<IScanConfigurationHandle> scanConfigurations, IProjectArea projectArea) {
        ScanQueryView view = ScanQueryView.findScanQueryView();
        if (view == null) {
            return;
        }
        final ScanQuery scanQuery = new ScanQuery((ITeamRepository)projectArea.getOrigin(), projectArea.getName());
        for (IScanConfigurationHandle scanConfiguration : scanConfigurations) {
            scanQuery.addScanConfigurations(scanConfiguration);
        }
        RunScanQueryAction action = new RunScanQueryAction(view){

            @Override
            protected ScanQuery getScanQuery() {
                return scanQuery;
            }
        };
        action.run();
    }

    private static ScanQueryView findScanQueryView() {
        ScanQueryView view = null;
        try {
            view = (ScanQueryView)Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(VIEW_ID);
        }
        catch (PartInitException e) {
            Activator.log((Exception)((Object)e));
        }
        return view;
    }
}

