/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.scd.ide.ui.view;

import com.ibm.team.enterprise.scd.common.ScdCommonUtil;
import com.ibm.team.enterprise.scd.common.model.IScanRequest;
import com.ibm.team.enterprise.scd.common.model.IScanResult;
import com.ibm.team.enterprise.scd.common.model.IScanSummary;
import com.ibm.team.enterprise.scd.common.model.ScanState;
import com.ibm.team.enterprise.scd.ide.ui.ScdUIUtil;
import com.ibm.team.enterprise.scd.ide.ui.view.ScanQueryColumn;
import com.ibm.team.enterprise.scd.internal.ide.ui.nls.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IActionFilter;

public class ScanQueryRow
implements IActionFilter {
    protected IScanResult scanResult;
    protected IWorkspace stream;
    protected IAuditable requestor;

    private ScanQueryRow() {
    }

    public IScanResult getScanResult() {
        return this.scanResult;
    }

    public String getColumnTextValue(ScanQueryColumn column) {
        if (ScanQueryColumn.STREAM_COLUMN == column) {
            return this.stream == null ? "" : this.stream.getName();
        }
        if (ScanQueryColumn.LABEL_COLUMN == column) {
            return this.scanResult.getLabel();
        }
        if (ScanQueryColumn.STATE_COLUMN == column) {
            IScanSummary summary;
            StringBuilder value = new StringBuilder(ScdCommonUtil.getTranslatedString((ScanState)this.scanResult.getState()));
            if (this.scanResult.getState() == ScanState.SCANNING && (summary = this.scanResult.getScanSummary()) != null) {
                value.append("  (");
                if (summary.getNumberFilesProcessed() > 0L) {
                    double total = (double)summary.getNumberFilesScanned() + (double)summary.getNumberFilesDeleted() + (double)summary.getNumberFilesSkipped();
                    long percentage = Math.round(total / (double)summary.getNumberFilesProcessed() * 100.0);
                    value.append(NLS.bind((String)Messages.ScanQueryRow_PROGRESS_PERCENTAGE_LABEL, (Object)percentage));
                } else {
                    value.append(Messages.ScanSummaryComposite_COMPUTING_LABEL);
                }
                value.append(")");
            }
            return value.toString();
        }
        if (ScanQueryColumn.START_TIME_COLUMN == column) {
            return this.scanResult.getScanStartTime() < 0L ? "" : ScdUIUtil.convertToDateTime(this.scanResult.getScanStartTime());
        }
        if (ScanQueryColumn.DURATION_COLUMN == column) {
            return this.scanResult.getScanFinishTime() <= this.scanResult.getScanStartTime() ? "" : ScdCommonUtil.formatTimeInHMS((long)(this.scanResult.getScanFinishTime() - this.scanResult.getScanStartTime()));
        }
        if (ScanQueryColumn.REQUESTOR_COLUMN == column) {
            return ScdUIUtil.getRequestorName(this.requestor);
        }
        return "";
    }

    public String getColumnValue(ScanQueryColumn column) {
        if (ScanQueryColumn.STREAM_COLUMN == column) {
            return this.stream == null ? "" : this.stream.getName();
        }
        if (ScanQueryColumn.LABEL_COLUMN == column) {
            return this.scanResult.getLabel();
        }
        if (ScanQueryColumn.STATE_COLUMN == column) {
            return this.scanResult.getState().name();
        }
        if (ScanQueryColumn.START_TIME_COLUMN == column) {
            return this.scanResult.getScanStartTime() < 0L ? "" : String.valueOf(this.scanResult.getScanStartTime());
        }
        if (ScanQueryColumn.DURATION_COLUMN == column) {
            return this.scanResult.getScanFinishTime() <= this.scanResult.getScanStartTime() ? "" : String.valueOf(this.scanResult.getScanFinishTime() - this.scanResult.getScanStartTime());
        }
        if (ScanQueryColumn.REQUESTOR_COLUMN == column) {
            return ScdUIUtil.getRequestorName(this.requestor);
        }
        return "";
    }

    public Object getTooltipSupport(ScanQueryColumn column) {
        if (ScanQueryColumn.STREAM_COLUMN == column) {
            return this.stream;
        }
        if (ScanQueryColumn.STATE_COLUMN == column && this.scanResult.getState() == ScanState.SCANNING && this.scanResult.getScanSummary() != null) {
            return this.scanResult.getScanSummary();
        }
        if (ScanQueryColumn.REQUESTOR_COLUMN == column) {
            return this.requestor;
        }
        return null;
    }

    public Image getColumnImage(ScanQueryColumn column) {
        if (ScanQueryColumn.STATUS_COLUMN == column) {
            return ScdUIUtil.getStatusImage(this.scanResult);
        }
        return null;
    }

    public static ScanQueryRow createScanQueryRow(IScanResult scanResult, Map<UUID, IWorkspace> streamMap, IProgressMonitor monitor) throws TeamRepositoryException {
        ScanQueryRow row = null;
        if (scanResult != null) {
            IScanRequest scanRequest;
            ITeamRepository repository = (ITeamRepository)scanResult.getOrigin();
            try {
                scanRequest = (IScanRequest)repository.itemManager().fetchPartialItem((IItemHandle)scanResult.getScanRequest(), 0, Arrays.asList(IScanRequest.PROPERTY_REQUESTOR, IScanRequest.PROPERTY_SCAN_CONFIGURATION_INSTANCE), (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)50));
            }
            catch (ItemNotFoundException e) {
                scanRequest = null;
            }
            if (scanRequest != null) {
                row = new ScanQueryRow();
                row.scanResult = scanResult;
                row.requestor = ScdUIUtil.fetchRequestor(scanRequest.getRequestor());
                IWorkspaceHandle streamHandle = scanRequest.getScanConfigurationInstance().getStream();
                IWorkspace stream = streamMap.get(streamHandle.getItemId());
                if (stream == null) {
                    stream = (IWorkspace)repository.itemManager().fetchPartialItem((IItemHandle)streamHandle, 0, Arrays.asList(IWorkspace.NAME_PROPERTY), (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)50));
                    streamMap.put(streamHandle.getItemId(), stream);
                }
                row.stream = stream;
            }
        }
        return row;
    }

    public boolean testAttribute(Object target, String name, String value) {
        if (target instanceof ScanQueryRow && "state".equals(name)) {
            return ((ScanQueryRow)target).getScanResult().getState().name().equalsIgnoreCase(value);
        }
        return false;
    }
}

