/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.scd.ide.ui.view;

import com.ibm.team.enterprise.scd.common.model.IScanConfigurationHandle;
import com.ibm.team.enterprise.scd.ide.ui.view.ScanQueryResult;
import com.ibm.team.repository.client.ITeamRepository;
import java.util.ArrayList;
import java.util.List;

public class ScanQuery {
    private ITeamRepository repository;
    private List<IScanConfigurationHandle> scanConfigurations;
    private String label;
    private ScanQueryResult scanQueryResult;

    public ScanQuery(ITeamRepository repository, String label) {
        this(repository, label, null);
    }

    public ScanQuery(ITeamRepository repository, String label, IScanConfigurationHandle scanConfiguration) {
        this.repository = repository;
        this.label = label;
        this.scanConfigurations = new ArrayList<IScanConfigurationHandle>();
        if (scanConfiguration != null) {
            this.scanConfigurations.add(scanConfiguration);
        }
        this.scanQueryResult = null;
    }

    public void addScanConfigurations(IScanConfigurationHandle scanConfiguration) {
        if (scanConfiguration != null) {
            this.scanConfigurations.add(scanConfiguration);
        }
    }

    public ITeamRepository getRepository() {
        return this.repository;
    }

    public String getLabel() {
        return this.label;
    }

    public IScanConfigurationHandle getFirstScanConfiguration() {
        if (this.scanConfigurations.size() > 0) {
            return this.scanConfigurations.get(0);
        }
        return null;
    }

    public List<IScanConfigurationHandle> getScanConfigurations() {
        return this.scanConfigurations;
    }

    public void setResult(ScanQueryResult scanQueryResult) {
        this.scanQueryResult = scanQueryResult;
    }

    public ScanQueryResult getResult() {
        return this.scanQueryResult;
    }
}

