/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.scd.ide.ui.helper;

import com.ibm.team.repository.common.TeamRepositoryException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.swt.widgets.Display;

public abstract class ScdJob<T>
extends Job {
    protected T data;

    protected abstract T runBackgroundJob(IProgressMonitor var1) throws TeamRepositoryException;

    protected void preRunUIJob() {
    }

    protected void runUIJobOnSuccess() {
    }

    protected void runUIJobOnFailure() {
    }

    public ScdJob(String label) {
        super(label);
        this.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (ScdJob.this.getResult().isOK()) {
                            ScdJob.this.runUIJobOnSuccess();
                        } else {
                            ScdJob.this.runUIJobOnFailure();
                        }
                    }
                });
            }

            public void aboutToRun(IJobChangeEvent event) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ScdJob.this.preRunUIJob();
                    }
                });
            }
        });
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            this.data = this.runBackgroundJob(monitor);
            return Status.OK_STATUS;
        }
        catch (TeamRepositoryException e) {
            return new Status(8, "com.ibm.team.enterprise.common.ui", e.getLocalizedMessage(), (Throwable)e);
        }
    }
}

