/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.scd.ide.ui.helper;

import com.ibm.team.enterprise.scd.common.model.IScanResult;
import com.ibm.team.enterprise.scd.common.model.IScanSummary;
import com.ibm.team.enterprise.scd.common.model.ScanState;
import com.ibm.team.enterprise.scd.ide.ui.ScdUIUtil;
import com.ibm.team.enterprise.scd.internal.ide.ui.nls.Messages;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IComponent;
import java.util.Map;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ScanSummaryComposite {
    private Composite composite;
    private Text numComponentField;
    private Text numFileProcessedField;
    private Text numFileScannedField;
    private Text numFileDeletedField;
    private Text numFileSkippedField;
    private Text numSharedComponentField;
    private Text numFileDeletedLabel;

    public ScanSummaryComposite(Composite parent, FormToolkit toolkit) {
        this.composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(this.composite);
        ScdUIUtil.createNonEditableText(this.composite, Messages.ScanSummaryComposite_NUM_COMPONENTS_PROCESSED, toolkit);
        this.numComponentField = ScdUIUtil.createNonEditableText(this.composite, "", toolkit);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.numComponentField);
        ScdUIUtil.createNonEditableText(this.composite, Messages.ScanSummaryComposite_NUM_COMPONENTS_SHARED, toolkit);
        this.numSharedComponentField = ScdUIUtil.createNonEditableText(this.composite, "", toolkit);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.numSharedComponentField);
        ScdUIUtil.createNonEditableText(this.composite, Messages.ScanSummaryComposite_NUM_FILES_PROCESSED, toolkit);
        this.numFileProcessedField = ScdUIUtil.createNonEditableText(this.composite, "", toolkit);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.numFileProcessedField);
        Text numFileScannedLabel = ScdUIUtil.createNonEditableText(this.composite, Messages.ScanSummaryComposite_NUM_FILES_SCANNED, toolkit);
        GridDataFactory.fillDefaults().indent(15, -1).applyTo((Control)numFileScannedLabel);
        this.numFileScannedField = ScdUIUtil.createNonEditableText(this.composite, "", toolkit);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.numFileScannedField);
        this.numFileDeletedLabel = ScdUIUtil.createNonEditableText(this.composite, Messages.ScanSummaryComposite_NUM_FILES_DELETED, toolkit);
        GridDataFactory.fillDefaults().indent(15, -1).applyTo((Control)this.numFileDeletedLabel);
        this.numFileDeletedField = ScdUIUtil.createNonEditableText(this.composite, "", toolkit);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.numFileDeletedField);
        Text numFileSkippedLabel = ScdUIUtil.createNonEditableText(this.composite, Messages.ScanSummaryComposite_NUM_FILES_SKIPPED, toolkit);
        GridDataFactory.fillDefaults().indent(15, -1).applyTo((Control)numFileSkippedLabel);
        this.numFileSkippedField = ScdUIUtil.createNonEditableText(this.composite, "", toolkit);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.numFileSkippedField);
    }

    public Composite getComposite() {
        return this.composite;
    }

    public void refresh(IScanResult scanResult, Map<UUID, IComponent> componentNameMap) {
        if (scanResult == null || scanResult.getScanSummary() == null) {
            this.clear();
        } else {
            this.updateUI(scanResult, componentNameMap);
        }
    }

    private void clear() {
        this.numComponentField.setText("");
        this.numSharedComponentField.setText("");
        this.numFileProcessedField.setText("");
        this.numFileScannedField.setText("");
        this.numFileDeletedField.setText("");
        this.numFileSkippedField.setText("");
    }

    private void updateUI(IScanResult scanResult, Map<UUID, IComponent> componentNameMap) {
        IScanSummary scanSummary = scanResult.getScanSummary();
        if (scanResult.getState() == ScanState.NOT_STARTED) {
            this.clear();
        } else if (scanResult.getState() != ScanState.COMPLETED && scanResult.getState() != ScanState.CANCELLED) {
            if (scanSummary.getNumberComponentsProcessed() == -1) {
                this.numComponentField.setText(Messages.ScanSummaryComposite_COMPUTING_LABEL);
                this.numSharedComponentField.setText(Messages.ScanSummaryComposite_COMPUTING_LABEL);
            } else {
                this.numComponentField.setText(String.valueOf(scanSummary.getNumberComponentsProcessed()));
                this.numSharedComponentField.setText(String.valueOf(scanSummary.getNumberComponentsShared()));
            }
            if (scanSummary.getNumberFilesProcessed() == -1L) {
                this.numFileProcessedField.setText(Messages.ScanSummaryComposite_COMPUTING_LABEL);
            } else {
                this.numFileProcessedField.setText(String.valueOf(scanSummary.getNumberFilesProcessed()));
            }
            if (scanSummary.getNumberFilesProcessed() == -1L) {
                this.numFileScannedField.setText(String.valueOf(scanSummary.getNumberFilesScanned()));
                this.numFileDeletedField.setText(String.valueOf(scanSummary.getNumberFilesDeleted()));
                this.numFileSkippedField.setText(String.valueOf(scanSummary.getNumberFilesSkipped()));
            } else {
                this.numFileScannedField.setText(NLS.bind((String)Messages.ScanSummaryComposite_PROGRESS_REPORT_LABEL, (Object)scanSummary.getNumberFilesScanned(), (Object)scanSummary.getNumberFilesProcessed()));
                this.numFileDeletedField.setText(NLS.bind((String)Messages.ScanSummaryComposite_PROGRESS_REPORT_LABEL, (Object)scanSummary.getNumberFilesDeleted(), (Object)scanSummary.getNumberFilesProcessed()));
                this.numFileSkippedField.setText(NLS.bind((String)Messages.ScanSummaryComposite_PROGRESS_REPORT_LABEL, (Object)scanSummary.getNumberFilesSkipped(), (Object)scanSummary.getNumberFilesProcessed()));
            }
        } else {
            if (scanSummary.getNumberComponentsProcessed() == -1) {
                this.numComponentField.setText("0");
            } else {
                this.numComponentField.setText(String.valueOf(scanSummary.getNumberComponentsProcessed()));
            }
            if (scanSummary.getNumberFilesProcessed() == -1L) {
                this.numFileProcessedField.setText("0");
            } else {
                this.numFileProcessedField.setText(String.valueOf(scanSummary.getNumberFilesProcessed()));
            }
            this.numFileScannedField.setText(String.valueOf(scanSummary.getNumberFilesScanned()));
            if (scanSummary.getNumberFilesDeleted() < 0L) {
                this.numFileDeletedField.dispose();
                this.numFileDeletedLabel.dispose();
            } else {
                this.numFileDeletedField.setText(String.valueOf(scanSummary.getNumberFilesDeleted()));
            }
            this.numFileSkippedField.setText(String.valueOf(scanSummary.getNumberFilesSkipped()));
            this.numSharedComponentField.setText(scanSummary.getNumberComponentsShared() < 0 ? Messages.ScanSummaryComposite_NOT_AVAILABLE_LABEL : String.valueOf(scanSummary.getNumberComponentsShared()));
        }
    }
}

