/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.scd.ide.ui.helper;

import com.ibm.team.enterprise.scd.common.ScdCommonUtil;
import com.ibm.team.enterprise.scd.common.model.IScanRequest;
import com.ibm.team.enterprise.scd.common.model.IScanResult;
import com.ibm.team.enterprise.scd.common.model.IScanResultHandle;
import com.ibm.team.enterprise.scd.common.model.ScanState;
import com.ibm.team.enterprise.scd.common.model.ScanStatus;
import com.ibm.team.enterprise.scd.ide.ui.Activator;
import com.ibm.team.enterprise.scd.ide.ui.ScdUIUtil;
import com.ibm.team.enterprise.scd.internal.ide.ui.nls.Messages;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.jface.itemview.MarkupUtil;
import com.ibm.team.jface.preview.DomainAdapter;
import com.ibm.team.jface.preview.HTMLGenerator;
import com.ibm.team.jface.preview.IDomainAdapter;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.common.IWorkspace;
import java.util.Arrays;
import java.util.HashMap;

public class ScanResultDomainAdapter
extends DomainAdapter {
    private static final String SCD_CSS = "scdcss";

    public void generateContentAsHTML(HashMap head, StringBuffer body, Object input, IDomainAdapter.Info info) {
        if (input instanceof IScanResultHandle || input instanceof IScanResult) {
            HTMLGenerator htmlGenerator = null;
            try {
                IScanResultHandle scanResultHandle = (IScanResultHandle)input;
                ITeamRepository repository = (ITeamRepository)scanResultHandle.getOrigin();
                final IScanResult scanResult = (IScanResult)repository.itemManager().fetchCompleteItem((IItemHandle)scanResultHandle, 0, null);
                IScanRequest scanRequest = (IScanRequest)repository.itemManager().fetchPartialItem((IItemHandle)scanResult.getScanRequest(), 0, Arrays.asList(IScanRequest.PROPERTY_REQUESTOR, IScanRequest.PROPERTY_SCAN_CONFIGURATION_INSTANCE), null);
                final IWorkspace stream = (IWorkspace)repository.itemManager().fetchPartialItem((IItemHandle)scanRequest.getScanConfigurationInstance().getStream(), 0, Arrays.asList(IWorkspace.NAME_PROPERTY), null);
                final String requestorName = ScdUIUtil.getRequestorName(ScdUIUtil.fetchRequestor(scanRequest.getRequestor()));
                htmlGenerator = new HTMLGenerator(){

                    protected void createControl(HTMLGenerator.Composite composite) {
                        HTMLGenerator.Label scanResultLabel = new HTMLGenerator.Label((HTMLGenerator)this, scanResult.getLabel());
                        HTMLGenerator.Section section = new HTMLGenerator.Section((HTMLGenerator)this, composite, (HTMLGenerator.Control)scanResultLabel);
                        HTMLGenerator.Table table = new HTMLGenerator.Table((HTMLGenerator)this, (HTMLGenerator.Composite)section, 2);
                        table.setCSSClass("layout");
                        new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)table, Messages.ScanResultDomainAdapter_STATE_LABEL);
                        new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)table, ScdCommonUtil.getTranslatedString((ScanState)scanResult.getState()));
                        if (scanResult.getState() == ScanState.COMPLETED) {
                            new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)table, Messages.ScanResultDomainAdapter_STATUS_LABEL);
                            new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)table, ScdCommonUtil.getTranslatedString((ScanStatus)scanResult.getStatus()));
                        }
                        new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)table, Messages.ScanResultDomainAdapter_STREAM_LABEL);
                        new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)table, stream.getName());
                        new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)table, Messages.ScanResultDomainAdapter_REQUESTOR_LABEL);
                        new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)table, requestorName);
                    }

                    protected void generateHead(HashMap headDefinitions) {
                        if (headDefinitions.containsKey(ScanResultDomainAdapter.SCD_CSS)) {
                            return;
                        }
                        StringBuilder css = new StringBuilder();
                        css.append("<style type=\"text/css\">");
                        css.append("table.layout");
                        css.append(" { empty-cells:hide; margin-left: -1px; ").append(MarkupUtil.getDefaultFont()).append(" }\n");
                        css.append("</style>");
                        headDefinitions.put(ScanResultDomainAdapter.SCD_CSS, css.toString());
                    }
                };
            }
            catch (ItemNotFoundException e) {
                htmlGenerator = new HTMLGenerator(){

                    protected void createControl(HTMLGenerator.Composite composite) {
                        new HTMLGenerator.Label((HTMLGenerator)this, composite, XMLString.createFromPlainText((String)Messages.ScanResultDomainAdapter_NOT_FOUND));
                    }
                };
            }
            catch (TeamRepositoryException e) {
                Activator.log((Exception)((Object)e));
                htmlGenerator = new HTMLGenerator(){

                    protected void createControl(HTMLGenerator.Composite composite) {
                        new HTMLGenerator.Label((HTMLGenerator)this, composite, XMLString.createFromPlainText((String)Messages.ScanResultDomainAdapter_ERROR_FETCH));
                        new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
                        new HTMLGenerator.Label((HTMLGenerator)this, composite, XMLString.createFromPlainText((String)e.getLocalizedMessage()));
                    }
                };
            }
            if (htmlGenerator != null) {
                htmlGenerator.generate(head, body, info);
            }
        }
    }

    public String generateJobInfo(Object input, IDomainAdapter.Info info) {
        return Messages.ScanResultDomainAdapter_PENDING;
    }

    public String generateTitle(Object input) {
        return Messages.ScanResultDomainAdapter_TITLE;
    }

    protected Object convertToDomainObject(Object object) {
        if (object instanceof IScanResultHandle || object instanceof IScanResult) {
            return object;
        }
        return null;
    }
}

