/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.scd.ide.ui.helper;

import com.ibm.team.enterprise.scd.common.model.IComponentEntry;
import com.ibm.team.enterprise.scd.common.model.IScanConfiguration;
import com.ibm.team.enterprise.scd.ide.ui.Activator;
import com.ibm.team.enterprise.scd.ide.ui.ScdUIUtil;
import com.ibm.team.enterprise.scd.ide.ui.helper.ComponentListChangedEvent;
import com.ibm.team.enterprise.scd.ide.ui.helper.IComponentListChangedListener;
import com.ibm.team.enterprise.scd.internal.common.model.ComponentEntry;
import com.ibm.team.enterprise.scd.internal.common.model.ScdFactory;
import com.ibm.team.enterprise.scd.internal.ide.ui.nls.Messages;
import com.ibm.team.jface.labelProviders.BaseLabelProvider;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ComponentListComposite {
    private Composite composite;
    private Composite componentButtonComposite;
    private Text promptLabel;
    private ListViewer componentViewer;
    private Button addButton;
    private Button removeButton;
    private IScanConfiguration scanConfiguration;
    private List<IComponentListChangedListener> componentListChangedListeners;
    private Map<UUID, String> componentNameMap = new HashMap<UUID, String>();

    public ComponentListComposite(Composite parent, final String label, final String description, FormToolkit toolkit) {
        this.composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(this.composite);
        this.promptLabel = this.createLabel(this.composite, label, toolkit);
        GridDataFactory.fillDefaults().align(1, 1).applyTo((Control)this.promptLabel);
        this.componentViewer = new ListViewer(this.composite, 68352);
        org.eclipse.swt.widgets.List componentControl = this.componentViewer.getList();
        this.componentViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.componentViewer.setLabelProvider((IBaseLabelProvider)new BaseLabelProvider(){

            public void updateLabel(ViewerLabel label, Object element) {
                if (element instanceof ComponentEntry) {
                    IComponentHandle componentHandle = ((ComponentEntry)element).getComponent();
                    if (componentHandle instanceof IComponent) {
                        label.setText(((IComponent)componentHandle).getName());
                    } else {
                        label.setText((String)ComponentListComposite.this.componentNameMap.get(componentHandle.getItemId()));
                    }
                }
            }
        });
        this.componentViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object element1, Object element2) {
                IComponentHandle componentHandle1 = ((ComponentEntry)element1).getComponent();
                IComponentHandle componentHandle2 = ((ComponentEntry)element2).getComponent();
                String componentName1 = componentHandle1 instanceof IComponent ? ((IComponent)componentHandle1).getName() : (String)ComponentListComposite.this.componentNameMap.get(componentHandle1.getItemId());
                String componentName2 = componentHandle2 instanceof IComponent ? ((IComponent)componentHandle2).getName() : (String)ComponentListComposite.this.componentNameMap.get(componentHandle2.getItemId());
                return componentName1.compareToIgnoreCase(componentName2);
            }
        });
        this.componentViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ComponentListComposite.this.updateButtonStates();
            }
        });
        GridDataFactory.fillDefaults().hint(200, componentControl.getItemHeight() * 5).grab(true, false).applyTo((Control)componentControl);
        this.componentButtonComposite = new Composite(this.composite, 0);
        FillLayout fillLayout = new FillLayout(512);
        fillLayout.spacing = 5;
        this.componentButtonComposite.setLayout((Layout)fillLayout);
        GridDataFactory.fillDefaults().align(1, 1).applyTo((Control)this.componentButtonComposite);
        this.addButton = this.createButton(this.componentButtonComposite, Messages.ScanConfigurationsOverviewEditorPage_ADD_LABEL, toolkit);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Object[] result;
                if (ComponentListComposite.this.scanConfiguration == null) {
                    return;
                }
                List componentEntries = ComponentListComposite.this.scanConfiguration.getComponents();
                ArrayList<IComponentHandle> excludedFromShowingComponentHandles = new ArrayList<IComponentHandle>();
                for (ComponentEntry componentEntry : componentEntries) {
                    excludedFromShowingComponentHandles.add(componentEntry.getComponent());
                }
                IWorkspaceHandle streamHandle = ComponentListComposite.this.scanConfiguration.getStream();
                ITeamRepository repository = (ITeamRepository)streamHandle.getOrigin();
                ListSelectionDialog selectionDialog = ScdUIUtil.getComponentSelectionDialog(ComponentListComposite.this.composite.getShell(), repository, streamHandle, label, description, excludedFromShowingComponentHandles);
                if (selectionDialog.open() == 0 && (result = selectionDialog.getResult()) != null) {
                    ArrayList<IComponentEntry> oldComponentList = new ArrayList<IComponentEntry>(componentEntries.size());
                    oldComponentList.addAll(componentEntries);
                    ArrayList<IComponentEntry> newComponentList = new ArrayList<IComponentEntry>(componentEntries);
                    int i = 0;
                    while (i < result.length) {
                        ComponentEntry componentEntry = ScdFactory.eINSTANCE.createComponentEntry();
                        componentEntry.setComponent((IComponentHandle)result[i]);
                        newComponentList.add((IComponentEntry)componentEntry);
                        ++i;
                    }
                    ComponentListComposite.this.componentViewer.setInput(newComponentList);
                    ComponentListComposite.this.fireComponentListChanged(new ComponentListChangedEvent(oldComponentList, newComponentList, ComponentListChangedEvent.Type.ADD));
                }
            }
        });
        this.removeButton = this.createButton(this.componentButtonComposite, Messages.ScanConfigurationsOverviewEditorPage_REMOVE_LABEL, toolkit);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IStructuredSelection selection = (IStructuredSelection)ComponentListComposite.this.componentViewer.getSelection();
                if (!selection.isEmpty()) {
                    ComponentListComposite.this.componentViewer.remove(selection.toArray());
                    ComponentListComposite.this.fireComponentListChanged(new ComponentListChangedEvent(null, selection.toList(), ComponentListChangedEvent.Type.REMOVE));
                }
            }
        });
    }

    public void setInput(IScanConfiguration scanConfiguration) {
        if (scanConfiguration != null && scanConfiguration.getComponents().size() > 0) {
            if (((IComponentEntry)scanConfiguration.getComponents().get(0)).getComponent() instanceof IComponent) {
                this.componentViewer.setInput((Object)scanConfiguration.getComponents());
            } else {
                this.fetchComponentNames(scanConfiguration.getComponents());
            }
        } else {
            this.componentViewer.setInput((Object)Collections.EMPTY_LIST);
        }
        this.scanConfiguration = scanConfiguration;
    }

    public Composite getComposite() {
        return this.composite;
    }

    public void updateButtonStates() {
        if (this.removeButton != null && !this.removeButton.isDisposed()) {
            this.removeButton.setEnabled(!((IStructuredSelection)this.componentViewer.getSelection()).isEmpty());
        }
    }

    public List<IComponentEntry> getComponents() {
        int size = this.componentViewer.getList().getItemCount();
        ArrayList<IComponentEntry> components = new ArrayList<IComponentEntry>(size);
        int i = 0;
        while (i < size) {
            components.add((IComponentEntry)this.componentViewer.getElementAt(i));
            ++i;
        }
        return components;
    }

    private void fireComponentListChanged(ComponentListChangedEvent event) {
        if (this.componentListChangedListeners != null) {
            for (IComponentListChangedListener listener : this.componentListChangedListeners) {
                listener.componentListChanged(event);
            }
        }
    }

    public void addComponentListChangedListener(IComponentListChangedListener listener) {
        if (this.componentListChangedListeners == null) {
            this.componentListChangedListeners = new ArrayList<IComponentListChangedListener>();
        }
        this.componentListChangedListeners.add(listener);
    }

    public void removeComponentListChangedListener(IComponentListChangedListener listener) {
        if (this.componentListChangedListeners != null) {
            this.componentListChangedListeners.remove(listener);
        }
    }

    private Text createLabel(Composite parent, String value, FormToolkit toolkit) {
        Text text;
        if (toolkit == null) {
            text = new Text(parent, 4);
            text.setEditable(false);
            text.setBackground(parent.getBackground());
            text.setForeground(parent.getForeground());
            if (value != null) {
                text.setText(value);
            }
        } else {
            text = ScdUIUtil.createNonEditableText(parent, value, toolkit);
        }
        return text;
    }

    private Button createButton(Composite parent, String value, FormToolkit toolkit) {
        Button button;
        if (toolkit == null) {
            button = new Button(parent, 8);
            if (value != null) {
                button.setText(value);
            }
        } else {
            button = toolkit.createButton(parent, value, 8);
        }
        return button;
    }

    private void fetchComponentNames(final List<IComponentEntry> componentEntries) {
        Job job = new Job(""){

            protected IStatus run(IProgressMonitor monitor) {
                ComponentListComposite.this.componentNameMap.clear();
                if (componentEntries.size() > 0) {
                    ArrayList<IComponentHandle> componentHandles = new ArrayList<IComponentHandle>(componentEntries.size());
                    for (IComponentEntry componentEntry : componentEntries) {
                        componentHandles.add(componentEntry.getComponent());
                    }
                    try {
                        ITeamRepository repository = (ITeamRepository)((IComponentHandle)componentHandles.get(0)).getOrigin();
                        List components = repository.itemManager().fetchPartialItems(componentHandles, 1, Arrays.asList(IWorkspace.NAME_PROPERTY), monitor);
                        for (IComponent component : components) {
                            ComponentListComposite.this.componentNameMap.put(component.getItemId(), component.getName());
                        }
                    }
                    catch (TeamRepositoryException e) {
                        Activator.log((Exception)((Object)e));
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (ComponentListComposite.this.componentViewer != null && !ComponentListComposite.this.componentViewer.getControl().isDisposed()) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            ComponentListComposite.this.componentViewer.setInput((Object)componentEntries);
                        }
                    });
                }
            }
        });
        job.schedule();
    }

    public void setReadOnly(boolean value) {
        if (value) {
            this.promptLabel.setEnabled(false);
            this.componentViewer.getList().setEnabled(false);
            this.addButton.setEnabled(false);
            this.removeButton.setEnabled(false);
        } else {
            this.promptLabel.setEnabled(true);
            this.componentViewer.getList().setEnabled(true);
            this.addButton.setEnabled(true);
            this.updateButtonStates();
        }
    }
}

