/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.scd.ide.ui.helper;

import com.ibm.team.enterprise.scd.common.model.IComponentEntry;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IComponent;
import java.util.List;
import java.util.Map;

public class ComponentEntryList {
    private List<IComponentEntry> componentEntries;
    private Map<UUID, IComponent> componentNameMap;
    private String label;

    public ComponentEntryList(String label, List<IComponentEntry> componentEntries, Map<UUID, IComponent> componentNameMap) {
        this.label = label;
        this.componentEntries = componentEntries;
        this.componentNameMap = componentNameMap;
    }

    public String getLabel() {
        return this.label;
    }

    public List<IComponentEntry> getComponents() {
        return this.componentEntries;
    }

    public String resolveName(IComponentEntry componentEntry) {
        IComponent component;
        String name = componentEntry.getComponent().getItemId().getUuidValue();
        if (this.componentNameMap != null && (component = this.componentNameMap.get(componentEntry.getComponent().getItemId())) != null) {
            name = component.getName();
        }
        return name;
    }
}

