/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.scd.ide.ui.editor;

import com.ibm.team.enterprise.common.ui.Activator;
import com.ibm.team.enterprise.scd.client.ScanResultTrend;
import com.ibm.team.enterprise.scd.common.ScdCommonUtil;
import com.ibm.team.enterprise.scd.common.model.IScanConfigurationInstance;
import com.ibm.team.enterprise.scd.common.model.IScanRequest;
import com.ibm.team.enterprise.scd.common.model.IScanResult;
import com.ibm.team.enterprise.scd.common.model.IScanResultContribution;
import com.ibm.team.enterprise.scd.common.model.ScanScope;
import com.ibm.team.enterprise.scd.common.model.ScanState;
import com.ibm.team.enterprise.scd.common.model.ScanType;
import com.ibm.team.enterprise.scd.ide.ui.ScdUIUtil;
import com.ibm.team.enterprise.scd.ide.ui.action.OpenScanResultAction;
import com.ibm.team.enterprise.scd.ide.ui.editor.ScanResultEditor;
import com.ibm.team.enterprise.scd.ide.ui.helper.ScanSummaryComposite;
import com.ibm.team.enterprise.scd.internal.ide.ui.nls.Messages;
import com.ibm.team.jface.ColorUtils;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.tooltip.TooltipSupport;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.ui.editor.TeamFormPage;
import java.io.File;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IDE;

public class ScanResultGeneralEditorPage
extends TeamFormPage {
    private LocalResourceManager resourceManager;
    private Section statusStateSection;
    private Composite statusStateComposite;
    private Label statusLabel;
    private Label stateLabel;
    private Label durationLabel;
    private Label durationValueLabel;
    private Label startedTimeLabel;
    private Label startedTimeValueLabel;
    private Label completedTimeLabel;
    private Label completedTimeValueLabel;
    private Label trendBarLabel;
    private Composite trendBarComposite;
    private Label extraSpaceTrendBarSpace;
    private Section generalSection;
    private Text requestorLabel;
    private Hyperlink streamLink;
    private Hyperlink scanLogLink;
    private Text scanLogSize;
    private Section configurationSection;
    private Text scanTypeLabel;
    private Text scanScopeLabel;
    private Text maxWaitTimeLabel;
    private Label backgroundScanLabel;
    private Text backgroundScanDelayIntervalLabel;
    private Text backgroundScanDelayIntervalValueLabel;
    private Text continueOnErrorLabel;
    private Text continueOnErrorValueLabel;
    private Section summarySection;
    private ScanSummaryComposite summaryComposite;

    public ScanResultGeneralEditorPage(ScanResultEditor editor) {
        super((FormEditor)editor, ScanResultGeneralEditorPage.class.getName(), Messages.ScanResultGeneralEditorPage_TAB_TITLE);
    }

    public ScanResultEditor getEditor() {
        return (ScanResultEditor)super.getEditor();
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        Composite body = form.getBody();
        body.setLayout((Layout)new TableWrapLayout());
        Composite container = managedForm.getToolkit().createComposite(body);
        TableWrapData layoutData = new TableWrapData(256, 256);
        container.setLayoutData((Object)layoutData);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(10, 10).spacing(20, 12).applyTo(container);
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)container);
        this.createStatusStateSection(container, managedForm.getToolkit());
        this.createGeneralSection(container, managedForm.getToolkit());
        this.createConfigurationSection(container, managedForm.getToolkit());
        this.createSummarySection(container, managedForm.getToolkit());
    }

    private void createStatusStateSection(Composite parent, FormToolkit toolkit) {
        this.statusStateSection = toolkit.createSection(parent, 4096);
        GridDataFactory.fillDefaults().grab(true, false).minSize(200, -1).applyTo((Control)this.statusStateSection);
        this.statusStateSection.setLayout((Layout)new FillLayout());
        Composite composite = toolkit.createComposite((Composite)this.statusStateSection);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).margins(5, 10).applyTo(composite);
        this.statusStateSection.setClient((Control)composite);
        this.statusStateComposite = toolkit.createComposite(composite);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.statusStateComposite);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).applyTo(this.statusStateComposite);
        this.statusLabel = new Label(this.statusStateComposite, 0);
        this.stateLabel = toolkit.createLabel(this.statusStateComposite, "");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.stateLabel);
        this.durationLabel = toolkit.createLabel(composite, Messages.ScanResultGeneralEditorPage_DURATION_LABEL);
        this.durationValueLabel = toolkit.createLabel(composite, "");
        this.startedTimeLabel = toolkit.createLabel(composite, Messages.ScanResultGeneralEditorPage_STARTED_TIME_LABEL);
        this.startedTimeValueLabel = toolkit.createLabel(composite, "");
        this.completedTimeLabel = toolkit.createLabel(composite, Messages.ScanResultGeneralEditorPage_COMPLETED_TIME_LABEL);
        this.completedTimeValueLabel = toolkit.createLabel(composite, "");
        this.trendBarLabel = toolkit.createLabel(composite, Messages.ScanResultGeneralEditorPage_STATUS_TREND_LABEL);
        this.trendBarComposite = toolkit.createComposite(composite, 0);
        GridDataFactory.fillDefaults().applyTo((Control)this.trendBarComposite);
        RowLayout layout = new RowLayout();
        layout.marginLeft = 0;
        layout.marginRight = 0;
        this.trendBarComposite.setLayout((Layout)layout);
        this.extraSpaceTrendBarSpace = toolkit.createLabel(composite, "");
    }

    private void createGeneralSection(Composite parent, FormToolkit toolkit) {
        this.generalSection = toolkit.createSection(parent, 256);
        this.generalSection.setText(Messages.ScanResultGeneralEditorPage_GENERAL_SECTION_TITLE);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.generalSection);
        this.generalSection.setLayout((Layout)new FillLayout());
        Composite composite = toolkit.createComposite((Composite)this.generalSection);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(3).equalWidth(false).margins(5, 10).applyTo(composite);
        this.generalSection.setClient((Control)composite);
        ScdUIUtil.createNonEditableText(composite, Messages.ScanResultGeneralEditorPage_REQUESTOR_LABEL, toolkit);
        this.requestorLabel = ScdUIUtil.createNonEditableText(composite, "", toolkit);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.requestorLabel);
        ScdUIUtil.createNonEditableText(composite, Messages.ScanResultGeneralEditorPage_STREAM_LABEL, toolkit);
        this.streamLink = ScdUIUtil.createWorkspaceLink(composite, null, toolkit, this.getSite().getPage());
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.streamLink);
        ScdUIUtil.createNonEditableText(composite, Messages.ScanResultGeneralEditorPage_SCAN_LOG_LABEL, toolkit);
        this.scanLogLink = toolkit.createHyperlink(composite, "", 64);
        this.scanLogLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent event) {
                final ITeamRepository repository = (ITeamRepository)ScanResultGeneralEditorPage.this.scanLogLink.getData("repository");
                final IContent content = (IContent)ScanResultGeneralEditorPage.this.scanLogLink.getHref();
                final File tempFile = ScdUIUtil.createScdTempFile(ScanResultGeneralEditorPage.this.scanLogLink.getText());
                if (repository == null || content == null || tempFile == null) {
                    return;
                }
                Job job = new Job(""){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            ScdUIUtil.contentToFile(content, tempFile, repository, monitor);
                        }
                        catch (TeamRepositoryException e) {
                            return new Status(4, "com.ibm.team.enterprise.common.ui", e.getLocalizedMessage(), (Throwable)e);
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                    public void done(IJobChangeEvent event) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    IFileStore fileStore = EFS.getLocalFileSystem().getStore(tempFile.toURI());
                                    FileStoreEditorInput input = new FileStoreEditorInput(fileStore);
                                    IDE.openEditor((IWorkbenchPage)ScanResultGeneralEditorPage.this.getEditor().getEditorSite().getPage(), (IEditorInput)input, (String)"org.eclipse.ui.DefaultTextEditor");
                                }
                                catch (PartInitException e) {
                                    Activator.log((Throwable)e);
                                }
                            }
                        });
                    }
                });
                job.schedule();
            }
        });
        this.scanLogSize = ScdUIUtil.createNonEditableText(composite, "", toolkit);
    }

    private void createConfigurationSection(Composite parent, FormToolkit toolkit) {
        this.configurationSection = toolkit.createSection(parent, 256);
        this.configurationSection.setText(Messages.ScanResultGeneralEditorPage_CONFIGURATION_SECTION_TITLE);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.configurationSection);
        this.configurationSection.setLayout((Layout)new FillLayout());
        Composite composite = toolkit.createComposite((Composite)this.configurationSection);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).margins(5, 10).applyTo(composite);
        this.configurationSection.setClient((Control)composite);
        ScdUIUtil.createNonEditableText(composite, Messages.ScanResultGeneralEditorPage_SCAN_TYPE_LABEL, toolkit);
        this.scanTypeLabel = ScdUIUtil.createNonEditableText(composite, "", toolkit);
        ScdUIUtil.createNonEditableText(composite, Messages.ScanResultGeneralEditorPage_SCAN_SCOPE_LABEL, toolkit);
        this.scanScopeLabel = ScdUIUtil.createNonEditableText(composite, "", toolkit);
        ScdUIUtil.createNonEditableText(composite, Messages.ScanResultGeneralEditorPage_MAX_WAITTIME_LABEL, toolkit);
        this.maxWaitTimeLabel = ScdUIUtil.createNonEditableText(composite, "", toolkit);
        this.backgroundScanLabel = toolkit.createLabel(composite, Messages.ScanResultGeneralEditorPage_BACKGROUND_SCAN_LABEL);
        this.backgroundScanLabel.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.backgroundScanLabel);
        this.continueOnErrorLabel = ScdUIUtil.createNonEditableText(composite, Messages.ScanResultGeneralEditorPage_CONTINUE_ON_ERROR_LABEL, toolkit);
        GridDataFactory.fillDefaults().indent(15, 0).applyTo((Control)this.continueOnErrorLabel);
        this.continueOnErrorValueLabel = ScdUIUtil.createNonEditableText(composite, "", toolkit);
        this.backgroundScanDelayIntervalLabel = ScdUIUtil.createNonEditableText(composite, Messages.ScanResultGeneralEditorPage_DELAY_INTERVAL_LABEL, toolkit);
        GridDataFactory.fillDefaults().indent(15, 0).applyTo((Control)this.backgroundScanDelayIntervalLabel);
        this.backgroundScanDelayIntervalValueLabel = ScdUIUtil.createNonEditableText(composite, "", toolkit);
    }

    private void createSummarySection(Composite parent, FormToolkit toolkit) {
        this.summarySection = toolkit.createSection(parent, 256);
        this.summarySection.setText(Messages.ScanResultGeneralEditorPage_SUMMARY_SECTION_TITLE);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.summarySection);
        this.summarySection.setLayout((Layout)new FillLayout());
        Composite composite = toolkit.createComposite((Composite)this.summarySection);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().applyTo(composite);
        this.summarySection.setClient((Control)composite);
        this.summaryComposite = new ScanSummaryComposite(composite, toolkit);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.summaryComposite.getComposite());
    }

    protected void refreshPage() {
        IScanResultContribution scanLog;
        IScanResult scanResult = this.getEditor().getScanResult();
        Color backgroundColor = ScdUIUtil.getStatusBackgroundColor(scanResult, this.resourceManager);
        Color foregroundColor = ScdUIUtil.getStatusForegroundColor(scanResult, this.resourceManager);
        this.statusStateSection.getClient().setBackground(backgroundColor);
        this.statusStateComposite.setBackground(backgroundColor);
        Image image = ScdUIUtil.getStatusImage(scanResult);
        this.statusLabel.setBackground(backgroundColor);
        this.statusLabel.setImage(image);
        this.stateLabel.setText(ScdCommonUtil.getTranslatedString((ScanState)scanResult.getState()));
        this.stateLabel.setBackground(backgroundColor);
        this.stateLabel.setForeground(foregroundColor);
        this.durationLabel.setBackground(backgroundColor);
        long duration = scanResult.getScanFinishTime() - scanResult.getScanStartTime();
        String value = duration > 0L ? ScdCommonUtil.formatTimeInHMS((long)duration) : "";
        this.durationValueLabel.setText(value);
        this.durationValueLabel.setBackground(backgroundColor);
        this.startedTimeLabel.setBackground(backgroundColor);
        this.startedTimeValueLabel.setText(ScdUIUtil.convertToDateTime(scanResult.getScanStartTime()));
        this.startedTimeValueLabel.setBackground(backgroundColor);
        this.completedTimeLabel.setBackground(backgroundColor);
        if (scanResult.getScanFinishTime() > 0L) {
            this.completedTimeValueLabel.setText(ScdUIUtil.convertToDateTime(scanResult.getScanFinishTime()));
        }
        this.completedTimeValueLabel.setBackground(backgroundColor);
        this.trendBarLabel.setBackground(backgroundColor);
        this.updateTrendBar(backgroundColor);
        this.extraSpaceTrendBarSpace.setBackground(backgroundColor);
        this.statusStateSection.layout();
        IScanRequest scanRequest = this.getEditor().getScanRequest();
        this.requestorLabel.setText(ScdUIUtil.getRequestorName(ScdUIUtil.fetchRequestor(scanRequest.getRequestor())));
        this.streamLink.setHref((Object)this.getEditor().getStream());
        if (this.getEditor().getStream() != null) {
            this.streamLink.setText(this.getEditor().getStream().getName());
        }
        if ((scanLog = scanResult.getScanLog()) != null) {
            this.scanLogLink.setVisible(true);
            this.scanLogLink.setHref((Object)scanLog.getContributionData());
            this.scanLogLink.setText(scanLog.getLabel());
            this.scanLogLink.setData("repository", scanResult.getOrigin());
            this.scanLogSize.setText(NLS.bind((String)"({0})", (Object)(scanLog.getContributionData() == null ? "" : ScdCommonUtil.formatFileSize((long)scanLog.getContributionData().getEstimatedConvertedLength()))));
        } else {
            this.scanLogLink.setVisible(false);
        }
        this.generalSection.layout();
        this.scanTypeLabel.setText(ScdCommonUtil.getTranslatedString((ScanType)scanRequest.getType()));
        this.scanScopeLabel.setText(ScdCommonUtil.getTranslatedString((ScanScope)scanRequest.getScope()));
        this.maxWaitTimeLabel.setText(ScdCommonUtil.formatTimeInHMS((long)(scanRequest.getMaxWaitTimeToScan() * 1000L)));
        if (scanRequest.getRequestor() == null) {
            this.continueOnErrorValueLabel.setText(scanRequest.isContinueOnError() ? Messages.TRUE : Messages.FALSE);
            IScanConfigurationInstance scanConfiguration = scanRequest.getScanConfigurationInstance();
            this.backgroundScanDelayIntervalValueLabel.setText(ScdCommonUtil.formatTimeInHMS((long)(scanConfiguration.getBackgroundScanDelayInterval() * 1000L)));
        } else {
            this.backgroundScanLabel.setVisible(false);
            this.continueOnErrorLabel.setVisible(false);
            this.continueOnErrorValueLabel.setVisible(false);
            this.backgroundScanDelayIntervalLabel.setVisible(false);
            this.backgroundScanDelayIntervalValueLabel.setVisible(false);
        }
        this.configurationSection.layout();
        this.summaryComposite.refresh(scanResult, this.getEditor().getComponentNameMap());
        this.summarySection.layout();
    }

    private void updateTrendBar(Color backgroundColor) {
        Control[] controlArray = this.trendBarComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.dispose();
            control = null;
            ++n2;
        }
        this.trendBarComposite.setBackground(backgroundColor);
        for (ScanResultTrend trend : this.getEditor().getTrends()) {
            boolean selected = trend.getScanResult().sameItemId((IItemHandle)this.getEditor().getScanResult());
            this.createTrendBarItem(this.trendBarComposite, trend, backgroundColor, selected, this.getEditor().getHeaderForm().getToolkit());
        }
        this.trendBarComposite.pack();
    }

    private Label createTrendBarItem(Composite trendBarComposite, final ScanResultTrend trend, Color backgroundColor, boolean selected, FormToolkit toolkit) {
        Label label = toolkit.createLabel(trendBarComposite, "");
        final Image image = this.getStatusTrendItemImage(trend, backgroundColor, selected);
        label.setImage(image);
        final Cursor cursor = new Cursor((Device)Display.getDefault(), 21);
        label.setCursor(cursor);
        label.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                image.dispose();
                cursor.dispose();
            }
        });
        if (!trend.getScanResult().sameItemId((IItemHandle)this.getEditor().getScanResult())) {
            label.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    OpenScanResultAction openAction = new OpenScanResultAction();
                    openAction.init(ScanResultGeneralEditorPage.this.getEditorSite().getPage());
                    openAction.selectionChanged(null, (ISelection)new StructuredSelection((Object)trend.getScanResult()));
                    openAction.run(null);
                }
            });
            new TooltipSupport((Control)label, true, true, true){

                public Object getElement(Control control, int x, int y) {
                    return trend.getScanResult();
                }
            };
        }
        return label;
    }

    private Image getStatusTrendItemImage(ScanResultTrend trend, Color backgroundColor, boolean selected) {
        RGB baseRGB = ScdUIUtil.getStatusTrendRGB(trend.getScanResult(), this.resourceManager);
        RGB blend = ColorUtils.addColor((RGB)baseRGB, (float)50.0f);
        Color fillColor = JazzResources.getColor((ResourceManager)this.resourceManager, (RGB)blend);
        blend = ColorUtils.addColor((RGB)baseRGB, (float)30.0f);
        Color borderColor = JazzResources.getColor((ResourceManager)this.resourceManager, (RGB)blend);
        Image image = new Image((Device)Display.getDefault(), 11, 26);
        GC gc = new GC((Drawable)image);
        Rectangle bounds = image.getBounds();
        gc.setBackground(backgroundColor);
        gc.fillRectangle(bounds);
        gc.setBackground(fillColor);
        gc.fillRectangle(bounds.x, bounds.y + 4, bounds.width - 1, bounds.height - 9);
        gc.setForeground(borderColor);
        gc.drawRectangle(bounds.x, bounds.y + 4, bounds.width - 1, bounds.height - 9);
        if (selected) {
            gc.setForeground(Display.getDefault().getSystemColor(17));
            gc.setLineStyle(1);
            gc.drawLine(5, bounds.height - 4, 5, bounds.height - 4);
            gc.drawLine(4, bounds.height - 3, 6, bounds.height - 3);
            gc.drawLine(3, bounds.height - 2, 7, bounds.height - 2);
            gc.drawLine(2, bounds.height - 1, 8, bounds.height - 1);
        }
        gc.dispose();
        return image;
    }
}

