/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.scd.ide.ui.editor;

import com.ibm.team.enterprise.scd.client.ScanResultTrend;
import com.ibm.team.enterprise.scd.common.model.IScanRequest;
import com.ibm.team.enterprise.scd.common.model.IScanResult;
import com.ibm.team.enterprise.scd.common.model.IScanResultHandle;
import com.ibm.team.enterprise.scd.ide.ui.Activator;
import com.ibm.team.enterprise.scd.ide.ui.editor.AbstractScdEditor;
import com.ibm.team.enterprise.scd.ide.ui.editor.ScanResultEditorInput;
import com.ibm.team.enterprise.scd.ide.ui.editor.ScanResultGeneralEditorPage;
import com.ibm.team.enterprise.scd.internal.client.IScdClient;
import com.ibm.team.enterprise.scd.internal.ide.ui.nls.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ScanResultEditor
extends AbstractScdEditor {
    private static final int MAX_SCAN_RESULT_TREND = 10;
    private IScanResult scanResult;
    private Map<UUID, IComponent> componentNameMap;
    private IWorkspace stream;
    private IScanRequest scanRequest;
    private List<ScanResultTrend> trends;
    private ITeamRepository repository;
    private ScanResultGeneralEditorPage overviewPage;
    private IMessageManager messageManager;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        IScanResultHandle scanResultHandle = (IScanResultHandle)input.getAdapter(IScanResultHandle.class);
        this.repository = (ITeamRepository)scanResultHandle.getOrigin();
    }

    protected void createHeaderContents(IManagedForm headerForm) {
        Form form = headerForm.getForm().getForm();
        form.setText(NLS.bind((String)Messages.ScanResultEditor_TITLE, (Object)""));
        form.setImage(null);
        FormToolkit toolkit = headerForm.getToolkit();
        this.contributeToToolbar(form.getToolBarManager());
        this.messageManager = headerForm.getMessageManager();
        this.messageManager.setDecorationPosition(16512);
        Composite head = headerForm.getForm().getForm().getHead();
        Composite container = toolkit.createComposite(head);
        container.setLayoutData((Object)new FormAttachment());
        container.setLayout((Layout)new GridLayout(2, false));
        container.setBackground(null);
        this.runInitialFetchJob();
    }

    @Override
    protected void doInitialFetch(IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IScdClient scdClient = (IScdClient)this.getRepository().getClientLibrary(IScdClient.class);
        this.scanResult = (IScanResult)this.getRepository().itemManager().fetchCompleteItem((IItemHandle)this.getEditorInput().getScanResult(), 1, (IProgressMonitor)progress.newChild(20));
        this.trends = scdClient.queryScanResultTrends((IScanResultHandle)this.scanResult, 10, (IProgressMonitor)progress.newChild(20));
        this.scanRequest = (IScanRequest)this.getRepository().itemManager().fetchPartialItem((IItemHandle)this.scanResult.getScanRequest(), 0, Arrays.asList(IScanRequest.PROPERTY_REQUESTOR, IScanRequest.PROPERTY_CONTINUE_ON_ERROR, IScanRequest.PROPERTY_MAX_WAIT_TIME, IScanRequest.PROPERTY_SCAN_CONFIGURATION_INSTANCE, IScanRequest.PROPERTY_SCAN_SCOPE), (IProgressMonitor)progress.newChild(20));
        this.stream = (IWorkspace)this.getRepository().itemManager().fetchPartialItem((IItemHandle)this.scanRequest.getScanConfigurationInstance().getStream(), 0, Arrays.asList(IWorkspace.NAME_PROPERTY), (IProgressMonitor)progress.newChild(20));
        this.initComponentNameMap((IProgressMonitor)progress.newChild(20));
    }

    private void initComponentNameMap(IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.stream != null) {
            if (this.componentNameMap == null) {
                this.componentNameMap = new HashMap<UUID, IComponent>();
            }
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            IWorkspaceConnection wcConnection = SCMPlatform.getWorkspaceManager((ITeamRepository)this.repository).getWorkspaceConnection((IWorkspaceHandle)this.stream, (IProgressMonitor)progress.newChild(50));
            List componentHandles = wcConnection.getComponents();
            List components = this.repository.itemManager().fetchPartialItems(componentHandles, 0, Collections.singleton(IComponent.NAME_PROPERTY), (IProgressMonitor)progress.newChild(50));
            for (IComponent component : components) {
                this.componentNameMap.put(component.getItemId(), component);
            }
        }
        monitor.done();
    }

    @Override
    protected void refreshUI() {
        this.getHeaderForm().getForm().getForm().setText(NLS.bind((String)Messages.ScanResultEditor_TITLE, (Object)this.scanResult.getLabel()));
        this.setPartName(this.scanResult.getLabel());
        this.overviewPage.refreshPage();
    }

    @Override
    protected void addPages() {
        try {
            this.overviewPage = new ScanResultGeneralEditorPage(this);
            this.addPage((IFormPage)this.overviewPage);
        }
        catch (PartInitException e) {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)Messages.ScanResultEditor_ERROR_TITLE, (String)NLS.bind((String)Messages.ScanResultEditor_ERROR_OPEN, (Object)((Object)e)));
            Activator.log((Exception)((Object)e));
        }
    }

    private void contributeToToolbar(IToolBarManager toolbarManager) {
        Action refreshAction = new Action(Messages.ScanResultEditor_REFRESH_ACTION_LABEL, Activator.getImageDescriptor("/icons/elcl16/refresh.gif")){

            public void run() {
                ScanResultEditor.this.runInitialFetchJob();
            }
        };
        toolbarManager.add((IAction)refreshAction);
        toolbarManager.update(true);
    }

    public final void doSave(IProgressMonitor monitor) {
    }

    @Override
    public final boolean isDirty() {
        return false;
    }

    public ScanResultEditorInput getEditorInput() {
        return (ScanResultEditorInput)super.getEditorInput();
    }

    public IScanResult getScanResult() {
        return this.scanResult;
    }

    public Map<UUID, IComponent> getComponentNameMap() {
        return this.componentNameMap;
    }

    public IScanRequest getScanRequest() {
        return this.scanRequest;
    }

    public IWorkspace getStream() {
        return this.stream;
    }

    public List<ScanResultTrend> getTrends() {
        return this.trends;
    }

    public ITeamRepository getRepository() {
        return this.repository;
    }
}

