/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.scd.ide.ui.editor;

import com.ibm.team.enterprise.scd.common.model.IComponentEntry;
import com.ibm.team.enterprise.scd.common.model.IScanConfiguration;
import com.ibm.team.enterprise.scd.ide.ui.Activator;
import com.ibm.team.enterprise.scd.ide.ui.ScdUIUtil;
import com.ibm.team.enterprise.scd.ide.ui.action.RequestScanAction;
import com.ibm.team.enterprise.scd.ide.ui.action.ShowScanResultsAction;
import com.ibm.team.enterprise.scd.ide.ui.editor.ScanConfigurationsEditor;
import com.ibm.team.enterprise.scd.ide.ui.helper.ComponentListChangedEvent;
import com.ibm.team.enterprise.scd.ide.ui.helper.ComponentListComposite;
import com.ibm.team.enterprise.scd.ide.ui.helper.IComponentListChangedListener;
import com.ibm.team.enterprise.scd.ide.ui.helper.StreamScanConfigurationPair;
import com.ibm.team.enterprise.scd.internal.client.IScdClient;
import com.ibm.team.enterprise.scd.internal.common.model.ComponentEntry;
import com.ibm.team.enterprise.scd.internal.ide.ui.nls.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IFetchResult;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.StaleDataException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.ui.editor.TeamFormPage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class ScanConfigurationsOverviewEditorPage
extends TeamFormPage {
    private TableViewer streamViewer;
    private StackLayout stackLayout;
    private Composite scanConfigurationComposite;
    private Composite emptyScanConfigurationContentComposite;
    private Composite scanConfigurationContentComposite;
    private Hyperlink streamHyperLink;
    private Button enableBackgroundScanCheckbox;
    private Text delayIntervalLabel;
    private Text delayIntervalTextField;
    private Button runBackgroundScanOnlyIfChangesCheckbox;
    private Text maxWaitTimeTextField;
    private Button continueOnErrorCheckbox;
    private ComponentListComposite excludedComponentListViewer;
    private Spinner successToKeepSpinner;
    private Spinner warningToKeepSpinner;
    private Spinner failedToKeepSpinner;
    private ToolItem saveScanConfigurationToolItem;
    private ToolItem removeScanConfigurationToolItem;
    private ToolItem runScanToolItem;
    private ToolItem showResultsToolItem;
    private Composite promptCreateScanConfigurationContentComposite;
    private Text promptLabel;
    private Text scanArgumentField;
    private StreamScanConfigurationPair currentSelectedStreamInfo;
    private ShowAllStreamFilter showAllStreamFilter;
    private ShowOnlyStreamWithScanConfigurationFilter showOnlyStreamWithScanConfigurationFilter;
    private boolean isOnlyRefresh;

    public ScanConfigurationsOverviewEditorPage(ScanConfigurationsEditor editor) {
        super((FormEditor)editor, ScanConfigurationsOverviewEditorPage.class.getName(), Messages.ScanConfigurationsOverviewEditorPage_TITLE);
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        Composite body = form.getBody();
        FillLayout fillLayout = new FillLayout(512);
        fillLayout.marginHeight = 10;
        fillLayout.marginWidth = 5;
        body.setLayout((Layout)fillLayout);
        Composite container = managedForm.getToolkit().createComposite(body);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(10, 10).spacing(20, 20).applyTo(container);
        Section streamSection = this.createStreamSection(container, managedForm.getToolkit());
        this.createScanConfigurationSection(container, streamSection, managedForm.getToolkit());
    }

    private Section createStreamSection(Composite parent, FormToolkit toolkit) {
        Section section = toolkit.createSection(parent, 320);
        section.setText(Messages.ScanConfigurationsOverviewEditorPage_STREAM_SECTION_TITLE);
        GridDataFactory.fillDefaults().grab(false, true).applyTo((Control)section);
        section.setLayout((Layout)new FillLayout());
        Composite composite = toolkit.createComposite((Composite)section);
        GridLayoutFactory.fillDefaults().margins(0, 0).applyTo(composite);
        section.setClient((Control)composite);
        this.streamViewer = new TableViewer(composite, 68356);
        GridDataFactory.fillDefaults().grab(true, true).hint(300, -1).applyTo((Control)this.streamViewer.getTable());
        this.streamViewer.setUseHashlookup(true);
        this.streamViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.streamViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                if (element instanceof StreamScanConfigurationPair) {
                    if (((StreamScanConfigurationPair)element).getScanConfiguration() == null) {
                        return Activator.getImage("/icons/obj16/stream.gif");
                    }
                    return Activator.getImage("/icons/obj16/streamWithScanConfig.gif");
                }
                return super.getImage(element);
            }

            public String getText(Object element) {
                if (element instanceof StreamScanConfigurationPair) {
                    StreamScanConfigurationPair pair = (StreamScanConfigurationPair)element;
                    if (ScanConfigurationsOverviewEditorPage.this.currentSelectedStreamInfo != null && ScanConfigurationsOverviewEditorPage.this.getEditor().isDirty() && ScanConfigurationsOverviewEditorPage.this.currentSelectedStreamInfo.getStream().sameItemId((IItemHandle)pair.getStream())) {
                        return "*" + pair.getStream().getName();
                    }
                    return pair.getStream().getName();
                }
                return super.getText(element);
            }
        });
        this.streamViewer.setComparator((ViewerComparator)new StreamScanConfigurationPairComparator());
        this.streamViewer.setInput((Object)Collections.EMPTY_LIST);
        this.streamViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)ScanConfigurationsOverviewEditorPage.this.streamViewer.getSelection();
                if (selection.isEmpty() || !(selection.getFirstElement() instanceof StreamScanConfigurationPair)) {
                    return;
                }
                if (ScanConfigurationsOverviewEditorPage.this.getEditor().isDirty()) {
                    if (MessageDialog.openQuestion((Shell)ScanConfigurationsOverviewEditorPage.this.streamViewer.getControl().getShell(), (String)Messages.CONFIRM_DIALOG_TITLE, (String)NLS.bind((String)Messages.ScanConfigurationsOverviewEditorPage_CONFIRM_SWITCH_STREAM, (Object)ScanConfigurationsOverviewEditorPage.this.currentSelectedStreamInfo.getStream().getName()))) {
                        ScanConfigurationsOverviewEditorPage.this.doSave(null);
                    } else {
                        ScanConfigurationsOverviewEditorPage.this.getEditor().setDirty(false);
                    }
                }
                ScanConfigurationsOverviewEditorPage.this.currentSelectedStreamInfo = (StreamScanConfigurationPair)selection.getFirstElement();
                ScanConfigurationsOverviewEditorPage.this.fetchScanConfiguration(false);
            }
        });
        this.streamViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                ShowScanResultsAction showResultsAction = new ShowScanResultsAction();
                showResultsAction.selectionChanged(null, (ISelection)new StructuredSelection((Object)ScanConfigurationsOverviewEditorPage.this.currentSelectedStreamInfo));
                showResultsAction.run();
            }
        });
        this.showOnlyStreamWithScanConfigurationFilter = new ShowOnlyStreamWithScanConfigurationFilter();
        this.showAllStreamFilter = new ShowAllStreamFilter();
        this.streamViewer.addFilter((ViewerFilter)this.showAllStreamFilter);
        MenuManager streamViewerPopupMenuManager = new MenuManager("#Popup");
        streamViewerPopupMenuManager.setRemoveAllWhenShown(true);
        streamViewerPopupMenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                if (ScanConfigurationsOverviewEditorPage.this.currentSelectedStreamInfo == null || ScanConfigurationsOverviewEditorPage.this.currentSelectedStreamInfo.getScanConfiguration() == null) {
                    return;
                }
                RequestScanAction requestAction = new RequestScanAction();
                requestAction.selectionChanged(null, (ISelection)new StructuredSelection((Object)ScanConfigurationsOverviewEditorPage.this.currentSelectedStreamInfo));
                manager.add((IAction)requestAction);
                ShowScanResultsAction showResultsAction = new ShowScanResultsAction();
                showResultsAction.selectionChanged(null, (ISelection)new StructuredSelection((Object)ScanConfigurationsOverviewEditorPage.this.currentSelectedStreamInfo));
                manager.add((IAction)showResultsAction);
                manager.add((IAction)new Action(Messages.ScanConfigurationsOverviewEditorPage_REMOVE_SCAN_CONFIGURATION_MENU_LABEL, Activator.getImageDescriptor("icons/elcl16/removeScanConfiguration.gif")){

                    public void run() {
                        if (MessageDialog.openConfirm((Shell)ScanConfigurationsOverviewEditorPage.this.getSite().getShell(), (String)Messages.CONFIRM_DIALOG_TITLE, (String)NLS.bind((String)Messages.ScanConfigurationsOverviewEditorPage_CONFIRM_REMOVE_SCAN_CONFIGURATION, (Object)ScanConfigurationsOverviewEditorPage.this.currentSelectedStreamInfo.getStream().getName()))) {
                            ScanConfigurationsOverviewEditorPage.this.deleteScanConfiguration(ScanConfigurationsOverviewEditorPage.this.currentSelectedStreamInfo.getScanConfiguration());
                        }
                    }
                });
            }
        });
        Menu mainMenu = streamViewerPopupMenuManager.createContextMenu(this.streamViewer.getControl());
        this.streamViewer.getTable().setMenu(mainMenu);
        this.createToolBarForStreamSection(section);
        return section;
    }

    private Section createScanConfigurationSection(Composite parent, Section streamSection2, FormToolkit toolkit) {
        Section scanConfigurationSection = toolkit.createSection(parent, 320);
        scanConfigurationSection.setText(Messages.ScanConfigurationsOverviewEditorPage_SCAN_CONFIGURATION_SECTION_TITLE);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)scanConfigurationSection);
        scanConfigurationSection.setLayout((Layout)new FillLayout());
        this.scanConfigurationComposite = toolkit.createComposite((Composite)scanConfigurationSection);
        this.scanConfigurationComposite.setBackground(Display.getDefault().getSystemColor(13));
        this.stackLayout = new StackLayout();
        this.scanConfigurationComposite.setLayout((Layout)this.stackLayout);
        scanConfigurationSection.setClient((Control)this.scanConfigurationComposite);
        this.emptyScanConfigurationContentComposite = this.createEmptyScanConfigurationContent(this.scanConfigurationComposite, toolkit);
        this.scanConfigurationContentComposite = this.createScanConfigurationContent(this.scanConfigurationComposite, toolkit);
        this.promptCreateScanConfigurationContentComposite = this.createPromptCreateScanConfigurationContent(this.scanConfigurationComposite, toolkit);
        this.stackLayout.topControl = this.emptyScanConfigurationContentComposite;
        this.scanConfigurationComposite.layout();
        this.createToolBarForScanConfigurationSection(scanConfigurationSection);
        return scanConfigurationSection;
    }

    private Composite createEmptyScanConfigurationContent(Composite parent, FormToolkit toolkit) {
        Composite composite = toolkit.createComposite(parent);
        composite.setLayout((Layout)new GridLayout(1, false));
        Text text = ScdUIUtil.createNonEditableText(composite, Messages.ScanConfigurationsOverviewEditorPage_EDIT_SCAN_CONFIGURATION_DESC, 4, toolkit);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)text);
        return composite;
    }

    private Composite createPromptCreateScanConfigurationContent(Composite parent, FormToolkit toolkit) {
        Composite composite = toolkit.createComposite(parent);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(composite);
        this.promptLabel = ScdUIUtil.createNonEditableText(composite, "", 64, toolkit);
        GridDataFactory.fillDefaults().span(1, 1).grab(true, false).applyTo((Control)this.promptLabel);
        Button createButton = toolkit.createButton(composite, Messages.ScanConfigurationsOverviewEditorPage_CREATE_LABEL, 0x800008);
        createButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ITeamRepository repository = (ITeamRepository)ScanConfigurationsOverviewEditorPage.this.currentSelectedStreamInfo.getStream().getOrigin();
                IScdClient scdClient = (IScdClient)repository.getClientLibrary(IScdClient.class);
                ScanConfigurationsOverviewEditorPage.this.currentSelectedStreamInfo.setScanConfiguration(scdClient.createDefaultScanConfiguration(ScanConfigurationsOverviewEditorPage.this.currentSelectedStreamInfo.getStream()));
                ScanConfigurationsOverviewEditorPage.this.refreshScanConfigurationUI(true);
            }
        });
        return composite;
    }

    private Composite createScanConfigurationContent(Composite parent, FormToolkit toolkit) {
        Composite composite = toolkit.createComposite(parent);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        Composite subComposite = toolkit.createComposite(composite);
        GridLayoutFactory.fillDefaults().margins(0, 0).numColumns(2).applyTo(subComposite);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)subComposite);
        ScdUIUtil.createNonEditableText(subComposite, Messages.ScanConfigurationsOverviewEditorPage_STREAM_LABEL, toolkit);
        this.streamHyperLink = ScdUIUtil.createWorkspaceLink(subComposite, null, toolkit, this.getSite().getPage());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.streamHyperLink);
        Label configurationTitleLabel = this.createTitleLabel(composite, Messages.ScanConfigurationsOverviewEditorPage_CONFIGURATION_SECTION_TITLE, toolkit);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)configurationTitleLabel);
        this.enableBackgroundScanCheckbox = toolkit.createButton(composite, Messages.ScanConfigurationsOverviewEditorPage_ENABLED_FOR_BACKGROUND_SCAN_LABEL, 32);
        GridDataFactory.fillDefaults().indent(15, -1).span(2, -1).applyTo((Control)this.enableBackgroundScanCheckbox);
        this.enableBackgroundScanCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ScanConfigurationsOverviewEditorPage.this.isOnlyRefresh) {
                    return;
                }
                ScanConfigurationsOverviewEditorPage.this.currentSelectedStreamInfo.getScanConfiguration().setBackgroundScanEnabled(ScanConfigurationsOverviewEditorPage.this.enableBackgroundScanCheckbox.getSelection());
                if (ScanConfigurationsOverviewEditorPage.this.delayIntervalLabel != null && !ScanConfigurationsOverviewEditorPage.this.delayIntervalLabel.isDisposed()) {
                    ScanConfigurationsOverviewEditorPage.this.delayIntervalLabel.setEnabled(ScanConfigurationsOverviewEditorPage.this.enableBackgroundScanCheckbox.getSelection());
                }
                if (ScanConfigurationsOverviewEditorPage.this.delayIntervalTextField != null && !ScanConfigurationsOverviewEditorPage.this.delayIntervalTextField.isDisposed()) {
                    ScanConfigurationsOverviewEditorPage.this.delayIntervalTextField.setEnabled(ScanConfigurationsOverviewEditorPage.this.enableBackgroundScanCheckbox.getSelection());
                }
                if (ScanConfigurationsOverviewEditorPage.this.runBackgroundScanOnlyIfChangesCheckbox != null && !ScanConfigurationsOverviewEditorPage.this.runBackgroundScanOnlyIfChangesCheckbox.isDisposed()) {
                    ScanConfigurationsOverviewEditorPage.this.runBackgroundScanOnlyIfChangesCheckbox.setEnabled(ScanConfigurationsOverviewEditorPage.this.enableBackgroundScanCheckbox.getSelection());
                }
                ScanConfigurationsOverviewEditorPage.this.getEditor().setDirty(true);
            }
        });
        this.delayIntervalLabel = ScdUIUtil.createNonEditableText(composite, Messages.ScanConfigurationsOverviewEditorPage_DELAY_INTERVAL_LABEL, toolkit);
        GridDataFactory.fillDefaults().indent(30, -1).applyTo((Control)this.delayIntervalLabel);
        this.delayIntervalTextField = toolkit.createText(composite, "", 2048);
        GridDataFactory.swtDefaults().hint(100, -1).grab(false, false).applyTo((Control)this.delayIntervalTextField);
        this.delayIntervalTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ScanConfigurationsOverviewEditorPage.this.isOnlyRefresh) {
                    return;
                }
                if (ScanConfigurationsOverviewEditorPage.this.validate()) {
                    ScanConfigurationsOverviewEditorPage.this.currentSelectedStreamInfo.getScanConfiguration().getScanScheduleEntry().setScanInterval(Long.parseLong(ScanConfigurationsOverviewEditorPage.this.delayIntervalTextField.getText()));
                }
                ScanConfigurationsOverviewEditorPage.this.getEditor().setDirty(true);
            }
        });
        this.runBackgroundScanOnlyIfChangesCheckbox = toolkit.createButton(composite, Messages.ScanConfigurationsOverviewEditorPage_RUN_BACKGROUND_ONLY_IF_CHANGES_LABEL, 32);
        GridDataFactory.fillDefaults().indent(30, -1).span(2, -1).applyTo((Control)this.runBackgroundScanOnlyIfChangesCheckbox);
        this.runBackgroundScanOnlyIfChangesCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ScanConfigurationsOverviewEditorPage.this.isOnlyRefresh) {
                    return;
                }
                ScanConfigurationsOverviewEditorPage.this.currentSelectedStreamInfo.getScanConfiguration().setBackgroundScanOnlyIfChanges(ScanConfigurationsOverviewEditorPage.this.runBackgroundScanOnlyIfChangesCheckbox.getSelection());
                ScanConfigurationsOverviewEditorPage.this.getEditor().setDirty(true);
            }
        });
        Text maxWaitTimeLabel = ScdUIUtil.createNonEditableText(composite, Messages.ScanConfigurationsOverviewEditorPage_MAX_WAITTIME_LABEL, toolkit);
        GridDataFactory.fillDefaults().indent(15, -1).applyTo((Control)maxWaitTimeLabel);
        this.maxWaitTimeTextField = toolkit.createText(composite, "", 2048);
        GridDataFactory.swtDefaults().hint(100, -1).grab(false, false).applyTo((Control)this.maxWaitTimeTextField);
        this.maxWaitTimeTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ScanConfigurationsOverviewEditorPage.this.isOnlyRefresh) {
                    return;
                }
                if (ScanConfigurationsOverviewEditorPage.this.validate()) {
                    ScanConfigurationsOverviewEditorPage.this.currentSelectedStreamInfo.getScanConfiguration().setMaxWaitTimeToScan(Long.parseLong(ScanConfigurationsOverviewEditorPage.this.maxWaitTimeTextField.getText()));
                }
                ScanConfigurationsOverviewEditorPage.this.getEditor().setDirty(true);
            }
        });
        this.continueOnErrorCheckbox = toolkit.createButton(composite, Messages.ScanConfigurationsOverviewEditorPage_CONTINUE_ON_ERROR, 32);
        GridDataFactory.fillDefaults().indent(15, -1).span(2, -1).applyTo((Control)this.continueOnErrorCheckbox);
        this.continueOnErrorCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ScanConfigurationsOverviewEditorPage.this.isOnlyRefresh) {
                    return;
                }
                ScanConfigurationsOverviewEditorPage.this.currentSelectedStreamInfo.getScanConfiguration().setContinueOnError(ScanConfigurationsOverviewEditorPage.this.continueOnErrorCheckbox.getSelection());
                ScanConfigurationsOverviewEditorPage.this.getEditor().setDirty(true);
            }
        });
        this.excludedComponentListViewer = new ComponentListComposite(composite, Messages.ScanConfigurationsOverviewEditorPage_EXCLUDED_COMPONENT_LABEL, Messages.ScanConfigurationsOverviewEditorPage_EXCLUDED_COMPONENT_DESC, toolkit);
        GridDataFactory.fillDefaults().indent(15, -1).span(2, 1).grab(true, false).applyTo((Control)this.excludedComponentListViewer.getComposite());
        this.excludedComponentListViewer.addComponentListChangedListener(new IComponentListChangedListener(){

            @Override
            public void componentListChanged(ComponentListChangedEvent event) {
                if (event.getType() == ComponentListChangedEvent.Type.ADD) {
                    ScanConfigurationsOverviewEditorPage.this.currentSelectedStreamInfo.getScanConfiguration().getComponents().clear();
                    ScanConfigurationsOverviewEditorPage.this.currentSelectedStreamInfo.getScanConfiguration().getComponents().addAll(event.getNewComponentList());
                } else {
                    List componentList = ScanConfigurationsOverviewEditorPage.this.currentSelectedStreamInfo.getScanConfiguration().getComponents();
                    ArrayList<IComponentEntry> removeList = new ArrayList<IComponentEntry>();
                    for (IComponentEntry componentEntry : componentList) {
                        for (IComponentEntry entryToRemove : event.getNewComponentList()) {
                            if (!componentEntry.getComponent().getItemId().equals((Object)entryToRemove.getComponent().getItemId())) continue;
                            removeList.add(componentEntry);
                        }
                    }
                    componentList.removeAll(removeList);
                }
                ScanConfigurationsOverviewEditorPage.this.getEditor().setDirty(true);
            }
        });
        Label pruningTitleLabel = this.createTitleLabel(composite, Messages.ScanConfigurationsOverviewEditorPage_PRUNING_SECTION_TITLE, toolkit);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)pruningTitleLabel);
        Text successToKeepLabel = ScdUIUtil.createNonEditableText(composite, Messages.ScanConfigurationsOverviewEditorPage_SUCCESSFUL_RESULTS_TO_KEEP_LABEL, toolkit);
        GridDataFactory.fillDefaults().indent(15, -1).applyTo((Control)successToKeepLabel);
        this.successToKeepSpinner = ScdUIUtil.createSpinner(composite, 0, 1, Integer.MAX_VALUE);
        GridDataFactory.swtDefaults().hint(50, -1).grab(false, false).applyTo((Control)this.successToKeepSpinner);
        this.successToKeepSpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ScanConfigurationsOverviewEditorPage.this.isOnlyRefresh) {
                    return;
                }
                if (ScanConfigurationsOverviewEditorPage.this.validate()) {
                    ScanConfigurationsOverviewEditorPage.this.currentSelectedStreamInfo.getScanConfiguration().getScanResultPruningPolicy().setSuccessfulResultsToKeep(ScanConfigurationsOverviewEditorPage.this.successToKeepSpinner.getSelection());
                }
                ScanConfigurationsOverviewEditorPage.this.getEditor().setDirty(true);
            }
        });
        Text warningToKeepLabel = ScdUIUtil.createNonEditableText(composite, Messages.ScanConfigurationsOverviewEditorPage_WARNING_RESULTS_TO_KEEP_LABEL, toolkit);
        GridDataFactory.fillDefaults().indent(15, -1).applyTo((Control)warningToKeepLabel);
        this.warningToKeepSpinner = ScdUIUtil.createSpinner(composite, 0, 1, Integer.MAX_VALUE);
        GridDataFactory.swtDefaults().hint(50, -1).grab(false, false).applyTo((Control)this.warningToKeepSpinner);
        this.warningToKeepSpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ScanConfigurationsOverviewEditorPage.this.isOnlyRefresh) {
                    return;
                }
                if (ScanConfigurationsOverviewEditorPage.this.validate()) {
                    ScanConfigurationsOverviewEditorPage.this.currentSelectedStreamInfo.getScanConfiguration().getScanResultPruningPolicy().setWarningResultsToKeep(Integer.valueOf(ScanConfigurationsOverviewEditorPage.this.warningToKeepSpinner.getText()).intValue());
                }
                ScanConfigurationsOverviewEditorPage.this.getEditor().setDirty(true);
            }
        });
        Text failedToKeepLabel = ScdUIUtil.createNonEditableText(composite, Messages.ScanConfigurationsOverviewEditorPage_FAILED_RESULTS_TO_KEEP_LABEL, toolkit);
        GridDataFactory.fillDefaults().indent(15, -1).applyTo((Control)failedToKeepLabel);
        this.failedToKeepSpinner = ScdUIUtil.createSpinner(composite, 0, 1, Integer.MAX_VALUE);
        GridDataFactory.swtDefaults().hint(50, -1).grab(false, false).applyTo((Control)this.failedToKeepSpinner);
        this.failedToKeepSpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ScanConfigurationsOverviewEditorPage.this.isOnlyRefresh) {
                    return;
                }
                if (ScanConfigurationsOverviewEditorPage.this.validate()) {
                    ScanConfigurationsOverviewEditorPage.this.currentSelectedStreamInfo.getScanConfiguration().getScanResultPruningPolicy().setFailedResultsToKeep(Integer.valueOf(ScanConfigurationsOverviewEditorPage.this.failedToKeepSpinner.getText()).intValue());
                }
                ScanConfigurationsOverviewEditorPage.this.getEditor().setDirty(true);
            }
        });
        Label advancedTitleLabel = this.createTitleLabel(composite, Messages.ScanConfigurationsOverviewEditorPage_ADVANCED_SECTION_TITLE, toolkit);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)advancedTitleLabel);
        Text scanArgumentLabel = ScdUIUtil.createNonEditableText(composite, Messages.ScanConfigurationsOverviewEditorPage_SCAN_ARGUMENTS_LABEL, toolkit);
        GridDataFactory.fillDefaults().indent(15, -1).applyTo((Control)scanArgumentLabel);
        this.scanArgumentField = toolkit.createText(composite, "", 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.scanArgumentField);
        this.scanArgumentField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ScanConfigurationsOverviewEditorPage.this.isOnlyRefresh) {
                    return;
                }
                ScanConfigurationsOverviewEditorPage.this.currentSelectedStreamInfo.getScanConfiguration().setScanArguments(ScanConfigurationsOverviewEditorPage.this.scanArgumentField.getText().trim());
                ScanConfigurationsOverviewEditorPage.this.getEditor().setDirty(true);
            }
        });
        return composite;
    }

    protected void refreshStreamList() {
        if (this.getEditor().getStreamScanConfigurationPairs() != null) {
            this.streamViewer.setInput(this.getEditor().getStreamScanConfigurationPairs());
        } else {
            this.streamViewer.setInput((Object)Collections.EMPTY_LIST);
        }
        this.refreshStreamViewer();
        if (this.currentSelectedStreamInfo != null) {
            this.streamViewer.setSelection((ISelection)new StructuredSelection((Object)this.currentSelectedStreamInfo));
        }
    }

    protected void refreshStreamViewer() {
        this.streamViewer.refresh();
    }

    private void createToolBarForStreamSection(Section section) {
        ToolBar toolBar = new ToolBar((Composite)section, 0x800200);
        ToolItem toolItem = new ToolItem(toolBar, 4);
        toolItem.setImage(Activator.getImage("/icons/elcl16/filter_ps.gif"));
        section.setTextClient((Control)toolBar);
        final Menu menu = new Menu((Control)toolBar.getShell());
        final MenuItem showAllMenu = new MenuItem(menu, 32);
        showAllMenu.setText(Messages.ScanConfigurationsOverviewEditorPage_SHOW_ALL_STREAM_LABEL);
        showAllMenu.setSelection(true);
        showAllMenu.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (showAllMenu.getSelection()) {
                    ScanConfigurationsOverviewEditorPage.this.streamViewer.removeFilter((ViewerFilter)ScanConfigurationsOverviewEditorPage.this.showOnlyStreamWithScanConfigurationFilter);
                    ScanConfigurationsOverviewEditorPage.this.streamViewer.addFilter((ViewerFilter)ScanConfigurationsOverviewEditorPage.this.showAllStreamFilter);
                } else {
                    ScanConfigurationsOverviewEditorPage.this.streamViewer.removeFilter((ViewerFilter)ScanConfigurationsOverviewEditorPage.this.showAllStreamFilter);
                    ScanConfigurationsOverviewEditorPage.this.streamViewer.addFilter((ViewerFilter)ScanConfigurationsOverviewEditorPage.this.showOnlyStreamWithScanConfigurationFilter);
                }
            }
        });
        toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ToolItem item = (ToolItem)event.widget;
                Rectangle rect = item.getBounds();
                Point pt = item.getParent().toDisplay(new Point(rect.x, rect.y));
                menu.setLocation(pt.x, pt.y + rect.height);
                menu.setVisible(true);
            }
        });
    }

    private void createToolBarForScanConfigurationSection(Section section) {
        ToolBar toolBar = new ToolBar((Composite)section, 0x800100);
        this.runScanToolItem = new ToolItem(toolBar, 8);
        this.runScanToolItem.setImage(Activator.getImage("icons/elcl16/requestScan.gif"));
        this.runScanToolItem.setDisabledImage(Activator.getImage("icons/dlcl16/requestScan.gif"));
        this.runScanToolItem.setToolTipText(Messages.RequestScanAction_LABEL);
        this.runScanToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RequestScanAction requestAction = new RequestScanAction();
                requestAction.selectionChanged(null, (ISelection)new StructuredSelection((Object)ScanConfigurationsOverviewEditorPage.this.currentSelectedStreamInfo));
                requestAction.run();
            }
        });
        this.showResultsToolItem = new ToolItem(toolBar, 8);
        this.showResultsToolItem.setImage(Activator.getImage("icons/elcl16/showScanResults.gif"));
        this.showResultsToolItem.setDisabledImage(Activator.getImage("icons/dlcl16/showScanResults.gif"));
        this.showResultsToolItem.setToolTipText(Messages.ShowScanResultsAction_LABEL);
        this.showResultsToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ShowScanResultsAction showResultsAction = new ShowScanResultsAction();
                showResultsAction.selectionChanged(null, (ISelection)new StructuredSelection((Object)ScanConfigurationsOverviewEditorPage.this.currentSelectedStreamInfo));
                showResultsAction.run();
            }
        });
        this.saveScanConfigurationToolItem = new ToolItem(toolBar, 8);
        this.saveScanConfigurationToolItem.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_ETOOL_SAVE_EDIT"));
        this.saveScanConfigurationToolItem.setDisabledImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_ETOOL_SAVE_EDIT_DISABLED"));
        this.saveScanConfigurationToolItem.setToolTipText(Messages.ScanConfigurationsOverviewEditorPage_SAVE_TOOLITM_DESC);
        this.saveScanConfigurationToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScanConfigurationsOverviewEditorPage.this.doSave(null);
            }
        });
        this.removeScanConfigurationToolItem = new ToolItem(toolBar, 8);
        this.removeScanConfigurationToolItem.setImage(Activator.getImage("icons/elcl16/removeScanConfiguration.gif"));
        this.removeScanConfigurationToolItem.setDisabledImage(Activator.getImage("icons/dlcl16/removeScanConfiguration.gif"));
        this.removeScanConfigurationToolItem.setToolTipText(Messages.ScanConfigurationsOverviewEditorPage_REMOVE_SCAN_CONFIGURATION_MENU_LABEL);
        this.removeScanConfigurationToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MessageDialog.openConfirm((Shell)ScanConfigurationsOverviewEditorPage.this.getSite().getShell(), (String)Messages.CONFIRM_DIALOG_TITLE, (String)NLS.bind((String)Messages.ScanConfigurationsOverviewEditorPage_CONFIRM_REMOVE_SCAN_CONFIGURATION, (Object)ScanConfigurationsOverviewEditorPage.this.currentSelectedStreamInfo.getStream().getName()))) {
                    ScanConfigurationsOverviewEditorPage.this.deleteScanConfiguration(ScanConfigurationsOverviewEditorPage.this.currentSelectedStreamInfo.getScanConfiguration());
                }
            }
        });
        this.updateScanConfigurationToolItems();
        section.setTextClient((Control)toolBar);
    }

    public void updateScanConfigurationToolItems() {
        if (this.saveScanConfigurationToolItem != null && !this.saveScanConfigurationToolItem.isDisposed()) {
            this.saveScanConfigurationToolItem.setEnabled(this.getEditor().isDirty());
        }
        if (this.runScanToolItem != null && !this.runScanToolItem.isDisposed()) {
            if (this.currentSelectedStreamInfo == null || this.currentSelectedStreamInfo.getScanConfiguration() == null) {
                this.runScanToolItem.setEnabled(false);
            } else {
                this.runScanToolItem.setEnabled(!this.currentSelectedStreamInfo.getScanConfiguration().isNewItem());
            }
        }
        if (this.showResultsToolItem != null && !this.showResultsToolItem.isDisposed()) {
            if (this.currentSelectedStreamInfo == null || this.currentSelectedStreamInfo.getScanConfiguration() == null) {
                this.showResultsToolItem.setEnabled(false);
            } else {
                this.showResultsToolItem.setEnabled(!this.currentSelectedStreamInfo.getScanConfiguration().isNewItem());
            }
        }
        if (this.removeScanConfigurationToolItem != null && !this.removeScanConfigurationToolItem.isDisposed()) {
            if (this.currentSelectedStreamInfo == null || this.currentSelectedStreamInfo.getScanConfiguration() == null) {
                this.removeScanConfigurationToolItem.setEnabled(false);
            } else {
                this.removeScanConfigurationToolItem.setEnabled(this.currentSelectedStreamInfo.getScanConfiguration() != null);
            }
        }
    }

    private Label createTitleLabel(Composite parent, String value, FormToolkit toolkit) {
        Label label = toolkit.createLabel(parent, value);
        label.setLayoutData((Object)new GridData(768));
        label.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
        return label;
    }

    public ScanConfigurationsEditor getEditor() {
        return (ScanConfigurationsEditor)super.getEditor();
    }

    protected boolean validate() {
        IStatus status;
        boolean isOK = true;
        this.getEditor().clearAllMessages();
        if (this.enableBackgroundScanCheckbox.getSelection()) {
            status = ScdUIUtil.delayIntervalValidator.validate((Object)this.delayIntervalTextField.getText());
            if (!status.isOK()) {
                this.getEditor().addErrorMessage((Control)this.delayIntervalTextField, NLS.bind((String)Messages.ScanConfigurationsOverviewEditorPage_DELAY_INTERVAL_VALIDATION_ERROR, (Object)status.getMessage()));
                isOK = false;
            } else {
                this.getEditor().clearMessages((Control)this.delayIntervalTextField);
            }
        }
        if (!(status = ScdUIUtil.maxWaitTimeValidator.validate((Object)this.maxWaitTimeTextField.getText())).isOK()) {
            this.getEditor().addErrorMessage((Control)this.maxWaitTimeTextField, status.getMessage());
            isOK = false;
        } else {
            this.getEditor().clearMessages((Control)this.maxWaitTimeTextField);
        }
        status = ScdUIUtil.scanResultsToKeepValidator.validate((Object)this.successToKeepSpinner.getText());
        if (!status.isOK()) {
            this.getEditor().addErrorMessage((Control)this.successToKeepSpinner, status.getMessage());
            isOK = false;
        } else {
            this.getEditor().clearMessages((Control)this.successToKeepSpinner);
        }
        status = ScdUIUtil.scanResultsToKeepValidator.validate((Object)this.warningToKeepSpinner.getText());
        if (!status.isOK()) {
            this.getEditor().addErrorMessage((Control)this.warningToKeepSpinner, status.getMessage());
            isOK = false;
        } else {
            this.getEditor().clearMessages((Control)this.warningToKeepSpinner);
        }
        status = ScdUIUtil.scanResultsToKeepValidator.validate((Object)this.failedToKeepSpinner.getText());
        if (!status.isOK()) {
            this.getEditor().addErrorMessage((Control)this.failedToKeepSpinner, status.getMessage());
            isOK = false;
        } else {
            this.getEditor().clearMessages((Control)this.failedToKeepSpinner);
        }
        return isOK;
    }

    public void refreshScanConfigurationUI(boolean isEditorDirty) {
        this.isOnlyRefresh = true;
        this.getEditor().clearAllMessages();
        this.getEditor().setDirty(isEditorDirty);
        if (this.currentSelectedStreamInfo == null) {
            this.stackLayout.topControl = this.emptyScanConfigurationContentComposite;
        } else if (this.currentSelectedStreamInfo.getScanConfiguration() == null) {
            this.promptLabel.setText(NLS.bind((String)Messages.ScanConfigurationsOverviewEditorPage_CREATE_DEFAULT_SCAN_CONFIGURATION_PROMPT, (Object)this.currentSelectedStreamInfo.getStream().getName()));
            this.stackLayout.topControl = this.promptCreateScanConfigurationContentComposite;
        } else {
            this.streamHyperLink.setHref((Object)this.currentSelectedStreamInfo.getStream());
            this.streamHyperLink.setText(this.currentSelectedStreamInfo.getStream().getName());
            IScanConfiguration scanConfiguration = this.currentSelectedStreamInfo.getScanConfiguration();
            this.enableBackgroundScanCheckbox.setSelection(scanConfiguration.isBackgroundScanEnabled());
            this.delayIntervalTextField.setEnabled(scanConfiguration.isBackgroundScanEnabled());
            this.delayIntervalTextField.setText(String.valueOf(scanConfiguration.getScanScheduleEntry().getScanInterval()));
            this.runBackgroundScanOnlyIfChangesCheckbox.setEnabled(scanConfiguration.isBackgroundScanEnabled());
            this.runBackgroundScanOnlyIfChangesCheckbox.setSelection(scanConfiguration.isBackgroundScanOnlyIfChanges());
            this.maxWaitTimeTextField.setText(String.valueOf(scanConfiguration.getMaxWaitTimeToScan()));
            this.continueOnErrorCheckbox.setSelection(scanConfiguration.isContinueOnError());
            this.excludedComponentListViewer.setInput(scanConfiguration);
            this.excludedComponentListViewer.updateButtonStates();
            this.successToKeepSpinner.setSelection(scanConfiguration.getScanResultPruningPolicy().getSuccessfulResultsToKeep());
            this.warningToKeepSpinner.setSelection(scanConfiguration.getScanResultPruningPolicy().getWarningResultsToKeep());
            this.failedToKeepSpinner.setSelection(scanConfiguration.getScanResultPruningPolicy().getFailedResultsToKeep());
            this.scanArgumentField.setText(scanConfiguration.getScanArguments() == null ? "" : scanConfiguration.getScanArguments());
            this.stackLayout.topControl = this.scanConfigurationContentComposite;
        }
        this.isOnlyRefresh = false;
        this.updateScanConfigurationToolItems();
        this.scanConfigurationComposite.layout();
    }

    public void refreshScanConfiguration(IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.currentSelectedStreamInfo != null && this.currentSelectedStreamInfo.getScanConfiguration() != null) {
            try {
                ITeamRepository repository = (ITeamRepository)this.currentSelectedStreamInfo.getStream().getOrigin();
                this.currentSelectedStreamInfo.setScanConfiguration((IScanConfiguration)repository.itemManager().fetchCompleteItem((IItemHandle)this.currentSelectedStreamInfo.getScanConfiguration(), 1, monitor).getWorkingCopy());
                this.fetchComponentEntries(this.currentSelectedStreamInfo.getScanConfiguration(), monitor);
            }
            catch (ItemNotFoundException e) {
                this.currentSelectedStreamInfo.setScanConfiguration(null);
            }
        }
    }

    private void fetchScanConfiguration(final boolean isEditorDirty) {
        Job job = new Job(""){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    ScanConfigurationsOverviewEditorPage.this.refreshScanConfiguration(monitor);
                }
                catch (TeamRepositoryException e) {
                    return new Status(4, "com.ibm.team.enterprise.scd.ide.ui", e.getLocalizedMessage(), (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                ScanConfigurationsOverviewEditorPage.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ScanConfigurationsOverviewEditorPage.this.refreshScanConfigurationUI(isEditorDirty);
                    }
                });
            }
        });
        job.schedule();
    }

    public void setFocus() {
        if (this.streamViewer != null && !this.streamViewer.getTable().isDisposed()) {
            this.streamViewer.getTable().setFocus();
        } else {
            super.setFocus();
        }
    }

    public void doSave(IProgressMonitor monitor) {
        final Job job = new Job(""){

            protected IStatus run(IProgressMonitor monitor) {
                if (ScanConfigurationsOverviewEditorPage.this.currentSelectedStreamInfo != null && ScanConfigurationsOverviewEditorPage.this.currentSelectedStreamInfo.getScanConfiguration() != null) {
                    try {
                        ITeamRepository repository = (ITeamRepository)ScanConfigurationsOverviewEditorPage.this.currentSelectedStreamInfo.getStream().getOrigin();
                        IScdClient scdClient = (IScdClient)repository.getClientLibrary(IScdClient.class);
                        ScanConfigurationsOverviewEditorPage.this.currentSelectedStreamInfo.setScanConfiguration((IScanConfiguration)scdClient.saveScanConfiguration(ScanConfigurationsOverviewEditorPage.this.currentSelectedStreamInfo.getScanConfiguration()).getWorkingCopy());
                        ScanConfigurationsOverviewEditorPage.this.fetchComponentEntries(ScanConfigurationsOverviewEditorPage.this.currentSelectedStreamInfo.getScanConfiguration(), monitor);
                    }
                    catch (StaleDataException e) {
                        return new Status(8, "com.ibm.team.enterprise.scd.ide.ui", Messages.ScanConfigurationsOverviewEditorPage_ERROR_SAVE_STALE_DATA, null);
                    }
                    catch (TeamRepositoryException e) {
                        return new Status(8, "com.ibm.team.enterprise.scd.ide.ui", e.getLocalizedMessage(), (Throwable)e);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                ScanConfigurationsOverviewEditorPage.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        IStatus status = job.getResult();
                        if (status.getSeverity() == 8) {
                            ScanConfigurationsOverviewEditorPage.this.getEditor().setEditorErrorMessage(NLS.bind((String)Messages.ScanConfigurationsOverviewEditorPage_ERROR_SAVE, (Object)status.getMessage()));
                            return;
                        }
                        ScanConfigurationsOverviewEditorPage.this.streamViewer.refresh();
                        ScanConfigurationsOverviewEditorPage.this.refreshScanConfigurationUI(false);
                    }
                });
            }
        });
        if (!this.validate()) {
            return;
        }
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void deleteScanConfiguration(final IScanConfiguration scanConfiguration) {
        final Job job = new Job(""){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    ITeamRepository repository = (ITeamRepository)ScanConfigurationsOverviewEditorPage.this.currentSelectedStreamInfo.getStream().getOrigin();
                    IScdClient scdClient = (IScdClient)repository.getClientLibrary(IScdClient.class);
                    scdClient.deleteScanConfiguration(scanConfiguration);
                    ScanConfigurationsOverviewEditorPage.this.currentSelectedStreamInfo.setScanConfiguration(null);
                }
                catch (TeamRepositoryException e) {
                    return new Status(8, "com.ibm.team.enterprise.scd.ide.ui", e.getLocalizedMessage(), (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                ScanConfigurationsOverviewEditorPage.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        IStatus status = job.getResult();
                        if (status.getSeverity() == 8) {
                            ScanConfigurationsOverviewEditorPage.this.getEditor().setEditorErrorMessage(NLS.bind((String)Messages.ScanConfigurationsOverviewEditorPage_ERROR_DELETE, (Object)status.getMessage()));
                            return;
                        }
                        ScanConfigurationsOverviewEditorPage.this.refreshScanConfigurationUI(false);
                    }
                });
            }
        });
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void fetchComponentEntries(IScanConfiguration scanConfiguration, IProgressMonitor monitor) throws TeamRepositoryException {
        List componentEntries = scanConfiguration.getComponents();
        ArrayList<IComponentHandle> componentHandles = new ArrayList<IComponentHandle>();
        for (ComponentEntry componentEntry : componentEntries) {
            componentHandles.add(componentEntry.getComponent());
        }
        ITeamRepository repository = (ITeamRepository)scanConfiguration.getOrigin();
        IFetchResult fetchResult = repository.itemManager().fetchCompleteItemsPermissionAware(componentHandles, 0, monitor);
        HashMap<UUID, IComponent> componentMap = new HashMap<UUID, IComponent>();
        for (Object object : fetchResult.getRetrievedItems()) {
            IComponent component = (IComponent)object;
            componentMap.put(component.getItemId(), component);
        }
        for (ComponentEntry componentEntry : componentEntries) {
            componentEntry.setComponent((IComponentHandle)componentMap.get(componentEntry.getComponent().getItemId()));
        }
    }

    class ShowAllStreamFilter
    extends ViewerFilter {
        ShowAllStreamFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return element instanceof StreamScanConfigurationPair;
        }
    }

    class ShowOnlyStreamWithScanConfigurationFilter
    extends ViewerFilter {
        ShowOnlyStreamWithScanConfigurationFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return element instanceof StreamScanConfigurationPair && ((StreamScanConfigurationPair)element).getScanConfiguration() != null;
        }
    }

    class StreamScanConfigurationPairComparator
    extends ViewerComparator {
        StreamScanConfigurationPairComparator() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 != null && e2 != null) {
                StreamScanConfigurationPair info1 = (StreamScanConfigurationPair)e1;
                StreamScanConfigurationPair info2 = (StreamScanConfigurationPair)e2;
                return info1.getStream().getName().compareTo(info2.getStream().getName());
            }
            return super.compare(viewer, e1, e2);
        }
    }
}

