/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.scd.ide.ui.editor;

import com.ibm.team.enterprise.scd.ide.ui.Activator;
import com.ibm.team.enterprise.scd.ide.ui.ScdUIUtil;
import com.ibm.team.enterprise.scd.ide.ui.action.RefreshScanConfigurationEditorAction;
import com.ibm.team.enterprise.scd.ide.ui.action.ShowScanResultsForProjectAreaAction;
import com.ibm.team.enterprise.scd.ide.ui.editor.AbstractScdEditor;
import com.ibm.team.enterprise.scd.ide.ui.editor.ErrorMessageHyperlinkListener;
import com.ibm.team.enterprise.scd.ide.ui.editor.ScanConfigurationsEditorInput;
import com.ibm.team.enterprise.scd.ide.ui.editor.ScanConfigurationsOverviewEditorPage;
import com.ibm.team.enterprise.scd.ide.ui.helper.ScdJob;
import com.ibm.team.enterprise.scd.ide.ui.helper.StreamScanConfigurationPair;
import com.ibm.team.enterprise.scd.internal.ide.ui.nls.Messages;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ScanConfigurationsEditor
extends AbstractScdEditor {
    protected static final String EDITOR_ERROR_ID = "editorErrorId";
    private IMessageManager messageManager;
    private IProjectArea projectArea;
    private List<StreamScanConfigurationPair> streamScanConfigurationPairs;
    private Text projectAreaNameField;
    private ShowScanResultsForProjectAreaAction showProjectAreaScanResultsAction;
    private RefreshScanConfigurationEditorAction refreshEditorAction;
    private ScanConfigurationsOverviewEditorPage overviewPage;

    protected void createHeaderContents(IManagedForm headerForm) {
        Form form = headerForm.getForm().getForm();
        form.setText(Messages.ScanConfigurationsEditor_TITLE);
        form.setImage(null);
        FormToolkit toolkit = headerForm.getToolkit();
        this.contributeToToolbar(form.getToolBarManager());
        this.messageManager = headerForm.getMessageManager();
        this.messageManager.setDecorationPosition(16512);
        form.addMessageHyperlinkListener((IHyperlinkListener)new ErrorMessageHyperlinkListener(this));
        Composite head = headerForm.getForm().getForm().getHead();
        Composite container = toolkit.createComposite(head);
        container.setLayoutData((Object)new FormAttachment());
        container.setLayout((Layout)new GridLayout(2, false));
        container.setBackground(null);
        toolkit.createLabel(container, Messages.ScanConfigurationsEditor_PROJECT_AREA_LABEL).setBackground(null);
        this.projectAreaNameField = toolkit.createText(container, "", 2056);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.projectAreaNameField);
        headerForm.getForm().setHeadClient((Control)container);
        this.addPropertyListener(new IPropertyListener(){

            public void propertyChanged(Object source, int propertyId) {
                if (source instanceof IEditorPart && propertyId == 257) {
                    ScanConfigurationsEditor.this.overviewPage.updateScanConfigurationToolItems();
                    ScanConfigurationsEditor.this.overviewPage.refreshStreamViewer();
                }
            }
        });
        this.runInitialFetchJob();
    }

    @Override
    protected void doInitialFetch(IProgressMonitor monitor) throws TeamRepositoryException {
        this.fetchScanConfigurationList(monitor);
    }

    public void refreshEditor() {
        if (this.isDirty() && !MessageDialog.openConfirm((Shell)this.getSite().getShell(), (String)Messages.CONFIRM_DIALOG_TITLE, (String)Messages.ScanConfigurationsOverviewEditorPage_CONFIRM_REFRESH)) {
            return;
        }
        ScdJob<Object> job = new ScdJob<Object>("Refresh scan configurations editor"){

            @Override
            protected void preRunUIJob() {
                ScanConfigurationsEditor.this.setBusy(true);
                ScanConfigurationsEditor.this.getSite().getShell().setCursor(Display.getCurrent().getSystemCursor(1));
            }

            @Override
            protected Object runBackgroundJob(IProgressMonitor monitor) throws TeamRepositoryException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                ScanConfigurationsEditor.this.fetchScanConfigurationList((IProgressMonitor)progress.newChild(50));
                ScanConfigurationsEditor.this.overviewPage.refreshScanConfiguration((IProgressMonitor)progress.newChild(50));
                return null;
            }

            @Override
            protected void runUIJobOnSuccess() {
                ScanConfigurationsEditor.this.setDirty(false);
                ScanConfigurationsEditor.this.overviewPage.refreshStreamList();
                ScanConfigurationsEditor.this.overviewPage.refreshScanConfigurationUI(ScanConfigurationsEditor.this.isDirty());
                ScanConfigurationsEditor.this.setBusy(false);
                ScanConfigurationsEditor.this.getSite().getShell().setCursor(null);
            }

            @Override
            protected void runUIJobOnFailure() {
                ScanConfigurationsEditor.this.setBusy(false);
                ScanConfigurationsEditor.this.getSite().getShell().setCursor(null);
            }
        };
        job.schedule();
    }

    private void fetchScanConfigurationList(IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IProjectAreaHandle projectAreaHandle = (IProjectAreaHandle)this.getEditorInput().getAdapter(IProjectAreaHandle.class);
        ITeamRepository repository = (ITeamRepository)projectAreaHandle.getOrigin();
        this.projectArea = (IProjectArea)repository.itemManager().fetchPartialItem((IItemHandle)projectAreaHandle, 1, Arrays.asList("name"), (IProgressMonitor)progress.newChild(30));
        if (this.streamScanConfigurationPairs != null) {
            this.streamScanConfigurationPairs.clear();
        } else {
            this.streamScanConfigurationPairs = new ArrayList<StreamScanConfigurationPair>();
        }
        this.streamScanConfigurationPairs.addAll(ScdUIUtil.getStreamScanConfigurationPairs((IProjectAreaHandle)this.projectArea, false, (IProgressMonitor)progress.newChild(70)));
    }

    private void contributeToToolbar(IToolBarManager toolbarManager) {
        this.showProjectAreaScanResultsAction = new ShowScanResultsForProjectAreaAction();
        this.showProjectAreaScanResultsAction.setActivePart(null, (IWorkbenchPart)this.getActiveEditor());
        this.showProjectAreaScanResultsAction.selectionChanged(null, (ISelection)new StructuredSelection());
        this.showProjectAreaScanResultsAction.setEnabled(false);
        toolbarManager.add((IAction)this.showProjectAreaScanResultsAction);
        this.refreshEditorAction = new RefreshScanConfigurationEditorAction(this);
        this.refreshEditorAction.setEnabled(true);
        toolbarManager.add((IAction)this.refreshEditorAction);
        toolbarManager.update(true);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
    }

    @Override
    protected void refreshUI() {
        this.projectAreaNameField.setText(this.projectArea.getName());
        this.showProjectAreaScanResultsAction.selectionChanged(null, (ISelection)new StructuredSelection((Object)this.projectArea));
        this.showProjectAreaScanResultsAction.setEnabled(true);
        this.overviewPage.refreshStreamList();
    }

    @Override
    protected void addPages() {
        try {
            this.overviewPage = new ScanConfigurationsOverviewEditorPage(this);
            this.addPage((IFormPage)this.overviewPage);
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)Messages.ERROR_DIALOG_TITLE, (String)NLS.bind((String)Messages.ERROR_OPEN_EDITOR, (Object)this.getEditorInput().getName(), (Object)e.getLocalizedMessage()));
            Activator.log(e);
        }
    }

    public void addErrorMessage(Control control, String errorMessage) {
        this.messageManager.addMessage((Object)control, errorMessage, null, 3, control);
    }

    public void clearAllMessages() {
        this.messageManager.removeAllMessages();
    }

    public void clearMessages(Control control) {
        this.messageManager.removeMessages(control);
    }

    public void setEditorErrorMessage(String errorMessage) {
        this.messageManager.addMessage((Object)EDITOR_ERROR_ID, errorMessage, null, 3);
    }

    public void clearEditorErrorMessage() {
        this.messageManager.removeMessage((Object)EDITOR_ERROR_ID);
    }

    public ScanConfigurationsEditorInput getEditorInput() {
        return (ScanConfigurationsEditorInput)super.getEditorInput();
    }

    public List<StreamScanConfigurationPair> getStreamScanConfigurationPairs() {
        return this.streamScanConfigurationPairs;
    }
}

