/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.scd.ide.ui.editor;

import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.ui.editor.TeamFormEditor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;

public abstract class AbstractScdEditor
extends TeamFormEditor {
    private int busyCount;
    private boolean isDisposed;
    private boolean isDirty;

    protected abstract void doInitialFetch(IProgressMonitor var1) throws TeamRepositoryException;

    protected abstract void refreshUI();

    protected void runInitialFetchJob() {
        Job fetchJob = new Job(""){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    AbstractScdEditor.this.doInitialFetch(monitor);
                }
                catch (TeamRepositoryException e) {
                    return new Status(4, "com.ibm.team.enterprise.scd.ide.ui", e.getLocalizedMessage(), (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        fetchJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void aboutToRun(IJobChangeEvent event) {
                AbstractScdEditor.this.setBusyFromBackgroundJob(true);
            }

            public void done(IJobChangeEvent event) {
                AbstractScdEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        AbstractScdEditor.this.refreshUI();
                        AbstractScdEditor.this.setBusy(false);
                    }
                });
            }
        });
        fetchJob.schedule();
    }

    protected void setBusyFromBackgroundJob(final boolean isBusy) {
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                AbstractScdEditor.this.setBusy(isBusy);
            }
        });
    }

    protected void setBusy(boolean isBusy) {
        if (!this.isDisposed()) {
            if (this.busyCount == 0 && isBusy) {
                this.getHeaderForm().getForm().setBusy(true);
            } else if (this.busyCount == 1 && !isBusy) {
                this.getHeaderForm().getForm().setBusy(false);
            }
            if (isBusy) {
                ++this.busyCount;
            } else if (this.busyCount > 0) {
                --this.busyCount;
            }
        }
    }

    public final boolean isDisposed() {
        return this.isDisposed;
    }

    public void dispose() {
        this.isDisposed = true;
        super.dispose();
    }

    protected void addPages() {
    }

    public final void doSaveAs() {
    }

    public final boolean isSaveAsAllowed() {
        return false;
    }

    public final void setDirty(boolean value) {
        this.isDirty = value;
        this.firePropertyChange(257);
    }

    public boolean isDirty() {
        return this.isDirty;
    }
}

