/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.scd.ide.ui.action;

import com.ibm.team.enterprise.scd.common.model.IScanConfigurationHandle;
import com.ibm.team.enterprise.scd.ide.ui.Activator;
import com.ibm.team.enterprise.scd.ide.ui.ScdUIUtil;
import com.ibm.team.enterprise.scd.ide.ui.helper.ScdJob;
import com.ibm.team.enterprise.scd.ide.ui.helper.StreamScanConfigurationPair;
import com.ibm.team.enterprise.scd.ide.ui.view.ScanQueryView;
import com.ibm.team.enterprise.scd.internal.ide.ui.nls.Messages;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class ShowScanResultsForProjectAreaAction
extends Action
implements IObjectActionDelegate {
    private IProjectArea projectArea;
    private IWorkbenchPart workbench;

    public ShowScanResultsForProjectAreaAction() {
        super(Messages.ShowScanResultsAction_LABEL);
        this.setImageDescriptor(Activator.getImageDescriptor("icons/elcl16/showScanResults.gif"));
        this.setDisabledImageDescriptor(Activator.getImageDescriptor("icons/dlcl16/showScanResults.gif"));
    }

    public void run() {
        this.run(null);
    }

    public void run(IAction action) {
        Shell activeShell = this.workbench == null ? Display.getCurrent().getActiveShell() : this.workbench.getSite().getShell();
        if (this.projectArea == null) {
            MessageDialog.openError((Shell)activeShell, (String)Messages.ERROR_DIALOG_TITLE, (String)Messages.ShowScanResultsForProjectAreaAction_ERROR_NO_PROJECT_AREA);
            return;
        }
        new ScdJob<List<IScanConfigurationHandle>>(""){

            @Override
            protected List<IScanConfigurationHandle> runBackgroundJob(IProgressMonitor monitor) throws TeamRepositoryException {
                List<StreamScanConfigurationPair> pairs = ScdUIUtil.getStreamScanConfigurationPairs((IProjectAreaHandle)ShowScanResultsForProjectAreaAction.this.projectArea, true, null);
                ArrayList<IScanConfigurationHandle> scanConfigurations = new ArrayList<IScanConfigurationHandle>(pairs.size());
                for (StreamScanConfigurationPair pair : pairs) {
                    scanConfigurations.add((IScanConfigurationHandle)pair.getScanConfiguration());
                }
                return scanConfigurations;
            }

            @Override
            protected void runUIJobOnSuccess() {
                ScanQueryView.openQueryView((List)this.data, ShowScanResultsForProjectAreaAction.this.projectArea);
            }
        }.schedule();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object obj;
        this.projectArea = null;
        if (selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) instanceof IProjectArea) {
            this.projectArea = (IProjectArea)obj;
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.workbench = targetPart;
    }
}

